/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TaskOutputParameterParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskOutputParameterParser.class);
    private final int maxOneParameterRows;
    private final int maxOneParameterLength;
    private final Map<String, String> taskOutputParams;
    private List<String> currentTaskOutputParam;
    private long currentTaskOutputParamLength;

    public TaskOutputParameterParser() {
        this(1024, Integer.MAX_VALUE);
    }

    public TaskOutputParameterParser(int maxOneParameterRows, int maxOneParameterLength) {
        this.maxOneParameterRows = maxOneParameterRows;
        this.maxOneParameterLength = maxOneParameterLength;
        this.taskOutputParams = new HashMap<String, String>();
        this.currentTaskOutputParam = null;
        this.currentTaskOutputParamLength = 0L;
    }

    public void appendParseLog(String logLine) {
        if (logLine == null) {
            return;
        }
        if (this.currentTaskOutputParam != null) {
            if (this.currentTaskOutputParam.size() > this.maxOneParameterRows || this.currentTaskOutputParamLength > (long)this.maxOneParameterLength) {
                log.warn("The output param expression '{}' is too long, the max rows is {}, max length is {}, will skip this param", new Object[]{String.join((CharSequence)"\n", this.currentTaskOutputParam), this.maxOneParameterLength, this.maxOneParameterRows});
                this.currentTaskOutputParam = null;
                this.currentTaskOutputParamLength = 0L;
                return;
            }
            int i = logLine.indexOf(")}");
            if (i == -1) {
                this.currentTaskOutputParam.add(logLine);
                this.currentTaskOutputParamLength += (long)logLine.length();
            } else {
                this.currentTaskOutputParam.add(logLine.substring(0, i + 2));
                Pair<String, String> keyValue = this.parseOutputParam(String.join((CharSequence)"\n", this.currentTaskOutputParam));
                if (keyValue.getKey() != null && keyValue.getValue() != null) {
                    this.taskOutputParams.put((String)keyValue.getKey(), (String)keyValue.getValue());
                }
                this.currentTaskOutputParam = null;
                this.currentTaskOutputParamLength = 0L;
                if (i + 2 != logLine.length()) {
                    this.appendParseLog(logLine.substring(i + 2));
                }
            }
            return;
        }
        int indexOfVarPoolBegin = logLine.indexOf("${setValue(");
        if (indexOfVarPoolBegin == -1) {
            indexOfVarPoolBegin = logLine.indexOf("#{setValue(");
        }
        if (indexOfVarPoolBegin == -1) {
            return;
        }
        this.currentTaskOutputParam = new ArrayList<String>();
        this.appendParseLog(logLine.substring(indexOfVarPoolBegin));
    }

    public Map<String, String> getTaskOutputParams() {
        return this.taskOutputParams;
    }

    protected Pair<String, String> parseOutputParam(String outputParam) {
        if (StringUtils.isEmpty((CharSequence)outputParam)) {
            log.info("The task output param is empty");
            return ImmutablePair.nullPair();
        }
        if (!outputParam.startsWith("${setValue(") && !outputParam.startsWith("#{setValue(") || !outputParam.endsWith(")}")) {
            log.info("The task output param {} should start with '${setValue(' or '#{setValue(' and end with ')}'", (Object)outputParam);
            return ImmutablePair.nullPair();
        }
        String keyValueExpression = outputParam.substring(11, outputParam.length() - 2);
        if (!keyValueExpression.contains("=")) {
            log.warn("The task output param {} should composite with key=value", (Object)outputParam);
            return ImmutablePair.nullPair();
        }
        String[] keyValue = keyValueExpression.split("=", 2);
        return ImmutablePair.of((Object)keyValue[0], (Object)keyValue[1]);
    }
}

