/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.SceneChangeInfo;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.utils.Jackson;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ConcatTemplateDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        ConcatTemplateDemo.createMediaTemplate(client);
    }

    public static void createMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("Concat");
        request.setName("ConcatTemplate42");
        MediaConcatTemplateObject concatTemplate = request.getConcat();
        concatTemplate.getContainer().setFormat("mp4");
        List<MediaConcatFragmentObject> concatList = concatTemplate.getConcatFragmentList();
        MediaConcatFragmentObject fragment = new MediaConcatFragmentObject();
        fragment.setMode("Start");
        fragment.setUrl("http://demo-1234567890.cos.ap-chongqing.myqcloud.com/demo1.mp4");
        concatList.add(fragment);
        SceneChangeInfo sceneChangeInfo = concatTemplate.getSceneChangeInfo();
        sceneChangeInfo.setMode("XFADE");
        sceneChangeInfo.setTime("5");
        sceneChangeInfo.setTransitionType("fade");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void describeMediaTemplatesV2(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("Concat");
        MediaListTemplateResponse response = client.describeMediaTemplatesV2(request);
        List<MediaTemplateObject> templateList = response.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : templateList) {
            System.out.println(Jackson.toJsonString(mediaTemplateObject));
        }
    }
}

