/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import java.time.Duration;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
public class ChannelDiagnostics {
    private final Channel channel;
    private final Instant channelCreationTime;
    private int requestCount = 0;

    public ChannelDiagnostics(Channel channel) {
        this.channel = channel;
        this.channelCreationTime = Instant.now();
    }

    public void incrementRequestCount() {
        ++this.requestCount;
    }

    public String toString() {
        return ToString.builder((String)"ChannelDiagnostics").add("channel", (Object)this.channel).add("channelAge", (Object)Duration.between(this.channelCreationTime, Instant.now())).add("requestCount", (Object)this.requestCount).build();
    }
}

