/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.models.ApplicationGatewayAuthenticationCertificate;
import com.azure.resourcemanager.network.models.ApplicationGatewayAutoscaleConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealth;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallMode;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontend;
import com.azure.resourcemanager.network.models.ApplicationGatewayIpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.azure.resourcemanager.network.models.ApplicationGatewayOperationalState;
import com.azure.resourcemanager.network.models.ApplicationGatewayProbe;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRule;
import com.azure.resourcemanager.network.models.ApplicationGatewaySku;
import com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslProtocol;
import com.azure.resourcemanager.network.models.ApplicationGatewayTier;
import com.azure.resourcemanager.network.models.ApplicationGatewayUrlPathMap;
import com.azure.resourcemanager.network.models.ApplicationGatewayWebApplicationFirewallConfiguration;
import com.azure.resourcemanager.network.models.HasPrivateIpAddress;
import com.azure.resourcemanager.network.models.HasPublicIpAddress;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.UpdatableWithTags;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasSubnet;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface ApplicationGateway
extends GroupableResource<NetworkManager, ApplicationGatewayInner>,
Refreshable<ApplicationGateway>,
Updatable<Update>,
UpdatableWithTags<ApplicationGateway>,
HasSubnet,
HasPrivateIpAddress {
    public void start();

    public Map<String, ApplicationGatewayBackendHealth> checkBackendHealth();

    public Mono<Map<String, ApplicationGatewayBackendHealth>> checkBackendHealthAsync();

    public void stop();

    public Mono<Void> startAsync();

    public Mono<Void> stopAsync();

    public Collection<ApplicationGatewaySslProtocol> disabledSslProtocols();

    public boolean isPrivate();

    public boolean isPublic();

    public ApplicationGatewayFrontend defaultPublicFrontend();

    public ApplicationGatewayFrontend defaultPrivateFrontend();

    public ApplicationGatewaySku sku();

    public int instanceCount();

    public ApplicationGatewaySkuName size();

    public ApplicationGatewayTier tier();

    public ApplicationGatewayAutoscaleConfiguration autoscaleConfiguration();

    public ApplicationGatewayWebApplicationFirewallConfiguration webApplicationFirewallConfiguration();

    public ApplicationGatewayOperationalState operationalState();

    public Map<String, ApplicationGatewayIpConfiguration> ipConfigurations();

    public Map<String, ApplicationGatewayBackend> backends();

    public Map<String, ApplicationGatewayProbe> probes();

    public ApplicationGatewayIpConfiguration defaultIPConfiguration();

    public Map<String, ApplicationGatewayFrontend> frontends();

    public Map<String, ApplicationGatewayFrontend> publicFrontends();

    public Map<String, ApplicationGatewayFrontend> privateFrontends();

    public Map<String, Integer> frontendPorts();

    public Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigurations();

    public Map<String, ApplicationGatewaySslCertificate> sslCertificates();

    public Map<String, ApplicationGatewayListener> listeners();

    public Map<String, ApplicationGatewayRedirectConfiguration> redirectConfigurations();

    public Map<String, ApplicationGatewayUrlPathMap> urlPathMaps();

    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules();

    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates();

    public boolean isHttp2Enabled();

    public Set<AvailabilityZoneId> availabilityZones();

    public String frontendPortNameFromNumber(int var1);

    public ApplicationGatewayListener listenerByPortNumber(int var1);

    public static interface Update
    extends Appliable<ApplicationGateway>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithInstanceCount,
    UpdateStages.WithWebApplicationFirewall,
    UpdateStages.WithBackend,
    UpdateStages.WithBackendHttpConfig,
    UpdateStages.WithIPConfig,
    UpdateStages.WithFrontend,
    UpdateStages.WithPublicIPAddress,
    UpdateStages.WithFrontendPort,
    UpdateStages.WithSslCert,
    UpdateStages.WithListener,
    UpdateStages.WithRequestRoutingRule,
    UpdateStages.WithExistingSubnet,
    UpdateStages.WithProbe,
    UpdateStages.WithDisabledSslProtocol,
    UpdateStages.WithAuthenticationCertificate,
    UpdateStages.WithRedirectConfiguration,
    UpdateStages.WithUrlPathMap,
    UpdateStages.WithManagedServiceIdentity,
    UpdateStages.WithHttp2 {
    }

    public static interface UpdateStages {

        public static interface WithHttp2 {
            public Update withHttp2();

            public Update withoutHttp2();
        }

        public static interface WithDisabledSslProtocol {
            public Update withDisabledSslProtocol(ApplicationGatewaySslProtocol var1);

            public Update withDisabledSslProtocols(ApplicationGatewaySslProtocol ... var1);

            public Update withoutDisabledSslProtocol(ApplicationGatewaySslProtocol var1);

            public Update withoutDisabledSslProtocols(ApplicationGatewaySslProtocol ... var1);

            public Update withoutAnyDisabledSslProtocols();
        }

        public static interface WithManagedServiceIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithRequestRoutingRule {
            public ApplicationGatewayRequestRoutingRule.UpdateDefinitionStages.Blank<Update> defineRequestRoutingRule(String var1);

            public Update withoutRequestRoutingRule(String var1);

            public ApplicationGatewayRequestRoutingRule.Update updateRequestRoutingRule(String var1);

            public ApplicationGatewayUrlPathMap.UpdateDefinitionStages.Blank<Update> definePathBasedRoutingRule(String var1);
        }

        public static interface WithBackendHttpConfig {
            public ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.Blank<Update> defineBackendHttpConfiguration(String var1);

            public Update withoutBackendHttpConfiguration(String var1);

            public ApplicationGatewayBackendHttpConfiguration.Update updateBackendHttpConfiguration(String var1);
        }

        public static interface WithUrlPathMap {
            public Update withoutUrlPathMap(String var1);

            public ApplicationGatewayUrlPathMap.Update updateUrlPathMap(String var1);
        }

        public static interface WithRedirectConfiguration {
            public ApplicationGatewayRedirectConfiguration.UpdateDefinitionStages.Blank<Update> defineRedirectConfiguration(String var1);

            public Update withoutRedirectConfiguration(String var1);

            public ApplicationGatewayRedirectConfiguration.Update updateRedirectConfiguration(String var1);
        }

        public static interface WithListener {
            public ApplicationGatewayListener.UpdateDefinitionStages.Blank<Update> defineListener(String var1);

            public Update withoutListener(String var1);

            public ApplicationGatewayListener.Update updateListener(String var1);
        }

        public static interface WithSslCert {
            public ApplicationGatewaySslCertificate.UpdateDefinitionStages.Blank<Update> defineSslCertificate(String var1);

            public Update withoutSslCertificate(String var1);
        }

        public static interface WithInstanceCount {
            public Update withInstanceCount(int var1);

            public Update withAutoScale(int var1, int var2);
        }

        public static interface WithWebApplicationFirewall {
            public Update withWebApplicationFirewall(ApplicationGatewayWebApplicationFirewallConfiguration var1);
        }

        public static interface WithSku {
            public Update withTier(ApplicationGatewayTier var1);

            public Update withSize(ApplicationGatewaySkuName var1);
        }

        public static interface WithProbe {
            public ApplicationGatewayProbe.UpdateDefinitionStages.Blank<Update> defineProbe(String var1);

            public ApplicationGatewayProbe.Update updateProbe(String var1);

            public Update withoutProbe(String var1);
        }

        public static interface WithBackend {
            public ApplicationGatewayBackend.UpdateDefinitionStages.Blank<Update> defineBackend(String var1);

            public Update withoutBackendFqdn(String var1);

            public Update withoutBackendIPAddress(String var1);

            public Update withoutBackend(String var1);

            public ApplicationGatewayBackend.Update updateBackend(String var1);
        }

        public static interface WithFrontend {
            public Update withoutFrontend(String var1);

            public ApplicationGatewayFrontend.Update updateFrontend(String var1);

            public Update withoutPublicFrontend();

            public Update withoutPrivateFrontend();

            public ApplicationGatewayFrontend.Update updatePublicFrontend();

            public ApplicationGatewayFrontend.UpdateDefinitionStages.Blank<Update> definePublicFrontend();

            public ApplicationGatewayFrontend.UpdateDefinitionStages.Blank<Update> definePrivateFrontend();
        }

        public static interface WithPublicIPAddress
        extends HasPublicIpAddress.UpdateStages.WithPublicIPAddressNoDnsLabel<Update> {
        }

        public static interface WithFrontendPort {
            public Update withFrontendPort(int var1);

            public Update withFrontendPort(int var1, String var2);

            public Update withoutFrontendPort(String var1);

            public Update withoutFrontendPort(int var1);
        }

        public static interface WithIPConfig {
            public Update withoutIPConfiguration(String var1);

            public ApplicationGatewayIpConfiguration.Update updateIPConfiguration(String var1);

            public ApplicationGatewayIpConfiguration.Update updateDefaultIPConfiguration();

            public ApplicationGatewayIpConfiguration.UpdateDefinitionStages.Blank<Update> defineDefaultIPConfiguration();
        }

        public static interface WithExistingSubnet
        extends HasSubnet.UpdateStages.WithSubnet<Update> {
            public Update withExistingSubnet(Subnet var1);

            public Update withExistingSubnet(Network var1, String var2);
        }

        public static interface WithPrivateFrontend {
            public Update withPrivateFrontend();

            public Update withoutPrivateFrontend();
        }

        public static interface WithAuthenticationCertificate {
            public ApplicationGatewayAuthenticationCertificate.UpdateDefinitionStages.Blank<Update> defineAuthenticationCertificate(String var1);

            public Update withoutAuthenticationCertificate(String var1);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithRequestRoutingRule,
    DefinitionStages.WithRequestRoutingRuleOrCreate {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ApplicationGateway>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithInstanceCount,
        WithWebApplicationFirewall,
        WithSslCert,
        WithFrontendPort,
        WithListener,
        WithBackendHttpConfig,
        WithBackend,
        WithExistingSubnet,
        WithPrivateIPAddress,
        WithPrivateFrontend,
        WithPublicFrontend,
        WithPublicIPAddress,
        WithProbe,
        WithDisabledSslProtocol,
        WithAuthenticationCertificate,
        WithRedirectConfiguration,
        WithAvailabilityZone,
        WithManagedServiceIdentity,
        WithHttp2 {
        }

        public static interface WithHttp2 {
            public WithCreate withHttp2();

            public WithCreate withoutHttp2();
        }

        public static interface WithAvailabilityZone {
            public WithCreate withAvailabilityZone(AvailabilityZoneId var1);
        }

        public static interface WithDisabledSslProtocol {
            public WithCreate withDisabledSslProtocol(ApplicationGatewaySslProtocol var1);

            public WithCreate withDisabledSslProtocols(ApplicationGatewaySslProtocol ... var1);
        }

        public static interface WithManagedServiceIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithPrivateIPAddress
        extends HasPrivateIpAddress.DefinitionStages.WithPrivateIPAddress<WithCreate> {
        }

        public static interface WithExistingSubnet
        extends HasSubnet.DefinitionStages.WithSubnet<WithCreate> {
            public WithCreate withExistingSubnet(Subnet var1);

            public WithCreate withExistingSubnet(Network var1, String var2);
        }

        public static interface WithInstanceCount {
            public WithCreate withInstanceCount(int var1);

            public WithCreate withAutoScale(int var1, int var2);
        }

        public static interface WithWebApplicationFirewall {
            public WithCreate withWebApplicationFirewall(boolean var1, ApplicationGatewayFirewallMode var2);

            public WithCreate withWebApplicationFirewall(ApplicationGatewayWebApplicationFirewallConfiguration var1);
        }

        public static interface WithSku {
            public WithCreate withTier(ApplicationGatewayTier var1);

            public WithCreate withSize(ApplicationGatewaySkuName var1);
        }

        public static interface WithRequestRoutingRuleOrCreate
        extends WithRequestRoutingRule,
        WithCreate {
        }

        public static interface WithRequestRoutingRule {
            public ApplicationGatewayRequestRoutingRule.DefinitionStages.Blank<WithRequestRoutingRuleOrCreate> defineRequestRoutingRule(String var1);

            public ApplicationGatewayUrlPathMap.DefinitionStages.Blank<WithRequestRoutingRuleOrCreate> definePathBasedRoutingRule(String var1);
        }

        public static interface WithBackendHttpConfig {
            public ApplicationGatewayBackendHttpConfiguration.DefinitionStages.Blank<WithCreate> defineBackendHttpConfiguration(String var1);
        }

        public static interface WithBackend {
            public ApplicationGatewayBackend.DefinitionStages.Blank<WithCreate> defineBackend(String var1);
        }

        public static interface WithAuthenticationCertificate {
            public ApplicationGatewayAuthenticationCertificate.DefinitionStages.Blank<WithCreate> defineAuthenticationCertificate(String var1);
        }

        public static interface WithSslCert {
            public ApplicationGatewaySslCertificate.DefinitionStages.Blank<WithCreate> defineSslCertificate(String var1);
        }

        public static interface WithFrontendPort {
            public WithCreate withFrontendPort(int var1);

            public WithCreate withFrontendPort(int var1, String var2);
        }

        public static interface WithProbe {
            public ApplicationGatewayProbe.DefinitionStages.Blank<WithCreate> defineProbe(String var1);
        }

        public static interface WithRedirectConfiguration {
            public ApplicationGatewayRedirectConfiguration.DefinitionStages.Blank<WithCreate> defineRedirectConfiguration(String var1);
        }

        public static interface WithListener {
            public ApplicationGatewayListener.DefinitionStages.Blank<WithCreate> defineListener(String var1);
        }

        public static interface WithPrivateFrontend {
            public WithCreate withPrivateFrontend();

            public WithCreate withoutPrivateFrontend();
        }

        public static interface WithPublicFrontend
        extends WithPublicIPAddress {
            public WithCreate withoutPublicFrontend();
        }

        public static interface WithPublicIPAddress
        extends HasPublicIpAddress.DefinitionStages.WithPublicIPAddressNoDnsLabel<WithCreate> {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithRequestRoutingRule> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }
}

