/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeNodesClient;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeNodeIpAddressInner;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeNodeInner;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeNodeIpAddressImpl;
import com.azure.resourcemanager.datafactory.implementation.SelfHostedIntegrationRuntimeNodeImpl;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeNodeIpAddress;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeNodes;
import com.azure.resourcemanager.datafactory.models.SelfHostedIntegrationRuntimeNode;
import com.azure.resourcemanager.datafactory.models.UpdateIntegrationRuntimeNodeRequest;

public final class IntegrationRuntimeNodesImpl
implements IntegrationRuntimeNodes {
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeNodesImpl.class);
    private final IntegrationRuntimeNodesClient innerClient;
    private final DataFactoryManager serviceManager;

    public IntegrationRuntimeNodesImpl(IntegrationRuntimeNodesClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SelfHostedIntegrationRuntimeNode> getWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        Response<SelfHostedIntegrationRuntimeNodeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SelfHostedIntegrationRuntimeNodeImpl((SelfHostedIntegrationRuntimeNodeInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SelfHostedIntegrationRuntimeNode get(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName) {
        SelfHostedIntegrationRuntimeNodeInner inner = this.serviceClient().get(resourceGroupName, factoryName, integrationRuntimeName, nodeName);
        if (inner != null) {
            return new SelfHostedIntegrationRuntimeNodeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName) {
        this.serviceClient().delete(resourceGroupName, factoryName, integrationRuntimeName, nodeName);
    }

    @Override
    public Response<SelfHostedIntegrationRuntimeNode> updateWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName, UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest, Context context) {
        Response<SelfHostedIntegrationRuntimeNodeInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, updateIntegrationRuntimeNodeRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SelfHostedIntegrationRuntimeNodeImpl((SelfHostedIntegrationRuntimeNodeInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SelfHostedIntegrationRuntimeNode update(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName, UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest) {
        SelfHostedIntegrationRuntimeNodeInner inner = this.serviceClient().update(resourceGroupName, factoryName, integrationRuntimeName, nodeName, updateIntegrationRuntimeNodeRequest);
        if (inner != null) {
            return new SelfHostedIntegrationRuntimeNodeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<IntegrationRuntimeNodeIpAddress> getIpAddressWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        Response<IntegrationRuntimeNodeIpAddressInner> inner = this.serviceClient().getIpAddressWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationRuntimeNodeIpAddressImpl((IntegrationRuntimeNodeIpAddressInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationRuntimeNodeIpAddress getIpAddress(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName) {
        IntegrationRuntimeNodeIpAddressInner inner = this.serviceClient().getIpAddress(resourceGroupName, factoryName, integrationRuntimeName, nodeName);
        if (inner != null) {
            return new IntegrationRuntimeNodeIpAddressImpl(inner, this.manager());
        }
        return null;
    }

    private IntegrationRuntimeNodesClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }
}

