/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.repository;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.mapper.JdbcRegistryDataMapper;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DO.JdbcRegistryData;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcRegistryDataRepository {
    @Autowired
    private JdbcRegistryDataMapper jdbcRegistryDataMapper;

    public List<JdbcRegistryDataDTO> selectAll() {
        return this.jdbcRegistryDataMapper.selectAll().stream().map(JdbcRegistryDataDTO::fromJdbcRegistryData).collect(Collectors.toList());
    }

    public Optional<JdbcRegistryDataDTO> selectByKey(String key) {
        return Optional.ofNullable(this.jdbcRegistryDataMapper.selectByKey(key)).map(JdbcRegistryDataDTO::fromJdbcRegistryData);
    }

    public void deleteEphemeralDateByClientIds(List<Long> clientIds) {
        if (CollectionUtils.isEmpty(clientIds)) {
            return;
        }
        this.jdbcRegistryDataMapper.deleteByClientIds(clientIds, DataType.EPHEMERAL.name());
    }

    public void deleteByKey(String key) {
        this.jdbcRegistryDataMapper.deleteByKey(key);
    }

    public void insert(JdbcRegistryDataDTO jdbcRegistryData) {
        JdbcRegistryData jdbcRegistryDataDO = JdbcRegistryDataDTO.toJdbcRegistryData(jdbcRegistryData);
        this.jdbcRegistryDataMapper.insert(jdbcRegistryDataDO);
        jdbcRegistryData.setId(jdbcRegistryDataDO.getId());
    }

    public void updateById(JdbcRegistryDataDTO jdbcRegistryDataDTO) {
        this.jdbcRegistryDataMapper.updateById(JdbcRegistryDataDTO.toJdbcRegistryData(jdbcRegistryDataDTO));
    }
}

