/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.ApplicationsApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphApplicationInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplications;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class ActiveDirectoryApplicationsImpl
extends CreatableResourcesImpl<ActiveDirectoryApplication, ActiveDirectoryApplicationImpl, MicrosoftGraphApplicationInner>
implements ActiveDirectoryApplications,
HasManager<AuthorizationManager> {
    private AuthorizationManager manager;

    public ActiveDirectoryApplicationsImpl(AuthorizationManager authorizationManager) {
        this.manager = authorizationManager;
    }

    public PagedIterable<ActiveDirectoryApplication> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<ActiveDirectoryApplication> listAsync() {
        return PagedConverter.mapPage(this.inner().listApplicationAsync(), this::wrapModel);
    }

    protected ActiveDirectoryApplicationImpl wrapModel(MicrosoftGraphApplicationInner applicationInner) {
        if (applicationInner == null) {
            return null;
        }
        return new ActiveDirectoryApplicationImpl(applicationInner, this.manager());
    }

    public ActiveDirectoryApplicationImpl getById(String id) {
        return (ActiveDirectoryApplicationImpl)this.getByIdAsync(id).block();
    }

    public Mono<ActiveDirectoryApplication> getByIdAsync(String id) {
        return this.inner().getApplicationAsync(id).map(this::wrapModel);
    }

    public ActiveDirectoryApplication getByName(String spn) {
        return (ActiveDirectoryApplication)this.getByNameAsync(spn).block();
    }

    public Mono<ActiveDirectoryApplication> getByNameAsync(String name) {
        String trimmed = name.replaceFirst("^'+", "").replaceAll("'+$", "");
        return this.listByFilterAsync(String.format("displayName eq '%s'", trimmed)).singleOrEmpty().switchIfEmpty(Mono.defer(() -> {
            try {
                UUID.fromString(trimmed);
            }
            catch (IllegalArgumentException e) {
                return Mono.empty();
            }
            return this.listByFilterAsync(String.format("appId eq '%s'", trimmed)).singleOrEmpty();
        }));
    }

    protected ActiveDirectoryApplicationImpl wrapModel(String name) {
        return new ActiveDirectoryApplicationImpl(new MicrosoftGraphApplicationInner().withDisplayName(name), this.manager());
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteApplicationAsync(id);
    }

    public ActiveDirectoryApplicationImpl define(String name) {
        return this.wrapModel(name);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public ApplicationsApplicationsClient inner() {
        return this.manager().serviceClient().getApplicationsApplications();
    }

    public PagedIterable<ActiveDirectoryApplication> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ActiveDirectoryApplication> listByFilterAsync(String filter) {
        return PagedConverter.mapPage(this.inner().listApplicationAsync(null, null, null, null, filter, null, null, null, null), this::wrapModel);
    }
}

