/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.rbac.engine;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AuthDecision;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class GrpcAuthorizationEngine {
    private static final Logger log = Logger.getLogger(GrpcAuthorizationEngine.class.getName());
    private final AuthConfig authConfig;

    public GrpcAuthorizationEngine(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public AuthDecision evaluate(Metadata metadata, ServerCall<?, ?> serverCall) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        Preconditions.checkNotNull(serverCall, (Object)"serverCall");
        String firstMatch = null;
        EvaluateArgs args = new EvaluateArgs(metadata, serverCall);
        for (PolicyMatcher policyMatcher : this.authConfig.policies) {
            if (!policyMatcher.matches(args)) continue;
            firstMatch = policyMatcher.name;
            break;
        }
        Action decisionType = Action.DENY;
        if (Action.DENY.equals((Object)this.authConfig.action) == (firstMatch == null)) {
            decisionType = Action.ALLOW;
        }
        log.log(Level.FINER, "RBAC decision: {0}, policy match: {1}.", new Object[]{decisionType, firstMatch});
        return AuthDecision.create(decisionType, firstMatch);
    }

    public static final class InvertMatcher
    implements Matcher {
        private final Matcher toInvertMatcher;

        public InvertMatcher(Matcher matcher) {
            this.toInvertMatcher = (Matcher)Preconditions.checkNotNull((Object)matcher, (Object)"matcher");
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return !this.toInvertMatcher.matches(args);
        }
    }

    public static final class AlwaysTrueMatcher
    implements Matcher {
        public static AlwaysTrueMatcher INSTANCE = new AlwaysTrueMatcher();

        @Override
        public boolean matches(EvaluateArgs args) {
            return true;
        }
    }

    public static final class AndMatcher
    implements Matcher {
        private final List<? extends Matcher> allMatch;

        public AndMatcher(List<? extends Matcher> matchers) {
            Preconditions.checkNotNull(matchers, (Object)"matchers");
            for (Matcher matcher : matchers) {
                Preconditions.checkNotNull((Object)matcher, (Object)"matcher");
            }
            this.allMatch = Collections.unmodifiableList(new ArrayList<Matcher>(matchers));
        }

        public static AndMatcher create(Matcher ... matchers) {
            return new AndMatcher(Arrays.asList(matchers));
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            for (Matcher matcher : this.allMatch) {
                if (matcher.matches(args)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrMatcher
    implements Matcher {
        private final List<? extends Matcher> anyMatch;

        public OrMatcher(List<? extends Matcher> matchers) {
            Preconditions.checkNotNull(matchers, (Object)"matchers");
            for (Matcher matcher : matchers) {
                Preconditions.checkNotNull((Object)matcher, (Object)"matcher");
            }
            this.anyMatch = Collections.unmodifiableList(new ArrayList<Matcher>(matchers));
        }

        public static OrMatcher create(Matcher ... matchers) {
            return new OrMatcher(Arrays.asList(matchers));
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            for (Matcher matcher : this.anyMatch) {
                if (!matcher.matches(args)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Matcher {
        public boolean matches(EvaluateArgs var1);
    }

    private static final class EvaluateArgs {
        private final Metadata metadata;
        private final ServerCall<?, ?> serverCall;
        private static final int URI_SAN = 6;
        private static final int DNS_SAN = 2;

        private EvaluateArgs(Metadata metadata, ServerCall<?, ?> serverCall) {
            this.metadata = metadata;
            this.serverCall = serverCall;
        }

        private String getPath() {
            return "/" + this.serverCall.getMethodDescriptor().getFullMethodName();
        }

        @Nullable
        private Collection<String> getPrincipalNames() {
            SSLSession sslSession = (SSLSession)this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
            if (sslSession == null) {
                return null;
            }
            try {
                Certificate[] certs = sslSession.getPeerCertificates();
                if (certs == null || certs.length < 1) {
                    return Collections.singleton("");
                }
                X509Certificate cert = (X509Certificate)certs[0];
                if (cert == null) {
                    return Collections.singleton("");
                }
                Collection<List<?>> names = cert.getSubjectAlternativeNames();
                ArrayList<String> principalNames = new ArrayList<String>();
                if (names != null) {
                    for (List<?> name : names) {
                        if (6 != (Integer)name.get(0)) continue;
                        principalNames.add((String)name.get(1));
                    }
                    if (!principalNames.isEmpty()) {
                        return Collections.unmodifiableCollection(principalNames);
                    }
                    for (List<?> name : names) {
                        if (2 != (Integer)name.get(0)) continue;
                        principalNames.add((String)name.get(1));
                    }
                    if (!principalNames.isEmpty()) {
                        return Collections.unmodifiableCollection(principalNames);
                    }
                }
                if (cert.getSubjectDN() == null || cert.getSubjectDN().getName() == null) {
                    return Collections.singleton("");
                }
                return Collections.singleton(cert.getSubjectDN().getName());
            }
            catch (CertificateParsingException | SSLPeerUnverifiedException ex) {
                log.log(Level.FINE, "Unexpected getPrincipalNames error.", ex);
                return Collections.singleton("");
            }
        }

        @Nullable
        private String getHeader(String headerName) {
            if ("te".equals(headerName = headerName.toLowerCase(Locale.ROOT))) {
                return null;
            }
            if (":authority".equals(headerName)) {
                headerName = "host";
            }
            if ("host".equals(headerName)) {
                return this.serverCall.getAuthority();
            }
            if (":path".equals(headerName)) {
                return this.getPath();
            }
            if (":method".equals(headerName)) {
                return "POST";
            }
            return this.deserializeHeader(headerName);
        }

        @Nullable
        private String deserializeHeader(String headerName) {
            Metadata.Key key;
            if (headerName.endsWith("-bin")) {
                Metadata.Key key2;
                try {
                    key2 = Metadata.Key.of((String)headerName, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                Iterable values = this.metadata.getAll(key2);
                if (values == null) {
                    return null;
                }
                ArrayList<String> encoded = new ArrayList<String>();
                for (byte[] v : values) {
                    encoded.add(BaseEncoding.base64().omitPadding().encode(v));
                }
                return Joiner.on((String)",").join(encoded);
            }
            try {
                key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            Iterable values = this.metadata.getAll(key);
            return values == null ? null : Joiner.on((String)",").join(values);
        }

        private InetAddress getDestinationIp() {
            SocketAddress addr = (SocketAddress)this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
            return addr == null ? null : ((InetSocketAddress)addr).getAddress();
        }

        private InetAddress getSourceIp() {
            SocketAddress addr = (SocketAddress)this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            return addr == null ? null : ((InetSocketAddress)addr).getAddress();
        }

        private int getDestinationPort() {
            SocketAddress addr = (SocketAddress)this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
            return addr == null ? -1 : ((InetSocketAddress)addr).getPort();
        }

        private String getRequestedServerName() {
            return "";
        }
    }

    public static final class RequestedServerNameMatcher
    implements Matcher {
        private final Matchers.StringMatcher delegate;

        public RequestedServerNameMatcher(Matchers.StringMatcher delegate) {
            this.delegate = (Matchers.StringMatcher)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate.matches(args.getRequestedServerName());
        }
    }

    public static final class DestinationPortRangeMatcher
    implements Matcher {
        private final int start;
        private final int end;

        public DestinationPortRangeMatcher(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            int port = args.getDestinationPort();
            return port >= this.start && port < this.end;
        }
    }

    public static final class DestinationPortMatcher
    implements Matcher {
        private final int port;

        public DestinationPortMatcher(int port) {
            this.port = port;
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.port == args.getDestinationPort();
        }
    }

    public static final class AuthHeaderMatcher
    implements Matcher {
        private final Matchers.HeaderMatcher delegate;

        public AuthHeaderMatcher(Matchers.HeaderMatcher delegate) {
            this.delegate = (Matchers.HeaderMatcher)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate.matches(args.getHeader(this.delegate.name()));
        }
    }

    public static final class PathMatcher
    implements Matcher {
        private final Matchers.StringMatcher delegate;

        public PathMatcher(Matchers.StringMatcher delegate) {
            this.delegate = (Matchers.StringMatcher)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate.matches(args.getPath());
        }
    }

    public static final class SourceIpMatcher
    implements Matcher {
        private final Matchers.CidrMatcher delegate;

        public SourceIpMatcher(Matchers.CidrMatcher delegate) {
            this.delegate = (Matchers.CidrMatcher)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate.matches(args.getSourceIp());
        }
    }

    public static final class DestinationIpMatcher
    implements Matcher {
        private final Matchers.CidrMatcher delegate;

        public DestinationIpMatcher(Matchers.CidrMatcher delegate) {
            this.delegate = (Matchers.CidrMatcher)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate.matches(args.getDestinationIp());
        }
    }

    public static final class AuthenticatedMatcher
    implements Matcher {
        private final Matchers.StringMatcher delegate;

        public AuthenticatedMatcher(@Nullable Matchers.StringMatcher delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            Collection principalNames = args.getPrincipalNames();
            log.log(Level.FINER, "Matching principal names: {0}", new Object[]{principalNames});
            if (principalNames == null) {
                return false;
            }
            if (this.delegate == null) {
                return true;
            }
            for (String name : principalNames) {
                if (!this.delegate.matches(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class PolicyMatcher
    implements Matcher {
        private final OrMatcher permissions;
        private final OrMatcher principals;
        private final String name;

        public PolicyMatcher(String name, OrMatcher permissions, OrMatcher principals) {
            this.name = name;
            this.permissions = permissions;
            this.principals = principals;
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.permissions.matches(args) && this.principals.matches(args);
        }
    }

    public static final class AuthConfig {
        private final List<PolicyMatcher> policies;
        private final Action action;

        public AuthConfig(List<PolicyMatcher> policies, Action action) {
            this.policies = Collections.unmodifiableList(new ArrayList<PolicyMatcher>(policies));
            this.action = action;
        }
    }

    @AutoValue
    public static abstract class AuthDecision {
        public abstract Action decision();

        @Nullable
        public abstract String matchingPolicyName();

        static AuthDecision create(Action decisionType, @Nullable String matchingPolicy) {
            return new AutoValue_GrpcAuthorizationEngine_AuthDecision(decisionType, matchingPolicy);
        }
    }

    public static enum Action {
        ALLOW,
        DENY;

    }
}

