/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="JobStatus represents the current state of a Job.")
public class V1JobStatus {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Integer active;
    public static final String SERIALIZED_NAME_COMPLETION_TIME = "completionTime";
    @SerializedName(value="completionTime")
    private OffsetDateTime completionTime;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1JobCondition> conditions = null;
    public static final String SERIALIZED_NAME_FAILED = "failed";
    @SerializedName(value="failed")
    private Integer failed;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_SUCCEEDED = "succeeded";
    @SerializedName(value="succeeded")
    private Integer succeeded;

    public V1JobStatus active(Integer active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of actively running pods.")
    public Integer getActive() {
        return this.active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public V1JobStatus completionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is only set when the job finishes successfully.")
    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
    }

    public V1JobStatus conditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1JobStatus addConditionsItem(V1JobCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest available observations of an object's current state. When a job fails, one of the conditions will have type == \"Failed\". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public List<V1JobCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
    }

    public V1JobStatus failed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which reached phase Failed.")
    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public V1JobStatus startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public V1JobStatus succeeded(Integer succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which reached phase Succeeded.")
    public Integer getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobStatus v1JobStatus = (V1JobStatus)o;
        return Objects.equals(this.active, v1JobStatus.active) && Objects.equals(this.completionTime, v1JobStatus.completionTime) && Objects.equals(this.conditions, v1JobStatus.conditions) && Objects.equals(this.failed, v1JobStatus.failed) && Objects.equals(this.startTime, v1JobStatus.startTime) && Objects.equals(this.succeeded, v1JobStatus.succeeded);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.completionTime, this.conditions, this.failed, this.startTime, this.succeeded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

