/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ReactorNetty;
import reactor.netty.transport.ClientTransportConfig;
import reactor.netty.transport.ServerTransport;
import reactor.netty.transport.TransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public final class TransportConnector {
    static final Logger log = Loggers.getLogger(TransportConnector.class);
    static final Predicate<Throwable> RETRY_PREDICATE = t -> t instanceof RetryConnectException;

    TransportConnector() {
    }

    public static Mono<Channel> bind(TransportConfig config, ChannelInitializer<Channel> channelInitializer, SocketAddress bindAddress, boolean isDomainSocket) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(bindAddress, "bindAddress");
        Objects.requireNonNull(channelInitializer, "channelInitializer");
        return TransportConnector.doInitAndRegister(config, channelInitializer, isDomainSocket, config.eventLoopGroup().next()).flatMap(channel -> {
            MonoChannelPromise promise = new MonoChannelPromise((Channel)channel);
            channel.eventLoop().execute(() -> channel.bind(bindAddress, promise.unvoid()));
            return promise;
        });
    }

    public static Mono<Channel> connect(TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ChannelInitializer<Channel> channelInitializer) {
        return TransportConnector.connect(config, remoteAddress, resolverGroup, channelInitializer, config.eventLoopGroup().next());
    }

    public static Mono<Channel> connect(TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup, ChannelInitializer<Channel> channelInitializer, EventLoop eventLoop) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        Objects.requireNonNull(resolverGroup, "resolverGroup");
        Objects.requireNonNull(channelInitializer, "channelInitializer");
        Objects.requireNonNull(eventLoop, "eventLoop");
        boolean isDomainAddress = remoteAddress instanceof DomainSocketAddress;
        return TransportConnector.doInitAndRegister(config, channelInitializer, isDomainAddress, eventLoop).flatMap(channel -> TransportConnector.doResolveAndConnect(channel, config, remoteAddress, resolverGroup).onErrorResume(RetryConnectException.class, t -> {
            AtomicInteger index = new AtomicInteger(1);
            return Mono.defer(() -> TransportConnector.doInitAndRegister(config, channelInitializer, isDomainAddress, eventLoop).flatMap(ch -> {
                MonoChannelPromise mono = new MonoChannelPromise((Channel)ch);
                TransportConnector.doConnect(t.addresses, config.bindAddress(), mono, index.get());
                return mono;
            })).retryWhen((Retry)Retry.max((long)(t.addresses.size() - 1)).filter(RETRY_PREDICATE).doBeforeRetry(sig -> index.incrementAndGet()));
        }));
    }

    static void setAttributes(Channel channel, Map<AttributeKey<?>, ?> attrs) {
        for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
            channel.attr(e.getKey()).set(e.getValue());
        }
    }

    static void setChannelOptions(Channel channel, Map<ChannelOption<?>, ?> options, boolean isDomainSocket) {
        for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
            if (isDomainSocket && (ChannelOption.SO_REUSEADDR.equals(e.getKey()) || ChannelOption.TCP_NODELAY.equals(e.getKey()))) continue;
            try {
                if (channel.config().setOption(e.getKey(), e.getValue())) continue;
                log.warn(ReactorNetty.format(channel, "Unknown channel option '{}' for channel '{}'"), new Object[]{e.getKey(), channel});
            }
            catch (Throwable t) {
                log.warn(ReactorNetty.format(channel, "Failed to set channel option '{}' with value '{}' for channel '{}'"), new Object[]{e.getKey(), e.getValue(), channel, t});
            }
        }
    }

    static void doConnect(List<SocketAddress> addresses, @Nullable Supplier<? extends SocketAddress> bindAddress, ChannelPromise connectPromise, int index) {
        Channel channel = connectPromise.channel();
        channel.eventLoop().execute(() -> {
            ChannelFuture f;
            SocketAddress remoteAddress = (SocketAddress)addresses.get(index);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Connecting to [" + remoteAddress + "]."));
            }
            if (bindAddress == null) {
                f = channel.connect(remoteAddress);
            } else {
                SocketAddress local = Objects.requireNonNull((SocketAddress)bindAddress.get(), "bindAddress");
                f = channel.connect(remoteAddress, local);
            }
            f.addListener(future -> {
                if (future.isSuccess()) {
                    connectPromise.setSuccess();
                } else {
                    int next;
                    channel.close();
                    Throwable cause = future.cause();
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(channel, "Connect attempt to [" + remoteAddress + "] failed."), cause);
                    }
                    if ((next = index + 1) < addresses.size()) {
                        connectPromise.setFailure((Throwable)new RetryConnectException(addresses));
                    } else {
                        connectPromise.setFailure(cause);
                    }
                }
            });
        });
    }

    static Mono<Channel> doInitAndRegister(TransportConfig config, ChannelInitializer<Channel> channelInitializer, boolean isDomainSocket, EventLoop eventLoop) {
        ChannelFactory<? extends Channel> channelFactory = config.connectionFactory(config.eventLoopGroup(), isDomainSocket);
        Channel channel = null;
        try {
            channel = channelFactory.newChannel();
            if (channelInitializer instanceof ServerTransport.AcceptorInitializer) {
                ((ServerTransport.AcceptorInitializer)channelInitializer).acceptor.enableAutoReadTask(channel);
            }
            channel.pipeline().addLast(new ChannelHandler[]{channelInitializer});
            TransportConnector.setChannelOptions(channel, config.options, isDomainSocket);
            TransportConnector.setAttributes(channel, config.attrs);
        }
        catch (Throwable t) {
            if (channel != null) {
                channel.unsafe().closeForcibly();
            }
            return Mono.error((Throwable)t);
        }
        MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
        channel.unsafe().register(eventLoop, (ChannelPromise)monoChannelPromise);
        Throwable cause = monoChannelPromise.cause();
        if (cause != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        return monoChannelPromise;
    }

    static Mono<Channel> doResolveAndConnect(Channel channel, TransportConfig config, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup) {
        try {
            AddressResolver resolver;
            try {
                resolver = resolverGroup.getResolver((EventExecutor)channel.eventLoop());
            }
            catch (Throwable t) {
                channel.close();
                return Mono.error((Throwable)t);
            }
            Supplier<? extends SocketAddress> bindAddress = config.bindAddress();
            if (!resolver.isSupported(remoteAddress) || resolver.isResolved(remoteAddress)) {
                MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
                TransportConnector.doConnect(Collections.singletonList(remoteAddress), bindAddress, monoChannelPromise, 0);
                return monoChannelPromise;
            }
            if (config instanceof ClientTransportConfig) {
                ClientTransportConfig clientTransportConfig = (ClientTransportConfig)config;
                if (clientTransportConfig.doOnResolve != null) {
                    clientTransportConfig.doOnResolve.accept(Connection.from(channel));
                }
            }
            Future resolveFuture = resolver.resolveAll(remoteAddress);
            if (config instanceof ClientTransportConfig) {
                ClientTransportConfig clientTransportConfig = (ClientTransportConfig)config;
                if (clientTransportConfig.doOnResolveError != null) {
                    resolveFuture.addListener((GenericFutureListener)((FutureListener)future -> {
                        if (future.cause() != null) {
                            clientTransportConfig.doOnResolveError.accept(Connection.from(channel), future.cause());
                        }
                    }));
                }
                if (clientTransportConfig.doAfterResolve != null) {
                    resolveFuture.addListener((GenericFutureListener)((FutureListener)future -> {
                        if (future.isSuccess()) {
                            clientTransportConfig.doAfterResolve.accept(Connection.from(channel), (SocketAddress)((List)future.getNow()).get(0));
                        }
                    }));
                }
            }
            if (resolveFuture.isDone()) {
                Throwable cause = resolveFuture.cause();
                if (cause != null) {
                    channel.close();
                    return Mono.error((Throwable)cause);
                }
                MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
                TransportConnector.doConnect((List)resolveFuture.getNow(), bindAddress, monoChannelPromise, 0);
                return monoChannelPromise;
            }
            MonoChannelPromise monoChannelPromise = new MonoChannelPromise(channel);
            resolveFuture.addListener((GenericFutureListener)((FutureListener)future -> {
                if (future.cause() != null) {
                    channel.close();
                    monoChannelPromise.tryFailure(future.cause());
                } else {
                    TransportConnector.doConnect((List)future.getNow(), bindAddress, monoChannelPromise, 0);
                }
            }));
            return monoChannelPromise;
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    static final class RetryConnectException
    extends RuntimeException {
        final List<SocketAddress> addresses;
        private static final long serialVersionUID = -207274323623692199L;

        RetryConnectException(List<SocketAddress> addresses) {
            this.addresses = addresses;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class MonoChannelPromise
    extends Mono<Channel>
    implements ChannelPromise,
    Subscription {
        final Channel channel;
        CoreSubscriber<? super Channel> actual;
        static final Object SUCCESS = new Object();
        static final AtomicReferenceFieldUpdater<MonoChannelPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MonoChannelPromise.class, Object.class, "result");
        volatile Object result;

        MonoChannelPromise(Channel channel) {
            this.channel = channel;
        }

        public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise await() {
            throw new UnsupportedOperationException();
        }

        public boolean await(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        public boolean await(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise awaitUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        public boolean awaitUninterruptibly(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public void cancel() {
            this.channel.close();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public Throwable cause() {
            Object result = this.result;
            return result == SUCCESS ? null : (Throwable)result;
        }

        public Channel channel() {
            return this.channel;
        }

        public Void get() {
            throw new UnsupportedOperationException();
        }

        public Void get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public Void getNow() {
            throw new UnsupportedOperationException();
        }

        public boolean isCancellable() {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            Object result = this.result;
            return result != null;
        }

        public boolean isSuccess() {
            Object result = this.result;
            return result == SUCCESS;
        }

        public boolean isVoid() {
            return false;
        }

        public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return this;
        }

        public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return this;
        }

        public void request(long n) {
        }

        public ChannelPromise setFailure(Throwable cause) {
            this.tryFailure(cause);
            return this;
        }

        public ChannelPromise setSuccess() {
            this.trySuccess(null);
            return this;
        }

        public ChannelPromise setSuccess(Void result) {
            this.trySuccess(null);
            return this;
        }

        public boolean setUncancellable() {
            return true;
        }

        public void subscribe(CoreSubscriber<? super Channel> actual) {
            EventLoop eventLoop = this.channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this._subscribe(actual);
            } else {
                eventLoop.execute(() -> this._subscribe(actual));
            }
        }

        public ChannelPromise sync() {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise syncUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        public boolean tryFailure(Throwable cause) {
            if (RESULT_UPDATER.compareAndSet(this, null, cause)) {
                if (this.actual != null) {
                    this.actual.onError(cause);
                }
                return true;
            }
            return false;
        }

        public boolean trySuccess() {
            return this.trySuccess(null);
        }

        public boolean trySuccess(Void result) {
            if (RESULT_UPDATER.compareAndSet(this, null, SUCCESS)) {
                if (this.actual != null) {
                    this.actual.onNext((Object)this.channel);
                    this.actual.onComplete();
                }
                return true;
            }
            return false;
        }

        public ChannelPromise unvoid() {
            return new DefaultChannelPromise(this.channel){

                public ChannelPromise setSuccess(Void result) {
                    super.trySuccess(null);
                    this.trySuccess(null);
                    return this;
                }

                public boolean trySuccess(Void result) {
                    super.trySuccess(null);
                    return this.trySuccess(null);
                }

                public ChannelPromise setFailure(Throwable cause) {
                    super.tryFailure(cause);
                    this.tryFailure(cause);
                    return this;
                }

                public boolean tryFailure(Throwable cause) {
                    super.tryFailure(cause);
                    return this.tryFailure(cause);
                }
            };
        }

        void _subscribe(CoreSubscriber<? super Channel> actual) {
            this.actual = actual;
            actual.onSubscribe((Subscription)this);
            if (this.isDone()) {
                if (this.isSuccess()) {
                    actual.onNext((Object)this.channel);
                    actual.onComplete();
                } else {
                    actual.onError(this.cause());
                }
            }
        }
    }
}

