/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.graph;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowGraph;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowGraphFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowGraphFactory.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;

    public IWorkflowGraph createWorkflowGraph(WorkflowDefinition workflowDefinition) {
        List workflowTaskRelations = this.processService.findRelationByCode(workflowDefinition.getCode(), workflowDefinition.getVersion());
        List<TaskDefinition> taskDefinitions = this.taskDefinitionLogDao.queryTaskDefineLogList(workflowTaskRelations).stream().map(TaskDefinition.class::cast).collect(Collectors.toList());
        return new WorkflowGraph(workflowTaskRelations, taskDefinitions);
    }
}

