/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.resources.fluent.PolicyAssignmentsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicyAssignmentInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.azure.resourcemanager.resources.implementation.PolicyAssignmentImpl;
import com.azure.resourcemanager.resources.models.PolicyAssignment;
import com.azure.resourcemanager.resources.models.PolicyAssignments;
import reactor.core.publisher.Mono;

public final class PolicyAssignmentsImpl
extends CreatableWrappersImpl<PolicyAssignment, PolicyAssignmentImpl, PolicyAssignmentInner>
implements PolicyAssignments {
    private final PolicyAssignmentsClient client;

    public PolicyAssignmentsImpl(PolicyAssignmentsClient innerClient) {
        this.client = innerClient;
    }

    @Override
    public PagedIterable<PolicyAssignment> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.client.deleteByIdAsync(id).then();
    }

    @Override
    public PolicyAssignmentImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected PolicyAssignmentImpl wrapModel(String name) {
        return new PolicyAssignmentImpl(name, new PolicyAssignmentInner().withDisplayName(name), this.client);
    }

    @Override
    protected PolicyAssignmentImpl wrapModel(PolicyAssignmentInner inner) {
        if (inner == null) {
            return null;
        }
        return new PolicyAssignmentImpl(inner.name(), inner, this.client);
    }

    @Override
    public PagedIterable<PolicyAssignment> listByResource(String resourceId) {
        return this.wrapList(this.client.listForResource(ResourceUtils.groupFromResourceId(resourceId), ResourceUtils.resourceProviderFromResourceId(resourceId), ResourceUtils.relativePathFromResourceId(ResourceUtils.parentResourceIdFromResourceId(resourceId)), ResourceUtils.resourceTypeFromResourceId(resourceId), ResourceUtils.nameFromResourceId(resourceId)));
    }

    @Override
    public PolicyAssignment getById(String id) {
        return (PolicyAssignment)this.getByIdAsync(id).block();
    }

    @Override
    public Mono<PolicyAssignment> getByIdAsync(String id) {
        return this.client.getByIdAsync(id).map(this::wrapModel);
    }

    @Override
    public PagedIterable<PolicyAssignment> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<PolicyAssignment> listAsync() {
        return this.wrapPageAsync(this.client.listAsync());
    }

    @Override
    public PagedFlux<PolicyAssignment> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return new PagedFlux(() -> Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(this.client.listByResourceGroupAsync(resourceGroupName));
    }
}

