/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;

public interface DeletionPurger {
    public static final DeletionPurger PURGE_ALL = (ts, ldt) -> true;

    public boolean shouldPurge(long var1, long var3);

    default public boolean shouldPurge(DeletionTime dt) {
        return !dt.isLive() && this.shouldPurge(dt.markedForDeleteAt(), dt.localDeletionTime());
    }

    default public boolean shouldPurge(LivenessInfo liveness, long nowInSec) {
        return !liveness.isLive(nowInSec) && this.shouldPurge(liveness.timestamp(), liveness.localExpirationTime());
    }
}

