/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.time.TimeProvider;

public enum SystemTimeProvider implements TimeProvider
{
    INSTANCE;

    private static final long LAST_NANOS;
    public static TimeProvider CLOCK;
    private long delta = 0L;
    @UsedViaReflection
    private volatile long lastNanos5;

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        return this.currentTimeNanos() / 1000L;
    }

    @Override
    public long currentTimeNanos() {
        long timeNanos5;
        long last5;
        long timeNanos = this.currentTimeNanos1();
        do {
            if ((timeNanos5 = timeNanos >>> 5) > (last5 = this.lastNanos5)) continue;
            timeNanos5 = last5 + 1L;
            timeNanos = timeNanos5 << 5;
        } while (!UnsafeMemory.INSTANCE.compareAndSwapLong(this, LAST_NANOS, last5, timeNanos5));
        return timeNanos;
    }

    protected long currentTimeNanos1() {
        long nowMS;
        long nowNS = System.nanoTime();
        long estimate = nowNS + this.delta;
        if (estimate < (nowMS = this.currentTimeMillis() * 1000000L)) {
            this.delta = nowMS - nowNS;
            return nowMS;
        }
        if (estimate > nowMS + 1000000L) {
            this.delta = (nowMS += 1000000L) - nowNS;
            return nowMS;
        }
        return estimate;
    }

    static {
        CLOCK = INSTANCE;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + 3L) {
            INSTANCE.currentTimeNanos1();
            Jvm.nanoPause();
        }
        LAST_NANOS = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(SystemTimeProvider.class, "lastNanos5"));
    }
}

