/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerJmxConnectorService
extends ServiceSupport
implements CamelContextAware {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final int DEFAULT_CONNECTION_PORT = -1;
    public static final String DEFAULT_SERVICE_URL_PATH = "/jmxrmi/camel";
    private static final Logger LOG = LoggerFactory.getLogger(DebuggerJmxConnectorService.class);
    private CamelContext camelContext;
    private MBeanServer server;
    private JMXConnectorServer cs;
    private Registry registry;
    private int registryPort = 1099;
    private boolean createConnector = true;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(boolean createConnector) {
        this.createConnector = createConnector;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    protected void doStart() throws Exception {
        this.server = ManagementFactory.getPlatformMBeanServer();
        if (this.createConnector && this.registryPort > 0) {
            this.createJmxConnector(DEFAULT_HOST);
        }
    }

    protected void doStop() throws Exception {
        if (this.cs != null) {
            try {
                this.cs.stop();
                LOG.debug("Stopped Debugger JMX Connector");
            }
            catch (IOException e) {
                LOG.debug("Error occurred during stopping CamelDebugger JMX Connector: {}. This exception will be ignored.", (Object)this.cs, (Object)e);
            }
            this.cs = null;
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                LOG.debug("Unexported JMX RMI Registry");
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Error occurred while unexporting JMX RMI registry. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    protected void createJmxConnector(String host) throws IOException {
        String serviceUrlPath = DEFAULT_SERVICE_URL_PATH;
        int connectorPort = -1;
        try {
            this.registry = LocateRegistry.createRegistry(this.registryPort);
            LOG.debug("Created JMXConnector RMI registry on port {}", (Object)this.registryPort);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object path = serviceUrlPath.startsWith("/") ? serviceUrlPath : "/" + serviceUrlPath;
        JMXServiceURL url = connectorPort > 0 ? new JMXServiceURL("service:jmx:rmi://" + host + ":" + connectorPort + "/jndi/rmi://" + host + ":" + this.registryPort + (String)path) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + this.registryPort + (String)path);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
        Thread thread = this.getCamelContext().getExecutorServiceManager().newThread("DebuggerJMXConnector", () -> {
            try {
                LOG.debug("Staring Debugger JMX Connector thread to listen at: {}", (Object)url);
                this.cs.start();
                LOG.info("Debugger JMXConnector listening at: {}", (Object)url);
            }
            catch (IOException e) {
                LOG.warn("Cannot start Debugger JMX Connector thread at: {}. JMX Connector not in use.", (Object)url, (Object)e);
            }
        });
        thread.start();
    }
}

