/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ast;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.util.Lists;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.ast.AnonymousTypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.AstCodeGeneration;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstParser;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.IASTEditorCommitListener;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AstEditorTest
extends AbstractJavaTest {
    private static final String FIELD_INIT = AstEditorTest.getSourceDQ("package test;", "  class Test {", "    int m_value0123456789;", "  }");
    private static final String FIELD_BEFORE = AstEditorTest.getSourceDQ("package test;", "  class Test {", "    int abc;", "    int m_value0123456789;", "  }");
    private static final String FIELD_AFTER = AstEditorTest.getSourceDQ("package test;", "  class Test {", "    int m_value0123456789;", "    int abc;", "  }");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            AstEditorTest.do_projectCreate();
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        DesignerPlugin.getActivePage().closeAllEditors(false);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getJavaProject() throws Exception {
        this.createTypeDeclaration_TestC("");
        IJavaProject javaProject = m_testProject.getJavaProject();
        IJavaProject editorJavaProject = this.m_lastEditor.getJavaProject();
        AstEditorTest.assertEquals((Object)javaProject, (Object)editorJavaProject);
    }

    @Test
    public void test_getProject() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstEditorTest.assertSame((Object)m_testProject.getProject(), (Object)this.m_lastEditor.getProject());
    }

    @Test
    public void test_hasCompilationErrors_false() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstEditorTest.assertFalse((boolean)this.m_lastEditor.hasCompilationErrors());
    }

    @Test
    public void test_hasCompilationErrors_true() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        this.createTypeDeclaration_TestC("somethingBad");
        AstEditorTest.assertTrue((boolean)this.m_lastEditor.hasCompilationErrors());
    }

    @Test
    public void test_getPrimaryType() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSource("package test;", "", "class Foo {}", "", "public class Test {", "  public Test() {", "  }", "}", "", "class Bar {}"));
        AstEditorTest.assertSame(compilationUnit.types().get(1), (Object)this.m_lastEditor.getPrimaryType());
    }

    @Test
    public void test_getModelType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t}\n\tprivate void init() {\n\t}\n}");
        IType expected = this.m_lastEditor.getModelUnit().getType("Test");
        IType actual = this.m_lastEditor.getModelType(typeDeclaration);
        AstEditorTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_moveStatement_nop_1() throws Exception {
        String[] lines = new String[]{"    int a;", "    int b;"};
        this.char_moveStatement(lines, 0, 0, true, lines, false);
    }

    @Test
    public void test_moveStatement_nop_2() throws Exception {
        String[] lines = new String[]{"    int a;", "    int b;"};
        this.char_moveStatement(lines, 0, 0, false, lines, false);
    }

    @Test
    public void test_moveStatement_nop_3() throws Exception {
        String[] lines = new String[]{"    int a;", "    int b;"};
        this.char_moveStatement(lines, 0, 1, true, lines, false);
    }

    @Test
    public void test_moveStatement_nop_4() throws Exception {
        String[] lines = new String[]{"    int a;", "    int b;"};
        this.char_moveStatement(lines, 1, 0, false, lines, false);
    }

    @Test
    public void test_moveStatement_nop_5() throws Exception {
        String[] lines = new String[]{"    int a;", "    int b;"};
        this.char_moveStatement(lines, 0, -1, true, lines, false);
    }

    @Test
    public void test_moveStatement_nop_6() throws Exception {
        String[] lines = new String[]{"    int a;", "    int b;"};
        this.char_moveStatement(lines, 1, -1, false, lines, false);
    }

    @Test
    public void test_moveStatement_1() throws Exception {
        String[] lines_0 = new String[]{"    int a;", "    int b;", "    int c;"};
        String[] lines_1 = new String[]{"    int b;", "    int a;", "    int c;"};
        this.char_moveStatement(lines_0, 1, 0, true, lines_1, true);
    }

    @Test
    public void test_moveStatement_2() throws Exception {
        String[] lines_0 = new String[]{"    int a;", "    int b;", "    int c;"};
        String[] lines_1 = new String[]{"    int b;", "    int a;", "    int c;"};
        this.char_moveStatement(lines_0, 0, 2, true, lines_1, true);
    }

    @Test
    public void test_moveStatement_3() throws Exception {
        String[] lines_0 = new String[]{"    int a;", "    int b", "      = ", "      5;"};
        String[] lines_1 = new String[]{"    int b", "      = ", "      5;", "    int a;"};
        this.char_moveStatement(lines_0, 1, 0, true, lines_1, true);
    }

    @Test
    public void test_moveStatement_4_before() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a0123456789__;", "    }", "    {", "      int b0123456789;", "    }"};
        String[] lines_1 = new String[]{"    {", "      int b0123456789;", "      int a0123456789__;", "    }", "    {", "    }"};
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.char_moveStatement(lines_0, nArray, new int[2], true, lines_1, true);
    }

    @Test
    public void test_moveStatement_4_after() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a0123456789__;", "    }", "    {", "      int b0123456789;", "    }"};
        String[] lines_1 = new String[]{"    {", "      int a0123456789__;", "      int b0123456789;", "    }", "    {", "    }"};
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.char_moveStatement(lines_0, nArray, new int[2], false, lines_1, true);
    }

    @Test
    public void test_moveStatement_4_inBlockBegin() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a0123456789__;", "    }", "    int bbbbbb01234567890123456789;"};
        String[] lines_1 = new String[]{"    {", "      int bbbbbb01234567890123456789;", "      int a0123456789__;", "    }"};
        int[] nArray = new int[2];
        nArray[1] = -1;
        this.char_moveStatement(lines_0, new int[]{1}, nArray, true, lines_1, true);
    }

    @Test
    public void test_moveStatement_4_inBlockEnd() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a0123456789__;", "    }", "    int bbbbbb01234567890123456789;"};
        String[] lines_1 = new String[]{"    {", "      int a0123456789__;", "      int bbbbbb01234567890123456789;", "    }"};
        int[] nArray = new int[2];
        nArray[1] = -1;
        this.char_moveStatement(lines_0, new int[]{1}, nArray, false, lines_1, true);
    }

    @Test
    public void test_moveStatement_5() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a01234567890123456789;", "    }", "    int", "      b01234567890123456789;"};
        String[] lines_1 = new String[]{"    {", "      int", "        b01234567890123456789;", "      int a01234567890123456789;", "    }"};
        this.char_moveStatement(lines_0, new int[]{1}, new int[2], true, lines_1, true);
    }

    @Test
    public void test_moveStatement_6() throws Exception {
        String[] lines_0 = new String[]{"    int a;", "    int b;", "    int c;"};
        String[] lines_1 = new String[]{"    int b;", "    int a;", "    int c;"};
        this.char_moveStatement(lines_0, 0, 1, false, lines_1, true);
    }

    @Test
    public void test_moveStatement_7() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a;", "    }", "    {", "      int b;", "    }", "    int c;"};
        String[] lines_1 = new String[]{"    {", "    }", "    {", "      int b;", "      int a;", "    }", "    int c;"};
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.char_moveStatement(lines_0, new int[2], nArray, false, lines_1, true);
    }

    @Test
    public void test_moveStatement_8() throws Exception {
        String[] lines_0 = new String[]{"    int a;", "    int b;", "    int c;"};
        String[] lines_1 = new String[]{"    int c;", "    int a;", "    int b;"};
        this.char_moveStatement(lines_0, 2, -1, true, lines_1, true);
    }

    @Test
    public void test_moveStatement_9() throws Exception {
        String[] lines_0 = new String[]{"    int a;", "    int b;", "    int c;"};
        String[] lines_1 = new String[]{"    int b;", "    int c;", "    int a;"};
        this.char_moveStatement(lines_0, 0, -1, false, lines_1, true);
    }

    @Test
    public void test_moveStatement_10() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a;", "    }", "    {", "      int b;", "    }", "    int c;"};
        String[] lines_1 = new String[]{"    {", "    }", "    {", "      int a;", "      int b;", "    }", "    int c;"};
        this.char_moveStatement(lines_0, new int[2], new int[]{1, -1}, true, lines_1, true);
    }

    @Test
    public void test_moveStatement_11() throws Exception {
        String[] lines_0 = new String[]{"    {", "      int a0123;", "      int a;", "    }", "    {", "      int b;", "    }", "    int c;"};
        String[] lines_1 = new String[]{"    {", "      int a0123;", "    }", "    {", "      int b;", "      int a;", "    }", "    int c;"};
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.char_moveStatement(lines_0, nArray, new int[]{1, -1}, false, lines_1, true);
    }

    @Test
    public void test_moveStatement_12() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t}\n\tprivate void init() {\n\t}\n}\n");
        MethodDeclaration method_constructor = typeDeclaration.getMethods()[0];
        MethodDeclaration method_init = typeDeclaration.getMethods()[1];
        Statement statement = (Statement)DomGenerics.statements((Block)method_constructor.getBody()).get(0);
        this.m_lastEditor.moveStatement(statement, new StatementTarget(method_init, false));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "  }", "  private void init() {", "    int a;", "  }", "}"), this.m_lastEditor);
        AstEditorTest.assertSame((Object)statement.getParent(), (Object)method_init.getBody());
    }

    @Test
    public void test_moveStatement_emptyLine() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "    {", "      int foo;", "", "      int bar;", "    }", "    int target;", "  }", "}"));
        MethodDeclaration constructor = typeDeclaration.getMethods()[0];
        List statements = DomGenerics.statements((Block)constructor.getBody());
        Statement statement = (Statement)statements.get(0);
        this.m_lastEditor.moveStatement(statement, new StatementTarget((Statement)statements.get(1), false));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "    int target;", "    {", "      int foo;", "", "      int bar;", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_moveStatement_mixedIndent() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "\t\t    int lineToMove;", "\t\t    int target;", "  }", "}"));
        MethodDeclaration constructor = typeDeclaration.getMethods()[0];
        List statements = DomGenerics.statements((Block)constructor.getBody());
        Statement statementToMove = (Statement)statements.get(0);
        Statement targetStatement = (Statement)statements.get(1);
        this.m_lastEditor.moveStatement(statementToMove, new StatementTarget(targetStatement, false));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "\t\t    int target;", "\t\t    int lineToMove;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_moveStatement_mixedIndent_withEmptyLine() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "\t\t    ", "\t\t    int lineToMove;", "\t\t    int target;", "  }", "}"));
        MethodDeclaration constructor = typeDeclaration.getMethods()[0];
        List statements = DomGenerics.statements((Block)constructor.getBody());
        Statement statementToMove = (Statement)statements.get(0);
        Statement targetStatement = (Statement)statements.get(1);
        this.m_lastEditor.moveStatement(statementToMove, new StatementTarget(targetStatement, false));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "\t\t    int target;", "\t\t    ", "\t\t    int lineToMove;", "  }", "}"), this.m_lastEditor);
    }

    private void char_moveStatement(String[] initialLines, int statementIndex, int targetStatementIndex, boolean before, String[] expectedLines, boolean wereModifications) throws Exception {
        this.char_moveStatement(initialLines, new int[]{statementIndex}, new int[]{targetStatementIndex}, before, expectedLines, wereModifications);
    }

    @Test
    public void test_moveStatement_withTagElement_forward() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public void source() {", "    int statement;", "  }", "  /**", "  * @tag", "  */", "  public void target() {", "  }", "}"));
        MethodDeclaration source = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        Statement statementToMove = (Statement)DomGenerics.statements((MethodDeclaration)source).get(0);
        this.m_lastEditor.moveStatement(statementToMove, new StatementTarget(target, false));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public void source() {", "  }", "  /**", "  * @tag", "  */", "  public void target() {", "    int statement;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_moveStatement_withTagElement_backward() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public void target() {", "  }", "  /**", "  * @tag", "  */", "  public void source() {", "    int statement;", "  }", "}"));
        MethodDeclaration source = typeDeclaration.getMethods()[1];
        MethodDeclaration target = typeDeclaration.getMethods()[0];
        Statement statementToMove = (Statement)DomGenerics.statements((MethodDeclaration)source).get(0);
        this.m_lastEditor.moveStatement(statementToMove, new StatementTarget(target, false));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public void target() {", "    int statement;", "  }", "  /**", "  * @tag", "  */", "  public void source() {", "  }", "}"), this.m_lastEditor);
    }

    private void char_moveStatement(String[] initialLines, int[] statementIndex, int[] targetStatementIndex, boolean before, String[] expectedLines, boolean wereModifications) throws Exception {
        Statement targetStatement;
        Block targetBlock;
        String[] lines_0 = new String[]{"package test;", "class Test {", "  Test() {"};
        String[] lines_2 = new String[]{"  }", "}"};
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource3(lines_0, initialLines, lines_2));
        long initialModifications = typeDeclaration.getAST().modificationCount();
        Block body = typeDeclaration.getMethods()[0].getBody();
        if (targetStatementIndex[targetStatementIndex.length - 1] == -1) {
            targetBlock = (Block)AstEditorTest.getStatement(body, targetStatementIndex);
            targetStatement = null;
        } else {
            targetBlock = null;
            targetStatement = AstEditorTest.getStatement(body, targetStatementIndex);
        }
        StatementTarget target = new StatementTarget(targetBlock, targetStatement, before);
        Statement statement = AstEditorTest.getStatement(body, statementIndex);
        this.m_lastEditor.moveStatement(statement, target);
        if (wereModifications) {
            AstEditorTest.assertFalse((typeDeclaration.getAST().modificationCount() == initialModifications ? 1 : 0) != 0);
        } else {
            AstEditorTest.assertTrue((typeDeclaration.getAST().modificationCount() == initialModifications ? 1 : 0) != 0);
        }
        AstEditorTest.assertEquals((Object)AstEditorTest.getSource3(lines_0, expectedLines, lines_2), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_getEnclosingNode() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        SimpleName node = typeDeclaration.getName();
        AstEditorTest.assertSame((Object)node, (Object)this.m_lastEditor.getEnclosingNode(node.getStartPosition() + 1));
        node = method.getName();
        AstEditorTest.assertSame((Object)method, (Object)this.m_lastEditor.getEnclosingNode(AstNodeUtils.getSourceEnd((ASTNode)node)));
    }

    @Test
    public void test_getEnclosing_all() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tvoid foo() {\n\t\tSystem.out.println();\n\t}\n}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        Block block = method.getBody();
        ExpressionStatement statement = (ExpressionStatement)block.statements().get(0);
        Expression expression = statement.getExpression();
        AstEditorTest.assertSame((Object)statement, (Object)this.m_lastEditor.getEnclosingStatement(statement.getStartPosition()));
        AstEditorTest.assertSame((Object)statement, (Object)this.m_lastEditor.getEnclosingStatement(statement.getStartPosition() + 5));
        AstEditorTest.assertSame((Object)statement, (Object)this.m_lastEditor.getEnclosingStatement(expression.getStartPosition()));
        AstEditorTest.assertNull((Object)this.m_lastEditor.getEnclosingStatement(typeDeclaration.getStartPosition()));
        AstEditorTest.assertSame((Object)block, (Object)this.m_lastEditor.getEnclosingBlock(block.getStartPosition()));
        AstEditorTest.assertSame((Object)block, (Object)this.m_lastEditor.getEnclosingBlock(statement.getStartPosition()));
        AstEditorTest.assertSame((Object)block, (Object)this.m_lastEditor.getEnclosingBlock(statement.getStartPosition() + 5));
        AstEditorTest.assertNull((Object)this.m_lastEditor.getEnclosingBlock(typeDeclaration.getStartPosition()));
        AstEditorTest.assertSame((Object)method, (Object)this.m_lastEditor.getEnclosingMethod(method.getStartPosition()));
        AstEditorTest.assertSame((Object)method, (Object)this.m_lastEditor.getEnclosingMethod(method.getStartPosition() + 5));
        AstEditorTest.assertSame((Object)method, (Object)this.m_lastEditor.getEnclosingMethod(block.getStartPosition()));
        AstEditorTest.assertNull((Object)this.m_lastEditor.getEnclosingMethod(typeDeclaration.getStartPosition()));
        AstEditorTest.assertSame((Object)typeDeclaration, (Object)this.m_lastEditor.getEnclosingType(typeDeclaration.getStartPosition()));
        AstEditorTest.assertSame((Object)typeDeclaration, (Object)this.m_lastEditor.getEnclosingType(typeDeclaration.getStartPosition() + 5));
        AstEditorTest.assertNull((Object)this.m_lastEditor.getEnclosingType(typeDeclaration.getParent().getStartPosition()));
    }

    @Test
    public void test_globalValue() throws Exception {
        this.createTypeDeclaration_TestC("");
        String key = "KEY";
        AstEditorTest.assertNull((Object)this.m_lastEditor.getGlobalValue(key));
        this.m_lastEditor.putGlobalValue(key, (Object)this);
        AstEditorTest.assertSame((Object)((Object)this), (Object)this.m_lastEditor.getGlobalValue(key));
        this.m_lastEditor.removeGlobalValue(key);
        AstEditorTest.assertNull((Object)this.m_lastEditor.getGlobalValue(key));
    }

    @Test
    public void test_getRootMethods() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void root(){}");
        EditorState state = EditorState.get((AstEditor)this.m_lastEditor);
        AstEditorTest.assertNull((Object)state.getFlowDescription());
        try {
            state.setFlowDescription(null);
            AstEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(typeDeclaration.getMethods());
        state.setFlowDescription(flowDescription);
        AstEditorTest.assertSame((Object)flowDescription, (Object)state.getFlowDescription());
        state.setFlowDescription(flowDescription);
    }

    @Test
    public void test_getClassLoader() throws Exception {
        this.createTypeDeclaration_TestC("");
        EditorState state = EditorState.get((AstEditor)this.m_lastEditor);
        AstEditorTest.assertNull((Object)state.getEditorLoader());
        while (true) {
            try {
                state.initialize(null, null);
            }
            catch (AssertionFailedException e) {
                break;
            }
            AstEditorTest.fail();
        }
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        state.initialize(null, classLoader);
        AstEditorTest.assertSame((Object)classLoader, (Object)state.getEditorLoader());
        while (true) {
            try {
                state.initialize(null, classLoader);
            }
            catch (AssertionFailedException e) {
                break;
            }
            AstEditorTest.fail();
        }
    }

    @Test
    public void test_commitChanges_withoutChanges() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstEditorTest.assertTrue((boolean)this.m_lastModelUnit.isConsistent());
        this.m_lastEditor.commitChanges();
        AstEditorTest.assertTrue((boolean)this.m_lastModelUnit.isConsistent());
    }

    @Test
    public void test_commitChanges_underlayingFileChanged() throws Exception {
        this.createTypeDeclaration_TestC("");
        String newContent = AstEditorTest.getFileContentSrc("test/Test.java") + "// new comment";
        AstEditorTest.setFileContentSrc("test/Test.java", newContent);
        this.m_lastEditor.saveChanges(false);
        AstEditorTest.assertEquals((Object)newContent, (Object)AstEditorTest.getFileContentSrc("test/Test.java"));
    }

    @Test
    public void test_commitChanges_listener() throws Exception {
        this.createTypeDeclaration_TestC("");
        final boolean[] aboutNotified = new boolean[1];
        final boolean[] doneNotified = new boolean[1];
        this.m_lastEditor.setCommitListener(new IASTEditorCommitListener(){

            public void aboutToCommit() {
                aboutNotified[0] = true;
            }

            public boolean canEditBaseFile() {
                return true;
            }

            public void commitDone() {
                doneNotified[0] = true;
            }
        });
        this.m_lastEditor.commitChanges();
        AstEditorTest.assertTrue((boolean)aboutNotified[0]);
        AstEditorTest.assertTrue((boolean)doneNotified[0]);
    }

    @Test
    public void test_commitChanges_listener_canEdit() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("");
        final boolean[] canEditValue = new boolean[]{true};
        final boolean[] aboutNotified = new boolean[1];
        final boolean[] canEditNotified = new boolean[1];
        final boolean[] doneNotified = new boolean[1];
        this.m_lastEditor.setCommitListener(new IASTEditorCommitListener(){

            public void aboutToCommit() {
                aboutNotified[0] = true;
            }

            public boolean canEditBaseFile() {
                canEditNotified[0] = true;
                return canEditValue[0];
            }

            public void commitDone() {
                doneNotified[0] = true;
            }
        });
        this.m_lastEditor.commitChanges();
        AstEditorTest.assertTrue((boolean)aboutNotified[0]);
        AstEditorTest.assertFalse((boolean)canEditNotified[0]);
        AstEditorTest.assertTrue((boolean)doneNotified[0]);
        aboutNotified[0] = false;
        canEditNotified[0] = false;
        doneNotified[0] = false;
        SimpleName nameNode = typeDeclaration.getName();
        this.m_lastEditor.replaceSubstring(nameNode.getStartPosition(), nameNode.getLength(), "FooBar");
        this.m_lastEditor.commitChanges();
        AstEditorTest.assertTrue((boolean)aboutNotified[0]);
        AstEditorTest.assertTrue((boolean)canEditNotified[0]);
        AstEditorTest.assertTrue((boolean)doneNotified[0]);
        AstEditorTest.assertEquals((Object)"package test;public class FooBar{}", (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertEquals((Object)"package test;public class FooBar{}", (Object)this.m_lastModelUnit.getBuffer().getContents());
        canEditValue[0] = false;
        aboutNotified[0] = false;
        canEditNotified[0] = false;
        doneNotified[0] = false;
        nameNode = typeDeclaration.getName();
        this.m_lastEditor.replaceSubstring(nameNode.getStartPosition(), nameNode.getLength(), "BackToTest");
        this.m_lastEditor.commitChanges();
        AstEditorTest.assertTrue((boolean)aboutNotified[0]);
        AstEditorTest.assertTrue((boolean)canEditNotified[0]);
        AstEditorTest.assertTrue((boolean)doneNotified[0]);
        AstEditorTest.assertEquals((Object)"package test;public class BackToTest{}", (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertEquals((Object)"package test;public class FooBar{}", (Object)this.m_lastModelUnit.getBuffer().getContents());
    }

    @Test
    public void test_commitChanges() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("very.very.very.long_.package_.name", "Test.java", AstEditorTest.getSourceDQ("package very.very.very.long_.package_.name;", "public class Test {", "}"));
        SimpleName nameNode = typeDeclaration.getName();
        this.m_lastEditor.replaceSubstring(nameNode.getStartPosition(), nameNode.getLength(), "FooBar");
        String expected = AstEditorTest.getSourceDQ("package very.very.very.long_.package_.name;", "public class FooBar {", "}");
        AstEditorTest.assertEquals((Object)expected, (Object)this.m_lastEditor.getSource(typeDeclaration.getParent()));
        AstEditorTest.assertFalse((boolean)expected.equals(this.m_lastModelUnit.getBuffer().getContents()));
        AstEditorTest.assertTrue((boolean)this.m_lastModelUnit.isConsistent());
        this.m_lastEditor.commitChanges();
        AstEditorTest.assertEquals((Object)expected, (Object)this.m_lastModelUnit.getBuffer().getContents());
        AstEditorTest.assertFalse((boolean)this.m_lastModelUnit.isConsistent());
    }

    private void saveChanges_assertSaved(String expected, boolean bufferEquals, boolean fileEquals) throws JavaModelException {
        String unitContent = this.m_lastModelUnit.getBuffer().getContents();
        String fileContent = AstEditorTest.getFileContentSrc("test/Test.java");
        if (bufferEquals) {
            AstEditorTest.assertEquals((Object)unitContent, (Object)expected);
        } else {
            AstEditorTest.assertNotEquals((Object)unitContent, (Object)expected);
        }
        if (fileEquals) {
            AstEditorTest.assertEquals((Object)fileContent, (Object)expected);
        } else {
            AstEditorTest.assertNotEquals((Object)fileContent, (Object)expected);
        }
    }

    @Test
    public void test_saveChanges_noEditor() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "}"));
        TypeDeclaration typeDeclaration = this.m_lastEditor.getPrimaryType();
        this.m_lastEditor.addFieldDeclaration("int f;", new BodyDeclarationTarget(typeDeclaration, false));
        String expected = AstEditorTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  int f;", "}");
        this.saveChanges_assertSaved(expected, false, false);
        this.m_lastEditor.saveChanges(false);
        this.saveChanges_assertSaved(expected, true, true);
        AstEditorTest.assertTrue((boolean)this.m_lastModelUnit.isConsistent());
    }

    @Test
    public void test_saveChanges_openedEditor() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "}"));
        TypeDeclaration typeDeclaration = this.m_lastEditor.getPrimaryType();
        IDE.openEditor((IWorkbenchPage)DesignerPlugin.getActivePage(), (IFile)AstEditorTest.getFileSrc("test/Test.java"));
        this.m_lastEditor.addFieldDeclaration("int f;", new BodyDeclarationTarget(typeDeclaration, false));
        String expected = AstEditorTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  int f;", "}");
        this.saveChanges_assertSaved(expected, false, false);
        this.m_lastEditor.saveChanges(false);
        this.saveChanges_assertSaved(expected, true, false);
        this.m_lastEditor.saveChanges(true);
        this.saveChanges_assertSaved(expected, true, true);
        AstEditorTest.assertTrue((boolean)this.m_lastModelUnit.isConsistent());
    }

    @Test
    public void test_indexOfCharBackward() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\t// filler filler filler filler\n}");
        AstEditorTest.assertEquals((int)1, (int)this.m_lastEditor.indexOfCharBackward('a', 2));
        AstEditorTest.assertEquals((int)4, (int)this.m_lastEditor.indexOfCharBackward('a', 6));
        try {
            this.m_lastEditor.indexOfCharBackward('z', 6);
            AstEditorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getSource() throws Exception {
        String code = "private int m_value = 12345;";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName nameNode = declarationFragment.getName();
        AstEditorTest.assertEquals((Object)"m_value", (Object)this.m_lastEditor.getSource(nameNode.getStartPosition(), nameNode.getLength()));
        AstEditorTest.assertEquals((Object)"m_value", (Object)this.m_lastEditor.getSource((ASTNode)nameNode));
        AstEditorTest.assertEquals((Object)"m_value", (Object)this.m_lastEditor.getSourceBeginEnd(AstNodeUtils.getSourceBegin((ASTNode)nameNode), AstNodeUtils.getSourceEnd((ASTNode)nameNode)));
        try {
            this.m_lastEditor.getSource(-1, 1);
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(BadLocationException.class);
        }
    }

    @Test
    public void test_setSource() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  private int m_value = 12345;", "}"));
        String newSource = this.m_lastEditor.getSource();
        newSource = newSource.replace("12345", "23456");
        this.m_lastEditor.setSource(newSource);
        AstEditorTest.assertEquals((Object)newSource, (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_getExternalSource() throws Exception {
        this.createTypeDeclaration("test", "Constants.java", AstEditorTest.getSourceDQ("package test;", "public class Constants {", "  public static final int SIZE = 10;", "}"));
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.util.*;\npublic class Test {\n\tint f_0 = 12345;\n\tObject f_1 = new ArrayList();\n\tObject f_2 = new ArrayList(Constants.SIZE);\n\tObject f_3 = Collections.emptyList();\n\tObject f_4 = List.class;\n}");
        AstEditorTest.waitForAutoBuild();
        FieldDeclaration[] fields = typeDeclaration.getFields();
        AstEditorTest.assertEquals((Object)"12345", (Object)this.getExternalSource(fields[0], null));
        AstEditorTest.assertEquals((Object)"new java.util.ArrayList()", (Object)this.getExternalSource(fields[1], null));
        AstEditorTest.assertEquals((Object)"new java.util.ArrayList(test.Constants.SIZE)", (Object)this.getExternalSource(fields[2], null));
        AstEditorTest.assertEquals((Object)"new java.util.ArrayList(sizeParameter)", (Object)this.getExternalSource(fields[2], from -> {
            if (this.m_lastEditor.getSource(from).equals("Constants.SIZE")) {
                return "sizeParameter";
            }
            return null;
        }));
        AstEditorTest.assertEquals((Object)"java.util.Collections.emptyList()", (Object)this.getExternalSource(fields[3], null));
        AstEditorTest.assertEquals((Object)"java.util.List.class", (Object)this.getExternalSource(fields[4], null));
    }

    private String getExternalSource(FieldDeclaration fieldDeclaration, Function<ASTNode, String> transformer) {
        Expression initializer = ((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)fieldDeclaration).get(0)).getInitializer();
        return this.m_lastEditor.getExternalSource((ASTNode)initializer, transformer);
    }

    @Test
    public void test_getTypeBindingSource() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler\n// filler filler filler filler filler\nimport java.util.List;\nimport java.util.Map;\npublic class Test {\n\tprivate List<String> field_1;\n\tprivate Map<Double, List<String>> field_2;\n\tpublic Test() {\n\t}\n}");
        FieldDeclaration field = this.getNode("field_1", FieldDeclaration.class);
        ITypeBinding typeBinding = field.getType().resolveBinding();
        AstEditorTest.assertEquals((Object)"java.util.List<java.lang.String>", (Object)this.m_lastEditor.getTypeBindingSource(typeBinding));
        field = this.getNode("field_2", FieldDeclaration.class);
        typeBinding = field.getType().resolveBinding();
        AstEditorTest.assertEquals((Object)"java.util.Map<java.lang.Double, java.util.List<java.lang.String>>", (Object)this.m_lastEditor.getTypeBindingSource(typeBinding));
    }

    @Test
    public void test_indexOf() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t\tint b;\n\t}\n}");
        int index = this.m_lastEditor.indexOf("int a");
        AstEditorTest.assertEquals((Object)"int a", (Object)this.m_lastEditor.getSource(index, 5));
        index = this.m_lastEditor.indexOf("int b");
        AstEditorTest.assertEquals((Object)"int b", (Object)this.m_lastEditor.getSource(index, 5));
        try {
            this.m_lastEditor.indexOf("noSuchString");
            AstEditorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getCharAt() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n\tint a;\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int position = AstNodeUtils.getSourceBegin((ASTNode)fieldDeclaration);
        AstEditorTest.assertEquals((char)'i', (char)this.m_lastEditor.getChar(position + 0));
        AstEditorTest.assertEquals((char)'n', (char)this.m_lastEditor.getChar(position + 1));
        AstEditorTest.assertEquals((char)'t', (char)this.m_lastEditor.getChar(position + 2));
        try {
            this.m_lastEditor.getChar(-1);
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(BadLocationException.class);
        }
    }

    @Test
    public void test_getWhitespaceToLeft() throws Exception {
        String code = "\t\t\r\t\t\n\t\tprivate int m_value = 12345;";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int end = fieldDeclaration.getStartPosition();
        AstEditorTest.assertEquals((Object)"", (Object)this.m_lastEditor.getWhitespaceToLeft(end + 1, false));
        AstEditorTest.assertEquals((Object)"\t\t", (Object)this.m_lastEditor.getWhitespaceToLeft(end, false));
        AstEditorTest.assertEquals((Object)"\t\t\r\t\t\n\t\t", (Object)this.m_lastEditor.getWhitespaceToLeft(end, true));
    }

    @Test
    public void test_getLineNumber() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n\tint a;\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        AstEditorTest.assertEquals((int)4, (int)this.m_lastEditor.getLineNumber(fieldDeclaration.getStartPosition()));
    }

    @Test
    public void test_getLineNumber_badPosition() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n\tint a;\n}");
        try {
            this.m_lastEditor.getLineNumber(-1);
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(BadLocationException.class);
        }
    }

    @Test
    public void test_getLineBegin() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.*;\nimport javax.swing.*;\nclass Test extends JPanel {\n\tint a;\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int begin = AstNodeUtils.getSourceBegin((ASTNode)fieldDeclaration);
        int end = AstNodeUtils.getSourceEnd((ASTNode)fieldDeclaration);
        int lineBegin = begin - 1;
        AstEditorTest.assertEquals((int)lineBegin, (int)this.m_lastEditor.getLineBegin(begin));
        AstEditorTest.assertEquals((int)lineBegin, (int)this.m_lastEditor.getLineBegin(begin + 1));
        AstEditorTest.assertEquals((int)lineBegin, (int)this.m_lastEditor.getLineBegin(end));
        try {
            this.m_lastEditor.getLineBegin(-1);
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(BadLocationException.class);
        }
    }

    @Test
    public void test_getLineEnd() throws Exception {
        int end;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.*;\nimport javax.swing.*;\nclass Test extends JPanel {\n\tint a;\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int begin = AstNodeUtils.getSourceBegin((ASTNode)fieldDeclaration);
        int lineEnd = end = AstNodeUtils.getSourceEnd((ASTNode)fieldDeclaration);
        AstEditorTest.assertEquals((int)lineEnd, (int)this.m_lastEditor.getLineEnd(begin));
        AstEditorTest.assertEquals((int)lineEnd, (int)this.m_lastEditor.getLineEnd(begin + 1));
        AstEditorTest.assertEquals((int)lineEnd, (int)this.m_lastEditor.getLineEnd(end - 1));
        AstEditorTest.assertEquals((int)lineEnd, (int)this.m_lastEditor.getLineEnd(end));
        try {
            this.m_lastEditor.getLineEnd(-1);
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(BadLocationException.class);
        }
    }

    @Test
    public void test_skipWhitespaceAndPureEOLCToLeft_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.*;\nimport javax.swing.*;\nclass Test extends JPanel {\n\tint a;\n\t// 111\n\n\t// 222\n\tint b;\n\tint c;  int d;\n}");
        FieldDeclaration[] fields = typeDeclaration.getFields();
        AstEditorTest.assertEquals((int)(AstNodeUtils.getSourceEnd((ASTNode)fields[0]) + "\n".length()), (int)this.m_lastEditor.skipWhitespaceAndPureEOLCToLeft(AstNodeUtils.getSourceBegin((ASTNode)fields[1])));
        AstEditorTest.assertEquals((int)AstNodeUtils.getSourceEnd((ASTNode)fields[2]), (int)this.m_lastEditor.skipWhitespaceAndPureEOLCToLeft(AstNodeUtils.getSourceBegin((ASTNode)fields[3])));
        AstEditorTest.assertEquals((int)0, (int)this.m_lastEditor.skipWhitespaceAndPureEOLCToLeft(AstNodeUtils.getSourceBegin((ASTNode)this.m_lastEditor.getAstUnit().getPackage())));
    }

    @Test
    public void test_skipSingleEOLToLeft_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n\r\n\r\nint b;\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int index = fieldDeclaration.getStartPosition();
        AstEditorTest.assertEquals((int)(index + 1), (int)this.m_lastEditor.skipSingleEOLToLeft(index + 1));
        AstEditorTest.assertEquals((int)(index - 2), (int)this.m_lastEditor.skipSingleEOLToLeft(index));
    }

    @Test
    public void test_skipSingleEOLToLeft_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n\n\nint b;\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int index = fieldDeclaration.getStartPosition();
        AstEditorTest.assertEquals((int)(index - 1), (int)this.m_lastEditor.skipSingleEOLToLeft(index));
    }

    @Test
    public void test_addFieldDeclaration_0_bad() throws Exception {
        this.createTypeDeclaration_TestC("");
        try {
            this.m_lastEditor.addFieldDeclaration("", new BodyDeclarationTarget(null, null, false));
            AstEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_addFieldDeclaration_1_body_before() throws Exception {
        this.check_addFieldDeclaration(FIELD_INIT, false, true, FIELD_BEFORE);
    }

    @Test
    public void test_addFieldDeclaration_2_body_after() throws Exception {
        this.check_addFieldDeclaration(FIELD_INIT, false, false, FIELD_AFTER);
    }

    @Test
    public void test_addFieldDeclaration_3_type_before() throws Exception {
        this.check_addFieldDeclaration(FIELD_INIT, true, true, FIELD_BEFORE);
    }

    @Test
    public void test_addFieldDeclaration_4_type_after() throws Exception {
        this.check_addFieldDeclaration(FIELD_INIT, true, false, FIELD_AFTER);
    }

    @Test
    public void test_addFieldDeclaration_5_emptyLines_before() throws Exception {
        this.check_addFieldDeclaration(AstEditorTest.getSourceDQ("package test;", "class Test {", "  ", "  ", "  int m_value0123456789;", "}"), false, true, AstEditorTest.getSourceDQ("package test;", "class Test {", "  int abc;", "  ", "  ", "  int m_value0123456789;", "}"));
    }

    @Test
    public void test_addFieldDeclaration_5_emptyLines_after() throws Exception {
        this.check_addFieldDeclaration(AstEditorTest.getSourceDQ("package test;", "class Test {", "  ", "  ", "  int m_value0123456789;", "}"), false, false, AstEditorTest.getSourceDQ("package test;", "class Test {", "  ", "  ", "  int m_value0123456789;", "  int abc;", "}"));
    }

    @Test
    public void test_addFieldDeclaration_6_javaDocComment_before() throws Exception {
        this.check_addFieldDeclaration(AstEditorTest.getSourceDQ("package test;", "class Test {", "  /**", "  * The comment.", "  */", "  int m_value0123456789;", "}"), false, true, AstEditorTest.getSourceDQ("package test;", "class Test {", "  int abc;", "  /**", "  * The comment.", "  */", "  int m_value0123456789;", "}"));
    }

    @Test
    public void test_addFieldDeclaration_6_afterWithEOLComment() throws Exception {
        this.check_addFieldDeclaration(AstEditorTest.getSourceDQ("package test;", "class Test {", "  int m_value0123456789; // comment", "}"), false, false, AstEditorTest.getSourceDQ("package test;", "class Test {", "  int m_value0123456789; // comment", "  int abc;", "}"));
    }

    public void check_addFieldDeclaration(String initialSource, boolean relativeToType, boolean before, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", initialSource);
        FieldDeclaration targetField = typeDeclaration.getFields()[0];
        BodyDeclarationTarget target = new BodyDeclarationTarget((TypeDeclaration)(relativeToType ? typeDeclaration : null), (BodyDeclaration)(relativeToType ? null : targetField), before);
        FieldDeclaration newField = this.m_lastEditor.addFieldDeclaration("int abc;", target);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)newField);
        AstEditorTest.assertNotNull((Object)newField.getType());
        AstEditorTest.assertNotNull((Object)AstNodeUtils.getTypeBinding((Type)newField.getType()));
        AstEditorTest.assertEquals((int)(before ? 0 : 1), (int)typeDeclaration.bodyDeclarations().indexOf(newField));
        AstEditorTest.assertEquals((int)(before ? 1 : 0), (int)typeDeclaration.bodyDeclarations().indexOf(targetField));
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_addFieldDeclaration_inAnonymousType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import javax.swing.*;\nimport java.awt.event.*;\nclass Test extends JPanel {\n\tTest() {\n\t\taddKeyListener(new KeyAdapter() {\n\t\t});\n\t}\n}\n");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        ExpressionStatement expressionStatement = (ExpressionStatement)methodDeclaration.getBody().statements().get(0);
        MethodInvocation invocation = (MethodInvocation)expressionStatement.getExpression();
        ClassInstanceCreation creation = (ClassInstanceCreation)invocation.arguments().get(0);
        TypeDeclaration anonymousTypeDeclaration = AnonymousTypeDeclaration.create((AnonymousClassDeclaration)creation.getAnonymousClassDeclaration());
        int anonymousTypeLength = anonymousTypeDeclaration.getLength();
        BodyDeclarationTarget target = new BodyDeclarationTarget(anonymousTypeDeclaration, null, false);
        FieldDeclaration newField = this.m_lastEditor.addFieldDeclaration("int m_value;", target);
        AstEditorTest.assertNotNull((Object)newField);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "import java.awt.event.*;", "class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {", "      int m_value;", "    });", "  }", "}"), this.m_lastEditor);
        AstEditorTest.assertTrue((anonymousTypeDeclaration.getLength() > anonymousTypeLength ? 1 : 0) != 0);
    }

    @Test
    public void test_addFieldDeclaration_interfaceMethods() throws Exception {
        AstEditorTest.setFileContentSrc("test/MyInterface.java", AstEditorTest.getSource("package test;", "public interface MyInterface {", "  void someMethod();", "}"));
        AstEditorTest.waitForAutoBuild();
        this.m_ignoreModelCompileProblems = true;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test implements MyInterface {\n\t//$hide>>$\n\tpublic void someMethod() {\n\t}\n\t//$hide<<$\n}");
        this.m_lastEditor.addFieldDeclaration("int field;", new BodyDeclarationTarget(typeDeclaration, true));
    }

    @Test
    public void test_addMethodDeclaration_0() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test {\n\tint m_value0123456789;\n}\n");
        FieldDeclaration targetField = typeDeclaration.getFields()[0];
        BodyDeclarationTarget target = new BodyDeclarationTarget(null, (BodyDeclaration)targetField, true);
        MethodDeclaration newMethod = this.m_lastEditor.addMethodDeclaration("int foo()", List.of("return 0;"), target);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)newMethod);
        AstEditorTest.assertEquals((int)0, (int)typeDeclaration.bodyDeclarations().indexOf(newMethod));
        AstEditorTest.assertEquals((int)1, (int)typeDeclaration.bodyDeclarations().indexOf(targetField));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "class Test {", "  int foo() {", "    return 0;", "  }", "  int m_value0123456789;", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addMethodDeclaration_danglingJavadoc() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\n// filler filler filler\nclass Test {\n\t/** dangling */\n}\n");
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, null, false);
        this.m_lastEditor.addMethodDeclaration("int foo()", List.of("return 0;"), target);
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "// filler filler filler", "// filler filler filler", "// filler filler filler", "class Test {", "  int foo() {", "    return 0;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addMethodDeclaration_withEmptyLine() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test {\n\tint m_value0123456789;\n}\n");
        FieldDeclaration targetField = typeDeclaration.getFields()[0];
        BodyDeclarationTarget target = new BodyDeclarationTarget(null, (BodyDeclaration)targetField, true);
        MethodDeclaration newMethod = this.m_lastEditor.addMethodDeclaration("int foo()", List.of("\t", "return 0;"), target);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)newMethod);
        AstEditorTest.assertEquals((int)0, (int)typeDeclaration.bodyDeclarations().indexOf(newMethod));
        AstEditorTest.assertEquals((int)1, (int)typeDeclaration.bodyDeclarations().indexOf(targetField));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "class Test {", "  int foo() {", "      ", "    return 0;", "  }", "  int m_value0123456789;", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addMethodDeclaration_withParameters() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n}\n");
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, false);
        MethodDeclaration newMethod = this.m_lastEditor.addMethodDeclaration("void foo(int a, String b, String[] c)", Collections.emptyList(), target);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)newMethod);
        AstEditorTest.assertEquals((int)0, (int)typeDeclaration.bodyDeclarations().indexOf(newMethod));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "// filler filler filler", "class Test {", "  void foo(int a, String b, String[] c) {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addMethodDeclaration_withAnnotations() throws Exception {
        AstEditorTest.setFileContentSrc("test/Test_0.java", AstEditorTest.getSource("package test;", "public class Test_0 {", "  public void fooBar() {", "  }", "}"));
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test extends Test_0 {", "  // filler", "}"));
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, true);
        MethodDeclaration newMethod = this.m_lastEditor.addMethodDeclaration(List.of("@Override"), "public void fooBar()", Collections.emptyList(), target);
        AstEditorTest.assertNotNull((Object)newMethod);
        AstEditorTest.assertEquals((int)0, (int)typeDeclaration.bodyDeclarations().indexOf(newMethod));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test extends Test_0 {", "  @Override", "  public void fooBar() {", "  }", "  // filler", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addInterfaceMethodDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic interface Test {\n\tint FILLER = 0;\n}\n");
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, false);
        MethodDeclaration newMethod = this.m_lastEditor.addInterfaceMethodDeclaration("int foo()", target);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)newMethod);
        AstEditorTest.assertEquals((int)1, (int)typeDeclaration.bodyDeclarations().indexOf(newMethod));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "public interface Test {", "  int FILLER = 0;", "  int foo();", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ASTParser_addMethodDeclaration_innerTypeStatic() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate static class Inner {\n\t\tpublic static void someMethod() {\n\t\t}\n\t}\n}");
        this.m_lastEditor.addMethodDeclaration("void testMethod()", Collections.emptyList(), new BodyDeclarationTarget(typeDeclaration, false));
    }

    @Test
    public void test_ASTParser_parseBodyDeclaration_targetTypeWithJavadoc() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler\n/**\n  Some comment.\n*/\npublic class Test {\n\t// marker\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        String source = "void foo() {}";
        this.check_ASTParser_parseBodyDeclaration(position, source);
    }

    @Test
    public void test_ASTParser_parseBodyDeclaration_intoPrivateInnerType() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tprivate static class Inner {\n\t\t// marker\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        String source = "void foo() {}";
        this.check_ASTParser_parseBodyDeclaration(position, source);
    }

    @Test
    public void test_ASTParser_parseBodyDeclaration_intoProtectedInnerType() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tprotected static class Inner {\n\t\t// marker\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        String source = "void foo() {}";
        this.check_ASTParser_parseBodyDeclaration(position, source);
    }

    @Test
    public void test_ASTParser_parseBodyDeclaration_intoAnonymous_whenTopLevelHasSameMethod() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tnew Object() {\n\t\t\t// marker\n\t\t};\n\t}\n\tprivate void foo() {\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        String source = "void foo() {}";
        this.check_ASTParser_parseBodyDeclaration(position, source);
    }

    private void check_ASTParser_parseBodyDeclaration(int position, String source) throws Exception {
        BodyDeclaration declaration = this.m_lastEditor.getParser().parseBodyDeclaration(position, source);
        AstEditorTest.assertNotNull((Object)declaration);
        AstEditorTest.assertEquals((int)position, (int)declaration.getStartPosition());
        AstEditorTest.assertEquals((int)source.length(), (int)declaration.getLength());
    }

    @Test
    public void test_ASTParser_addMethodDeclaration_Enums_declared() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate enum TestEnum {\n\t\tC1,\n\t\tC2;\n\t\tTestEnum(){}\n\t\tvoid someEnumMethod(){}\n\t}\n\tprivate final TestEnum m_testEnum = TestEnum.C1;\n\tvoid someTestMethod1(TestEnum testEnum){}\n}");
        this.m_lastEditor.addMethodDeclaration("void someTestMethod2(TestEnum testEnum)", Collections.emptyList(), new BodyDeclarationTarget(typeDeclaration, false));
    }

    @Test
    public void test_ASTParser_parseBodyDeclaration_parseError() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  public Test() {", "  }", "}"));
        try {
            this.m_lastEditor.addMethodDeclaration("void foo()", List.of("somethingBadA();", "somethingBadB();"), new BodyDeclarationTarget(typeDeclaration, false));
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            DesignerException methodDE = DesignerExceptionUtils.getDesignerException((Throwable)e);
            AstEditorTest.assertEquals((int)205, (int)methodDE.getCode());
            Object[] parameters = methodDE.getParameters();
            Assertions.assertThat((Object[])parameters).hasSize(2);
            String source = (String)parameters[0];
            Assertions.assertThat((String)source).doesNotContain(new CharSequence[]{"class Test"});
            Assertions.assertThat((String)source).contains(new CharSequence[]{"void foo() {"});
            Assertions.assertThat((String)source).contains(new CharSequence[]{"somethingBadA();"});
            Assertions.assertThat((String)source).contains(new CharSequence[]{"somethingBadB();"});
            String problems = (String)parameters[1];
            Assertions.assertThat((String)problems).contains(new CharSequence[]{"The method somethingBadA() is undefined for the type Test"});
            Assertions.assertThat((String)problems).contains(new CharSequence[]{"The method somethingBadB() is undefined for the type Test"});
            DesignerException nodeDE = (DesignerException)methodDE.getCause();
            AstEditorTest.assertEquals((int)205, (int)nodeDE.getCode());
            Object[] parameters2 = nodeDE.getParameters();
            Assertions.assertThat((Object[])parameters2).hasSize(2);
            String source2 = (String)parameters2[0];
            Assertions.assertThat((String)source2).contains(new CharSequence[]{"class Test"});
            Assertions.assertThat((String)source2).contains(new CharSequence[]{"void foo() {"});
            Assertions.assertThat((String)source2).contains(new CharSequence[]{"somethingBadA();"});
            Assertions.assertThat((String)source2).contains(new CharSequence[]{"somethingBadB();"});
        }
    }

    @Test
    public void test_ASTParser_addStatement_anonymousInitializer() throws Exception {
        this.createTypeDeclaration_Test("import java.util.ArrayList;\npublic class Test {\n\tpublic Test() {\n\t\tnew ArrayList<Object>() {\n\t\t\t{\n\t\t\t// initializer\n\t\t\t}\n\t\t};\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// initializer");
        String source = "ensureCapacity(77);";
        Statement statement = this.m_lastEditor.getParser().parseStatement(position, source);
        AstEditorTest.assertNotNull((Object)statement);
        AstEditorTest.assertEquals((int)position, (int)statement.getStartPosition());
        AstEditorTest.assertEquals((int)source.length(), (int)statement.getLength());
        Expression expression = ((ExpressionStatement)statement).getExpression();
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodInvocation)((MethodInvocation)expression));
        AstEditorTest.assertEquals((Object)"ensureCapacity", (Object)methodBinding.getName());
        ITypeBinding typeBinding = methodBinding.getDeclaringClass();
        AstEditorTest.assertEquals((Object)"java.util.ArrayList", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false));
    }

    @Test
    public void test_getParametersSource() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tint getSum(String s, double d) {\n\t\treturn 0;\n\t}\n}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        AstEditorTest.assertEquals((Object)"String s, double d", (Object)this.m_lastEditor.getParametersSource(method));
    }

    @Test
    public void test_getParameterNames() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tint getSum(String s, double d) {\n\t\treturn 0;\n\t}\n}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        AstEditorTest.assertArrayEquals((Object[])new String[]{"s", "d"}, (Object[])this.m_lastEditor.getParameterNames(method));
    }

    @Test
    public void test_replaceMethodName_returnVoid() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test {\n\tpublic void foo(int a) {\n\t}\n}\n");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        this.m_lastEditor.replaceMethodName(method, "barBaz");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "class Test {", "  public void barBaz(int a) {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceMethodName_returnObject() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic String foo(int a) {\n\t\treturn null;\n\t}\n}\n");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        this.m_lastEditor.replaceMethodName(method, "barBaz");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "class Test {", "  public String barBaz(int a) {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceMethodName_returnPrimitive() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int foo(int a) {\n\t\treturn 0;\n\t}\n}\n");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        this.m_lastEditor.replaceMethodName(method, "barBaz");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "class Test {", "  public int barBaz(int a) {", "    return 0;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceMethodType_int() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic long foo() {\n\t\treturn 0;\n\t}\n}\n");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        this.m_lastEditor.replaceMethodType(method, "int");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "class Test {", "  public int foo() {", "    return 0;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addTypeDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n}\n");
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, null, true);
        TypeDeclaration newType = this.m_lastEditor.addTypeDeclaration(List.of("private class Inner {", "\tint a;", "\tint getA() {", "\t\treturn a;", "\t}", "}"), target);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)newType);
        AstEditorTest.assertEquals((int)0, (int)typeDeclaration.bodyDeclarations().indexOf(newType));
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "// filler filler filler", "class Test {", "  private class Inner {", "    int a;", "    int getA() {", "      return a;", "    }", "  }", "}"), (Object)this.m_lastEditor.getSource());
        ITypeBinding newTypeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)newType);
        AstEditorTest.assertEquals((Object)"test.Test.Inner", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)newTypeBinding, (boolean)false));
    }

    @Test
    public void test_addTypeDeclaration_superCI_binding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nimport java.util.ArrayList;\nclass Test {\n}\n");
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, null, true);
        TypeDeclaration newType = this.m_lastEditor.addTypeDeclaration(List.of("private class Inner extends ArrayList {", "\tInner() {", "\t\tsuper(5);", "\t}", "}"), target);
        AstEditorTest.assertNotNull((Object)newType);
        AstEditorTest.assertEquals((int)0, (int)typeDeclaration.bodyDeclarations().indexOf(newType));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "// filler filler filler", "import java.util.ArrayList;", "class Test {", "  private class Inner extends ArrayList {", "    Inner() {", "      super(5);", "    }", "  }", "}"), this.m_lastEditor);
        SuperConstructorInvocation invocation = this.getNode("super(5)", SuperConstructorInvocation.class);
        IMethodBinding binding = AstNodeUtils.getSuperBinding((SuperConstructorInvocation)invocation);
        AstEditorTest.assertNotNull((Object)binding);
        AstEditorTest.assertEquals((Object)"<init>(int)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
    }

    @Test
    public void test_ensureInterfaceImplementation_empty() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\nclass Test {\n}\n");
        boolean result = this.m_lastEditor.ensureInterfaceImplementation(typeDeclaration, "java.io.Serializable");
        AstEditorTest.assertTrue((boolean)result);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import java.io.Serializable;", "// filler filler filler", "// filler filler filler", "class Test implements Serializable {", "}"), this.m_lastEditor);
        List superInterfaces = DomGenerics.superInterfaces((TypeDeclaration)typeDeclaration);
        AstEditorTest.assertEquals((int)1, (int)superInterfaces.size());
        Type superInterface = (Type)superInterfaces.get(0);
        AstEditorTest.assertEquals((Object)"java.io.Serializable", (Object)AstNodeUtils.getFullyQualifiedName((Type)superInterface, (boolean)false));
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        AstEditorTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.io.Serializable"));
    }

    @Test
    public void test_ensureInterfaceImplementation_extends() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test extends java.util.ArrayList {\n}\n");
        boolean result = this.m_lastEditor.ensureInterfaceImplementation(typeDeclaration, "java.io.Serializable");
        AstEditorTest.assertTrue((boolean)result);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import java.io.Serializable;", "// filler filler filler", "class Test extends java.util.ArrayList implements Serializable {", "}"), this.m_lastEditor);
        List superInterfaces = DomGenerics.superInterfaces((TypeDeclaration)typeDeclaration);
        AstEditorTest.assertEquals((int)1, (int)superInterfaces.size());
        Type superInterface = (Type)superInterfaces.get(0);
        AstEditorTest.assertEquals((Object)"java.io.Serializable", (Object)AstNodeUtils.getFullyQualifiedName((Type)superInterface, (boolean)false));
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        AstEditorTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.io.Serializable"));
    }

    @Test
    public void test_ensureInterfaceImplementation_implements() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test implements Comparable {\n\tpublic int compareTo(Object o) {\n\t\treturn 0;\n\t}\n}\n");
        boolean result = this.m_lastEditor.ensureInterfaceImplementation(typeDeclaration, "java.io.Serializable");
        AstEditorTest.assertTrue((boolean)result);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import java.io.Serializable;", "class Test implements Comparable, Serializable {", "  public int compareTo(Object o) {", "    return 0;", "  }", "}"), this.m_lastEditor);
        List superInterfaces = DomGenerics.superInterfaces((TypeDeclaration)typeDeclaration);
        AstEditorTest.assertEquals((int)2, (int)superInterfaces.size());
        Type superInterface = (Type)superInterfaces.get(1);
        AstEditorTest.assertEquals((Object)"java.io.Serializable", (Object)AstNodeUtils.getFullyQualifiedName((Type)superInterface, (boolean)false));
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        AstEditorTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.io.Serializable"));
    }

    @Test
    public void test_ensureInterfaceImplementation_already() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test implements java.io.Serializable {\n}");
        boolean result = this.m_lastEditor.ensureInterfaceImplementation(typeDeclaration, "java.io.Serializable");
        AstEditorTest.assertFalse((boolean)result);
    }

    @Test
    public void test_ensureThrownException_alreadyDeclared_directly() throws Exception {
        this.createTypeDeclaration_TestD("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws ClassNotFoundException {", "  }", "}");
        MethodDeclaration method = this.getNode("foo()", MethodDeclaration.class);
        this.m_lastEditor.ensureThrownException(method, "java.lang.ClassNotFoundException");
        AstEditorTest.assertEditor(AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws ClassNotFoundException {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureThrownException_alreadyDeclared_super() throws Exception {
        this.createTypeDeclaration_TestD("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws Exception {", "  }", "}");
        MethodDeclaration method = this.getNode("foo()", MethodDeclaration.class);
        this.m_lastEditor.ensureThrownException(method, "java.lang.ClassNotFoundException");
        AstEditorTest.assertEditor(AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws Exception {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureThrownException_noExisting() throws Exception {
        this.createTypeDeclaration_TestD("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() {", "  }", "}");
        MethodDeclaration method = this.getNode("foo()", MethodDeclaration.class);
        this.m_lastEditor.ensureThrownException(method, "java.lang.ClassNotFoundException");
        AstEditorTest.assertEditor(AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws ClassNotFoundException {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureThrownException_afterExisting() throws Exception {
        this.createTypeDeclaration_TestD("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws NullPointerException {", "  }", "}");
        MethodDeclaration method = this.getNode("foo()", MethodDeclaration.class);
        this.m_lastEditor.ensureThrownException(method, "java.lang.ClassNotFoundException");
        AstEditorTest.assertEditor(AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  public void foo() throws NullPointerException, ClassNotFoundException {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceSubstring_1() throws Exception {
        String code = "private int m_value = 12345;";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName nameNode = declarationFragment.getName();
        String expected = "private int m_value2 = 12345; (31 + 29 = 60)\n\tprivate (31 + 7 = 38)\n\tint (39 + 3 = 42)\n\tm_value2 = 12345 (43 + 16 = 59)\n\t\tm_value2 (43 + 8 = 51)\n\t\t12345 (54 + 5 = 59)\n";
        this.m_lastEditor.replaceSubstring(nameNode.getStartPosition(), nameNode.getLength(), "m_value2");
        String actual = this.getNodesTree((ASTNode)fieldDeclaration);
        AstEditorTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_replaceSubstring_2() throws Exception {
        String code = "private int m_value = 12345;";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName nameNode = declarationFragment.getName();
        try {
            this.m_lastEditor.replaceSubstring(nameNode.getStartPosition() + 1, nameNode.getLength() + 1, "_value2=");
            AstEditorTest.fail();
        }
        catch (DesignerException e) {
            AstEditorTest.assertEquals((int)201, (int)e.getCode());
        }
        try {
            this.m_lastEditor.replaceSubstring(nameNode.getStartPosition() - 1, nameNode.getLength() - 1, "_value3=");
            AstEditorTest.fail();
        }
        catch (DesignerException e) {
            AstEditorTest.assertEquals((int)201, (int)e.getCode());
        }
    }

    @Test
    public void test_replaceSubstring_3() throws Exception {
        String code = "private int m_value = 12345;";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName nameNode = declarationFragment.getName();
        String expected = "private int m_value=12345; (31 + 26 = 57)\n\tprivate (31 + 7 = 38)\n\tint (39 + 3 = 42)\n\tm_value=12345 (43 + 13 = 56)\n\t\tm_value (43 + 7 = 50)\n\t\t12345 (51 + 5 = 56)\n";
        this.m_lastEditor.replaceSubstring(nameNode.getStartPosition() + nameNode.getLength(), 3, "=");
        String actual = this.getNodesTree((ASTNode)fieldDeclaration);
        AstEditorTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_replaceSubstring_4() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("// filler filler filler", "// filler filler filler", "class Test {", "  int m_value;", "}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName nameNode = declarationFragment.getName();
        String newName = "myField";
        this.m_lastEditor.replaceSubstring((ASTNode)nameNode, newName);
        nameNode.setIdentifier(newName);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("// filler filler filler", "// filler filler filler", "class Test {", "  int myField;", "}"), this.m_lastEditor);
    }

    private String getNodesTree(ASTNode root) {
        final StringBuffer buffer = new StringBuffer();
        root.accept(new ASTVisitor(){
            private int m_indent;

            public void preVisit(ASTNode node) {
                try {
                    buffer.append(StringUtils.repeat((String)"\t", (int)this.m_indent));
                    buffer.append(AstEditorTest.this.m_lastEditor.getSource(node));
                    buffer.append(" (");
                    buffer.append(node.getStartPosition());
                    buffer.append(" + ");
                    buffer.append(node.getLength());
                    buffer.append(" = ");
                    buffer.append(node.getStartPosition() + node.getLength());
                    buffer.append(")\n");
                    ++this.m_indent;
                }
                catch (Throwable e) {
                    throw ReflectionUtils.propagate((Throwable)e);
                }
            }

            public void postVisit(ASTNode node) {
                --this.m_indent;
            }
        });
        return buffer.toString();
    }

    @Test
    public void test_getUniqueVariableName_0() throws Exception {
        this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("int m_value = 12345;", "void foo() {", "  int value = 1;", "  System.out.println(1);", "}", "void bar() {", "  System.out.println(2);", "}"));
        int position = this.m_lastEditor.getSource().indexOf("int value");
        AstEditorTest.assertFalse((position == -1 ? 1 : 0) != 0);
        AstEditorTest.assertEquals((Object)"abc", (Object)this.m_lastEditor.getUniqueVariableName(position, "abc", null));
        AstEditorTest.assertEquals((Object)"foo", (Object)this.m_lastEditor.getUniqueVariableName(position, "foo", null));
        position = this.m_lastEditor.getSource().indexOf("System.out.println(1);");
        AstEditorTest.assertFalse((position == -1 ? 1 : 0) != 0);
        AstEditorTest.assertEquals((Object)"value_1", (Object)this.m_lastEditor.getUniqueVariableName(position, "value", null));
        position = this.m_lastEditor.getSource().indexOf("System.out.println(2);");
        AstEditorTest.assertFalse((position == -1 ? 1 : 0) != 0);
        AstEditorTest.assertEquals((Object)"value", (Object)this.m_lastEditor.getUniqueVariableName(position, "value", null));
        AstEditorTest.assertEquals((Object)"m_value_1", (Object)this.m_lastEditor.getUniqueVariableName(-1, "m_value", null));
        AstEditorTest.assertEquals((Object)"value_1", (Object)this.m_lastEditor.getUniqueVariableName(-1, "value", null));
    }

    @Test
    public void test_getUniqueVariableName_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("int m_value;", "int m_value2;", "void foo() {", "  m_value2 = 1;", "}"));
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)typeDeclaration.getFields()[0].fragments().get(0);
        AstEditorTest.assertEquals((Object)"m_value", (Object)this.m_lastEditor.getUniqueVariableName(-1, "m_value", (VariableDeclaration)fragment));
        fragment = (VariableDeclarationFragment)typeDeclaration.getFields()[1].fragments().get(0);
        AstEditorTest.assertEquals((Object)"m_value_1", (Object)this.m_lastEditor.getUniqueVariableName(-1, "m_value", (VariableDeclaration)fragment));
    }

    @Test
    public void test_getUniqueVariableName_shadowSameBlock() throws Exception {
        this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("void foo() {", "  System.out.println(1);", "  int value;", "}"));
        int position = this.m_lastEditor.getSource().indexOf("System.out.println(1);");
        AstEditorTest.assertTrue((position != -1 ? 1 : 0) != 0);
        AstEditorTest.assertEquals((Object)"value_1", (Object)this.m_lastEditor.getUniqueVariableName(position, "value", null));
    }

    @Test
    public void test_getUniqueVariableName_withDeclarations() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tint foo;\n\tvoid bar() {\n\t\tint baz;\n\t}\n}");
        AstEditorTest.assertEquals((Object)"value", (Object)this.m_lastEditor.getUniqueVariableName(-1, "value", null));
        AstEditorTest.assertEquals((Object)"foo_1", (Object)this.m_lastEditor.getUniqueVariableName(-1, "foo", null));
        AstEditorTest.assertEquals((Object)"bar", (Object)this.m_lastEditor.getUniqueVariableName(-1, "bar", null));
        AstEditorTest.assertEquals((Object)"baz_1", (Object)this.m_lastEditor.getUniqueVariableName(-1, "baz", null));
        VariableDeclaration fooDeclaration = (VariableDeclaration)DomGenerics.fragments((FieldDeclaration)typeDeclaration.getFields()[0]).get(0);
        VariableDeclaration bazDeclaration = (VariableDeclaration)DomGenerics.fragments((VariableDeclarationStatement)((VariableDeclarationStatement)typeDeclaration.getMethods()[0].getBody().statements().get(0))).get(0);
        AstEditorTest.assertEquals((Object)"value", (Object)AstEditor.getUniqueVariableName((List)Lists.newArrayList((Object[])new VariableDeclaration[]{fooDeclaration, bazDeclaration}), (String)"value"));
        AstEditorTest.assertEquals((Object)"baz_1", (Object)AstEditor.getUniqueVariableName((List)Lists.newArrayList((Object[])new VariableDeclaration[]{fooDeclaration, bazDeclaration}), (String)"baz"));
        AstEditorTest.assertEquals((Object)"baz", (Object)AstEditor.getUniqueVariableName((List)Lists.newArrayList((Object[])new VariableDeclaration[]{fooDeclaration}), (String)"baz"));
    }

    @Test
    public void test_getUniqueMethodName() throws Exception {
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  void foo() {", "  }", "  void bar() {", "  }", "  void baz(int a) {", "  }", "}"));
        AstEditorTest.assertEquals((Object)"abc", (Object)this.m_lastEditor.getUniqueMethodName("abc"));
        AstEditorTest.assertEquals((Object)"foo_1", (Object)this.m_lastEditor.getUniqueMethodName("foo"));
        AstEditorTest.assertEquals((Object)"bar_1", (Object)this.m_lastEditor.getUniqueMethodName("bar"));
        AstEditorTest.assertEquals((Object)"baz_1", (Object)this.m_lastEditor.getUniqueMethodName("baz"));
        AstEditorTest.assertEquals((Object)"hashCode_1", (Object)this.m_lastEditor.getUniqueMethodName("hashCode"));
    }

    @Test
    public void test_getUniqueTypeName() throws Exception {
        this.createTypeDeclaration_TestC("void foo(){} class A {} class B {} class C {}");
        AstEditorTest.assertEquals((Object)"A_1", (Object)this.m_lastEditor.getUniqueTypeName("A"));
        AstEditorTest.assertEquals((Object)"B_1", (Object)this.m_lastEditor.getUniqueTypeName("B"));
        AstEditorTest.assertEquals((Object)"C_1", (Object)this.m_lastEditor.getUniqueTypeName("C"));
        AstEditorTest.assertEquals((Object)"D", (Object)this.m_lastEditor.getUniqueTypeName("D"));
        AstEditorTest.assertEquals((Object)"foo", (Object)this.m_lastEditor.getUniqueTypeName("foo"));
    }

    @Test
    public void test_getStatementEndIndex_1() throws Exception {
        this.check_getStatementEndIndex("void foo() {int a; int b; int c;}", 0, 7);
    }

    @Test
    public void test_getStatementEndIndex_2() throws Exception {
        this.check_getStatementEndIndex("void foo() {int a; \tint b;\t\t int c;}", 1, 9);
    }

    @Test
    public void test_getStatementEndIndex_3() throws Exception {
        this.check_getStatementEndIndex("void foo() {int a; \tint b;\t\t// a\n int c;}", 1, 12);
    }

    private void check_getStatementEndIndex(String code, int statementIndex, int expectedIndexShift) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        AstEditorTest.assertEquals((Object)code, (Object)this.m_lastEditor.getSource((ASTNode)method));
        Statement statement = (Statement)method.getBody().statements().get(statementIndex);
        AstEditorTest.assertEquals((int)(statement.getStartPosition() + expectedIndexShift), (int)this.m_lastEditor.getStatementEndIndex(statement));
    }

    @Test
    public void test_removeStatement_0() throws Exception {
        TypeDeclaration testType = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("public class Test{", "  public Test() {", "    int a = 10;", "    {", "      int b = 100;", "      int c = 1000;", "    }", "  }", "}"));
        MethodDeclaration method = testType.getMethods()[0];
        Block block = (Block)DomGenerics.statements((Block)method.getBody()).get(1);
        List blockStatements = DomGenerics.statements((Block)block);
        Statement blockStatement = (Statement)blockStatements.get(0);
        this.m_lastEditor.removeStatement((Statement)block);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test{", "  public Test() {", "    int a = 10;", "  }", "}"), this.m_lastEditor);
        String expectedSource = this.m_lastEditor.getSource();
        this.m_lastEditor.removeStatement(blockStatement);
        AstEditorTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_removeStatement_1() throws Exception {
        String code = "void foo(){int value = 1;}";
        this.check_removeStatement(code, 0, "void foo(){}");
    }

    @Test
    public void test_removeStatement_2() throws Exception {
        String code = "void foo(){int value = 1;\t \t\n }";
        this.check_removeStatement(code, 0, "void foo(){\n }");
    }

    @Test
    public void test_removeStatement_3() throws Exception {
        String code = "void foo(){int value = 1; // abc \n }";
        this.check_removeStatement(code, 0, "void foo(){\n }");
    }

    @Test
    public void test_removeStatement_3_1() throws Exception {
        String code = "void foo(){int value = 1; // abc \r\n }";
        this.check_removeStatement(code, 0, "void foo(){\r\n }");
    }

    @Test
    public void test_removeStatement_4() throws Exception {
        String code = "void foo(){\t\t\n\t int value = 1;}";
        this.check_removeStatement(code, 0, "void foo(){}");
    }

    @Test
    public void test_removeStatement_5() throws Exception {
        String code = "void foo(){\t\t\n\t // abc\n/*qwe\n\trty*/ int value = 1;}";
        this.check_removeStatement(code, 0, "void foo(){}");
    }

    @Test
    public void test_removeStatement_6() throws Exception {
        String code = "void foo(){\n\tint a;\n\tint value = 1;\n}";
        this.check_removeStatement(code, 1, "void foo(){\n\tint a;\n}");
    }

    @Test
    public void test_removeStatement_7() throws Exception {
        String code = "void foo(){int a;{int b;}}";
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.check_removeStatement(code, nArray, "void foo(){int a;}");
    }

    @Test
    public void test_removeStatement_8() throws Exception {
        String code = "void foo(){int a;{int b;int c;}}";
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.check_removeStatement(code, nArray, "void foo(){int a;{int c;}}");
    }

    private void check_removeStatement(String code, int indexToRemove, String expectedSource) throws Exception {
        this.check_removeStatement(code, new int[]{indexToRemove}, expectedSource);
    }

    private void check_removeStatement(String code, int[] indexes, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        AstEditorTest.assertEquals((Object)code, (Object)this.m_lastEditor.getSource((ASTNode)method));
        Statement statement = AstEditorTest.getStatement(method.getBody(), indexes);
        this.m_lastEditor.removeStatement(statement);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)method));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_comments_1_removeLine() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("  void foo() {", "    // comment 0", "    int statementToRemove;", "  }", "  // comment 1"));
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        List commentList = this.m_lastEditor.getCommentList();
        AstEditorTest.assertEquals((int)2, (int)commentList.size());
        Comment comment_0 = (Comment)commentList.get(0);
        Comment comment_1 = (Comment)commentList.get(1);
        AstEditorTest.assertEquals((Object)"// comment 0", (Object)this.m_lastEditor.getSource((ASTNode)comment_0));
        AstEditorTest.assertEquals((Object)"// comment 1", (Object)this.m_lastEditor.getSource((ASTNode)comment_1));
        Statement statement = AstEditorTest.getStatement(method.getBody(), new int[1]);
        this.m_lastEditor.removeStatement(statement);
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertEquals((Object)"void foo() {\n\t}", (Object)this.m_lastEditor.getSource((ASTNode)method));
        List commentList2 = this.m_lastEditor.getCommentList();
        AstEditorTest.assertEquals((int)1, (int)commentList2.size());
        AstEditorTest.assertFalse((boolean)commentList2.contains(comment_0));
        AstEditorTest.assertTrue((boolean)commentList2.contains(comment_1));
        AstEditorTest.assertEquals((Object)"// comment 1", (Object)this.m_lastEditor.getSource((ASTNode)comment_1));
    }

    @Test
    public void test_comments_removeComment_whenReplace() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSource("  void foo() {", "    // comment 0", "    int statementToRemove;", "    // comment 1", "  }"));
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        List commentList = this.m_lastEditor.getCommentList();
        Assertions.assertThat((List)commentList).hasSize(2);
        Comment comment_0 = (Comment)commentList.get(0);
        Comment comment_1 = (Comment)commentList.get(1);
        AstEditorTest.assertEquals((Object)"// comment 0", (Object)this.m_lastEditor.getSource((ASTNode)comment_0));
        AstEditorTest.assertEquals((Object)"// comment 1", (Object)this.m_lastEditor.getSource((ASTNode)comment_1));
        Statement statement = AstEditorTest.getStatement(method.getBody(), new int[1]);
        this.m_lastEditor.removeStatement(statement);
        List commentList2 = this.m_lastEditor.getCommentList();
        ((ListAssert)Assertions.assertThat((List)commentList2).hasSize(1)).containsExactly((Object[])new Comment[]{comment_1});
        AstEditorTest.assertEquals((Object)"// comment 1", (Object)this.m_lastEditor.getSource((ASTNode)comment_1));
    }

    @Test
    public void test_comments_2_removeBlock() throws Exception {
        this.check_comments_2_removeBlock(new String[]{"  void foo() {", "    /* block comment */", "    int longDeclaration_1;", "  }"});
    }

    @Test
    public void test_comments_2_removeBlock2() throws Exception {
        this.check_comments_2_removeBlock(new String[]{"  void foo() {", "    /* block comment */", "  }", "  int longDeclaration_1;", "  int longDeclaration_2;", "  int longDeclaration_3;", "  int longDeclaration_4;"});
    }

    private void check_comments_2_removeBlock(String[] lines) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSource(lines));
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        List commentList = this.m_lastEditor.getCommentList();
        AstEditorTest.assertEquals((int)1, (int)commentList.size());
        Comment comment = (Comment)commentList.get(0);
        AstEditorTest.assertEquals((Object)"/* block comment */", (Object)this.m_lastEditor.getSource((ASTNode)comment));
        this.m_lastEditor.removeBodyDeclaration((BodyDeclaration)method);
        AstEditorTest.assertAST(this.m_lastEditor);
        commentList = this.m_lastEditor.getCommentList();
        AstEditorTest.assertEquals((int)0, (int)commentList.size());
    }

    @Test
    public void test_removeEnclosingStatement() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() {int a;}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement statement = (VariableDeclarationStatement)AstEditorTest.getStatement(method.getBody(), new int[1]);
        VariableDeclaration fragment = (VariableDeclaration)statement.fragments().get(0);
        this.m_lastEditor.removeEnclosingStatement((ASTNode)fragment);
        AstEditorTest.assertEquals((Object)"void foo() {}", (Object)this.m_lastEditor.getSource((ASTNode)method));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_removeInvocationArgument_0() throws Exception {
        this.check_removeInvocationArgument("System.out.println(0)", 0, "System.out.println()");
    }

    @Test
    public void test_removeInvocationArgument_1() throws Exception {
        this.check_removeInvocationArgument("bar(0, 1, 2)", 0, "bar(1, 2)");
    }

    @Test
    public void test_removeInvocationArgument_2() throws Exception {
        this.check_removeInvocationArgument("bar(0  ,  \r\n 1, 2)", 0, "bar(1, 2)");
    }

    @Test
    public void test_removeInvocationArgument_3() throws Exception {
        this.check_removeInvocationArgument("bar(0, 1, 2)", 1, "bar(0, 2)");
    }

    @Test
    public void test_removeInvocationArgument_4() throws Exception {
        this.check_removeInvocationArgument("bar(0, 1, 2)", 2, "bar(0, 1)");
    }

    @Test
    public void test_removeInvocationArgument_5() throws Exception {
        MethodInvocation invocation = this.check_removeInvocationArgument("bar(0, 1, 2)", 0, "bar(1, 2)");
        this.check_removeInvocationArgument(invocation, 0, "bar(2)");
    }

    private MethodInvocation check_removeInvocationArgument(String source, int argumentIndex, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() {" + source + ";} void bar(int a, int b, int c) {}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)method.getBody().statements().get(0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        return this.check_removeInvocationArgument(invocation, argumentIndex, expectedSource);
    }

    private MethodInvocation check_removeInvocationArgument(MethodInvocation invocation, int argumentIndex, String expectedSource) throws Exception {
        this.m_lastEditor.removeInvocationArgument(invocation, argumentIndex);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)invocation));
        AstEditorTest.assertAST(this.m_lastEditor);
        return invocation;
    }

    @Test
    public void test_moveInvocationArgument() throws Exception {
        MethodInvocation invocation = this.check_moveInvocationArgument("bar(0, 1, 2)", 0, 1, "bar(1, 0, 2)");
        this.check_moveInvocationArgument(invocation, 2, 1, "bar(1, 2, 0)");
    }

    private MethodInvocation check_moveInvocationArgument(String source, int oldArgumentIndex, int newArgumentIndex, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() {" + source + ";} void bar(int a, int b, int c) {}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)method.getBody().statements().get(0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        return this.check_moveInvocationArgument(invocation, oldArgumentIndex, newArgumentIndex, expectedSource);
    }

    private MethodInvocation check_moveInvocationArgument(MethodInvocation invocation, int oldArgumentIndex, int newArgumentIndex, String expectedSource) throws Exception {
        this.m_lastEditor.moveInvocationArgument(invocation, oldArgumentIndex, newArgumentIndex);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)invocation));
        AstEditorTest.assertAST(this.m_lastEditor);
        return invocation;
    }

    @Test
    public void test_removeCreationArgument() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate void foo() {\n\t\tnew Test(1, 2);\n\t}\n\tpublic Test(int a, int b) {\n\t}\n\tpublic Test(int a) {\n\t}\n}\n");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)method.getBody().statements().get(0);
        ClassInstanceCreation creation = (ClassInstanceCreation)statement.getExpression();
        this.m_lastEditor.removeCreationArgument(creation, 1);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  private void foo() {", "    new Test(1);", "  }", "  public Test(int a, int b) {", "  }", "  public Test(int a) {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addArrayElement_0() throws Exception {
        this.check_addArrayElement("new int[]{2, 3}", 0, "1", "new int[]{1, 2, 3}");
    }

    @Test
    public void test_addArrayElement_1() throws Exception {
        this.check_addArrayElement("new int[]{1, 3}", 1, "2", "new int[]{1, 2, 3}");
    }

    @Test
    public void test_addArrayElement_2() throws Exception {
        this.check_addArrayElement("new int[]{1, 2}", 2, "3", "new int[]{1, 2, 3}");
    }

    @Test
    public void test_addArrayElement_3() throws Exception {
        this.check_addArrayElement("new int[]{}", 0, "1", "new int[]{1}");
    }

    private void check_addArrayElement(String source, int elementIndex, String newElementSource, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() { int[] x = " + source + ";}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement statement = (VariableDeclarationStatement)method.getBody().statements().get(0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)statement.fragments().get(0);
        ArrayCreation creation = (ArrayCreation)fragment.getInitializer();
        this.m_lastEditor.addArrayElement(creation.getInitializer(), elementIndex, newElementSource);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)creation));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_removeArrayElement_0() throws Exception {
        this.check_removeArrayElement("new int[]{1, 2, 3}", 0, "new int[]{2, 3}");
    }

    @Test
    public void test_removeArrayElement_1() throws Exception {
        this.check_removeArrayElement("new int[]{1, 2, 3}", 1, "new int[]{1, 3}");
    }

    @Test
    public void test_removeArrayElement_2() throws Exception {
        this.check_removeArrayElement("new int[]{1, 2, 3}", 2, "new int[]{1, 2}");
    }

    @Test
    public void test_removeArrayElement_3() throws Exception {
        this.check_removeArrayElement("new int[]{1}", 0, "new int[]{}");
    }

    @Test
    public void test_removeArrayElement_noSuchIndex() throws Exception {
        this.check_removeArrayElement("new int[]{0, 1}", 2, "new int[]{0, 1}");
    }

    private void check_removeArrayElement(String source, int elementIndex, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() { int[] x = " + source + ";}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement statement = (VariableDeclarationStatement)method.getBody().statements().get(0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)statement.fragments().get(0);
        ArrayCreation creation = (ArrayCreation)fragment.getInitializer();
        this.m_lastEditor.removeArrayElement(creation.getInitializer(), elementIndex);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)creation));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_moveArrayElement() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() { int[] a = new int[]{0}; int[] b = new int[]{1, 2};}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement statementA = (VariableDeclarationStatement)method.getBody().statements().get(0);
        VariableDeclarationFragment fragmentA = (VariableDeclarationFragment)statementA.fragments().get(0);
        ArrayCreation oldCreation = (ArrayCreation)fragmentA.getInitializer();
        VariableDeclarationStatement statementB = (VariableDeclarationStatement)method.getBody().statements().get(1);
        VariableDeclarationFragment fragmentB = (VariableDeclarationFragment)statementB.fragments().get(0);
        ArrayCreation newCreation = (ArrayCreation)fragmentB.getInitializer();
        Expression moveElement = this.m_lastEditor.moveArrayElement(oldCreation.getInitializer(), newCreation.getInitializer(), 0, 1);
        AstEditorTest.assertNotNull((Object)moveElement);
        AstEditorTest.assertSame((Object)newCreation.getInitializer(), (Object)moveElement.getParent());
        AstEditorTest.assertEquals((Object)"new int[]{}", (Object)this.m_lastEditor.getSource((ASTNode)oldCreation));
        AstEditorTest.assertEquals((Object)"new int[]{1, 0, 2}", (Object)this.m_lastEditor.getSource((ASTNode)newCreation));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_exchangeArrayElements_1() throws Exception {
        this.check_exchangeArrayElements("new int[]{1, 2, 3, 4}", 0, 2, "new int[]{3, 2, 1, 4}");
    }

    @Test
    public void test_exchangeArrayElements_2() throws Exception {
        this.check_exchangeArrayElements("new int[]{111, 2, 3, 4}", 0, 2, "new int[]{3, 2, 111, 4}");
    }

    @Test
    public void test_exchangeArrayElements_3() throws Exception {
        this.check_exchangeArrayElements("new int[]{1, 2, 333, 4}", 0, 2, "new int[]{333, 2, 1, 4}");
    }

    @Test
    public void test_exchangeArrayElements_4() throws Exception {
        this.check_exchangeArrayElements("new int[]{1, 2, 3, 4}", 2, 0, "new int[]{3, 2, 1, 4}");
    }

    @Test
    public void test_exchangeArrayElements_5() throws Exception {
        this.check_exchangeArrayElements("new int[]{111, 2, 3, 4}", 2, 0, "new int[]{3, 2, 111, 4}");
    }

    @Test
    public void test_exchangeArrayElements_6() throws Exception {
        this.check_exchangeArrayElements("new int[]{1, 2, 333, 4}", 2, 0, "new int[]{333, 2, 1, 4}");
    }

    private void check_exchangeArrayElements(String source, int index_1, int index_2, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() { int[] x = " + source + ";}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement statement = (VariableDeclarationStatement)method.getBody().statements().get(0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)statement.fragments().get(0);
        ArrayCreation creation = (ArrayCreation)fragment.getInitializer();
        this.m_lastEditor.exchangeArrayElements(creation.getInitializer(), index_1, index_2);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)creation));
        AstEditorTest.assertAST(this.m_lastEditor);
        this.m_lastEditor.exchangeArrayElements(creation.getInitializer(), index_1, index_2);
        AstEditorTest.assertEquals((Object)source, (Object)this.m_lastEditor.getSource((ASTNode)creation));
        AstEditorTest.assertAST(this.m_lastEditor);
        this.m_lastEditor.exchangeArrayElements(creation.getInitializer(), index_1, index_2);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)creation));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_addInvocationArgument_1() throws Exception {
        this.check_addInvocationArgument("bar()", 0, "0", "bar(0)");
    }

    @Test
    public void test_addInvocationArgument_2() throws Exception {
        this.check_addInvocationArgument("bar(1)", 0, "0", "bar(0, 1)");
    }

    @Test
    public void test_addInvocationArgument_3() throws Exception {
        this.check_addInvocationArgument("bar(0)", 1, "1", "bar(0, 1)");
    }

    @Test
    public void test_addInvocationArgument_4() throws Exception {
        this.check_addInvocationArgument("bar(0, 2)", 1, "1", "bar(0, 1, 2)");
    }

    @Test
    public void test_addInvocationArgument_5() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSourceDQ("package test;", "public class Test {", "  Test() {", "    bar(null);", "  }", "  void bar(Object a) {}", "  void bar(Object a, Object b) {}", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)method.getBody().statements().get(0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        this.m_lastEditor.addInvocationArgument(invocation, 1, "new java.util.ArrayList()");
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "import java.util.ArrayList;", "public class Test {", "  Test() {", "    bar(null, new ArrayList());", "  }", "  void bar(Object a) {}", "  void bar(Object a, Object b) {}", "}"), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    private MethodInvocation check_addInvocationArgument(String source, int argumentIndex, String argumentSource, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo() {" + source + ";} void bar() {} void bar(int a) {}  void bar(int a, int b) {}  void bar(int a, int b, int c) {}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)method.getBody().statements().get(0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        return this.check_addInvocationArgument(invocation, argumentIndex, argumentSource, expectedSource);
    }

    private MethodInvocation check_addInvocationArgument(MethodInvocation invocation, int argumentIndex, String argumentSource, String expectedSource) throws Exception {
        this.m_lastEditor.addInvocationArgument(invocation, argumentIndex, argumentSource);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)invocation));
        AstEditorTest.assertAST(this.m_lastEditor);
        return invocation;
    }

    @Test
    public void test_addCreationArgument() throws Exception {
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  Test() {", "    new java.util.ArrayList();", "  }", "}"));
        ClassInstanceCreation creation = (ClassInstanceCreation)this.m_lastEditor.getEnclosingNode("new java.util.");
        AstEditorTest.assertEquals((Object)"<init>()", (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation));
        this.m_lastEditor.addCreationArgument(creation, 0, "10");
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  Test() {", "    new java.util.ArrayList(10);", "  }", "}"), this.m_lastEditor);
        AstEditorTest.assertEquals((Object)"<init>(int)", (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation));
    }

    @Test
    public void test_addAnonymousClassDeclaration() throws Exception {
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "import java.util.ArrayList;", "public class Test {", "  Test() {", "    ArrayList list = new ArrayList(10);", "  }", "}"));
        ClassInstanceCreation creation = (ClassInstanceCreation)this.getNode("new ArrayList");
        AstEditorTest.assertNull((Object)creation.getAnonymousClassDeclaration());
        AstEditorTest.assertEquals((Object)"<init>(int)", (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation));
        this.m_lastEditor.addAnonymousClassDeclaration(creation);
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "import java.util.ArrayList;", "public class Test {", "  Test() {", "    ArrayList list = new ArrayList(10) {", "    };", "  }", "}"), this.m_lastEditor);
        AstEditorTest.assertNotNull((Object)creation.getAnonymousClassDeclaration());
        AstEditorTest.assertEquals((Object)"<init>(int)", (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation));
    }

    @Test
    public void test_replaceInvocationName() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "  void foo() {", "    bar(0);", "  }", "  void bar(int a) {", "  }", "  void baz(int a) {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)methodDeclaration.getBody().statements().get(0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        this.m_lastEditor.replaceInvocationName(invocation, "baz");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "  void foo() {", "    baz(0);", "  }", "  void bar(int a) {", "  }", "  void baz(int a) {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceInvocationExpression_nullExpression() throws Exception {
        AstEditorTest.setFileContentSrc("test/Wrapper.java", AstEditorTest.getSource("package test;", "public class Wrapper {", "  public void print(int value) {", "  }", "}"));
        this.createTypeDeclaration_TestD("package test;", "public class Test {", "  void foo() {", "    print(0);", "  }", "  void print(int value) {", "  }", "  Wrapper getWrapper() {", "    return null;", "  }", "}");
        MethodInvocation invocation = this.getNode("print(0)", MethodInvocation.class);
        this.m_lastEditor.replaceInvocationExpression(invocation, "getWrapper()");
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  void foo() {", "    getWrapper().print(0);", "  }", "  void print(int value) {", "  }", "  Wrapper getWrapper() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceInvocationExpression_ThisExpression() throws Exception {
        AstEditorTest.setFileContentSrc("test/Wrapper.java", AstEditorTest.getSource("package test;", "public class Wrapper {", "  public void print(int value) {", "  }", "}"));
        this.createTypeDeclaration_TestD("package test;", "public class Test {", "  void foo() {", "    this.print(0);", "  }", "  void print(int value) {", "  }", "  Wrapper getWrapper() {", "    return null;", "  }", "}");
        MethodInvocation invocation = this.getNode("print(0)", MethodInvocation.class);
        this.m_lastEditor.replaceInvocationExpression(invocation, "getWrapper()");
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  void foo() {", "    getWrapper().print(0);", "  }", "  void print(int value) {", "  }", "  Wrapper getWrapper() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceInvocationExpression_anyExpression() throws Exception {
        AstEditorTest.setFileContentSrc("test/Wrapper.java", AstEditorTest.getSource("package test;", "public class Wrapper {", "  public void print(int value) {", "  }", "}"));
        this.createTypeDeclaration_TestD("package test;", "public class Test {", "  void foo() {", "    new Wrapper().print(0);", "  }", "  Wrapper getWrapper() {", "    return null;", "  }", "}");
        MethodInvocation invocation = this.getNode("print(0)", MethodInvocation.class);
        this.m_lastEditor.replaceInvocationExpression(invocation, "getWrapper()");
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  void foo() {", "    getWrapper().print(0);", "  }", "  Wrapper getWrapper() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceCreationArguments_1() throws Exception {
        String[] newArgumentsLines = new String[]{"1"};
        String[] expectedSourceLines = new String[]{"package test;", "import java.util.*;", "public class Test {", "  void foo() {", "    Object o = new ArrayList(1);", "  }", "}"};
        this.check_replaceCreationArguments(newArgumentsLines, expectedSourceLines, "<init>(int)");
    }

    @Test
    public void test_replaceCreationArguments_2() throws Exception {
        String[] newArgumentsLines = new String[]{"1", "\t+", "\t2"};
        String[] expectedSourceLines = new String[]{"package test;", "import java.util.*;", "public class Test {", "  void foo() {", "    Object o = new ArrayList(1", "      +", "      2);", "  }", "}"};
        this.check_replaceCreationArguments(newArgumentsLines, expectedSourceLines, "<init>(int)");
    }

    @Test
    public void test_replaceCreationArguments_3() throws Exception {
        String[] newArgumentsLines = new String[]{"java.util.Collections.EMPTY_LIST"};
        String[] expectedSourceLines = new String[]{"package test;", "import java.util.*;", "public class Test {", "  void foo() {", "    Object o = new ArrayList(Collections.EMPTY_LIST);", "  }", "}"};
        this.check_replaceCreationArguments(newArgumentsLines, expectedSourceLines, "<init>(java.util.Collection)");
    }

    private void check_replaceCreationArguments(String[] newArgumentsLines, String[] expectedSourceLines, String expectedSignature) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.util.*;\npublic class Test {\n\tvoid foo() {\n\t\tObject o = new ArrayList();\n\t}\n}\n");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement statement = (VariableDeclarationStatement)methodDeclaration.getBody().statements().get(0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)statement.fragments().get(0);
        ClassInstanceCreation creation = (ClassInstanceCreation)fragment.getInitializer();
        this.m_lastEditor.replaceCreationArguments(creation, List.of(newArgumentsLines));
        AstEditorTest.assertEditor(AstEditorTest.getSource(expectedSourceLines), this.m_lastEditor);
        String actualSignature = AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation);
        AstEditorTest.assertEquals((Object)expectedSignature, (Object)actualSignature);
    }

    @Test
    public void test_replaceInvocationArguments() throws Exception {
        AstEditorTest.setFileContentSrc("MyObject.java", AstEditorTest.getSourceDQ("public class MyObject {", "  public void setText(int i, boolean b) {", "  }", "}"));
        this.createTypeDeclaration_TestD("public class Test {", "  public Test() {", "    MyObject obj = new MyObject();", "    obj.setText(1, false);", "  }", "}");
        MethodInvocation invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode(", ");
        this.m_lastEditor.replaceInvocationArguments(invocation, List.of("2, true"));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "  public Test() {", "    MyObject obj = new MyObject();", "    obj.setText(2, true);", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceInvocationArguments_whenChained() throws Exception {
        AstEditorTest.setFileContentSrc("MyObject.java", AstEditorTest.getSourceDQ("public class MyObject {", "  public void foo(int i, boolean b) {", "  }", "}"));
        this.createTypeDeclaration_TestD("public class Test {", "  public Test() {", "    getObj().foo(1, false);", "  }", "  private MyObject getObj() {", "    return null;", "  }", "}");
        MethodInvocation invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode(", ");
        this.m_lastEditor.replaceInvocationArguments(invocation, List.of("2, true"));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "  public Test() {", "    getObj().foo(2, true);", "  }", "  private MyObject getObj() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_inlineParenthesizedExpression() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tObject obj = new Object();\n\t\t((obj)).hashCode();\n\t}\n}\n");
        Expression objNode = (Expression)this.m_lastEditor.getEnclosingNode("obj)");
        this.m_lastEditor.inlineParenthesizedExpression(objNode);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    Object obj = new Object();", "    obj.hashCode();", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_hasEnclosingTryStatement_noTryStatement() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint value;\n\t}\n}");
        Statement statement = this.getNode("int value", Statement.class);
        AstEditorTest.assertFalse((boolean)this.m_lastEditor.hasEnclosingTryStatement(statement, "java.lang.Throwable"));
    }

    @Test
    public void test_hasEnclosingTryStatement_noSuchCatch() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\ttry {\n\t\t\tint value;\n\t\t} catch (java.lang.Exception e) {\n\t\t}\n\t}\n}");
        Statement statement = this.getNode("int value", Statement.class);
        AstEditorTest.assertFalse((boolean)this.m_lastEditor.hasEnclosingTryStatement(statement, "java.lang.Throwable"));
    }

    @Test
    public void test_hasEnclosingTryStatement_hasExactCatch() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\ttry {\n\t\t\tint value;\n\t\t} catch (java.lang.Exception e) {\n\t\t}\n\t}\n}");
        Statement statement = this.getNode("int value", Statement.class);
        AstEditorTest.assertTrue((boolean)this.m_lastEditor.hasEnclosingTryStatement(statement, "java.lang.Exception"));
    }

    @Test
    public void test_hasEnclosingTryStatement_hasSuperCatch() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\ttry {\n\t\t\tint value;\n\t\t} catch (java.lang.Throwable e) {\n\t\t}\n\t}\n}");
        Statement statement = this.getNode("int value", Statement.class);
        AstEditorTest.assertTrue((boolean)this.m_lastEditor.hasEnclosingTryStatement(statement, "java.lang.Exception"));
    }

    @Test
    public void test_encloseInTryStatement() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint value;\n\t}\n}\n");
        Block sourceBlock = typeDeclaration.getMethods()[0].getBody();
        Statement statement = (Statement)DomGenerics.statements((Block)sourceBlock).get(0);
        this.m_lastEditor.encloseInTryStatement(statement, "java.lang.Throwable");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    try {", "      int value;", "    } catch (Throwable e) {", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_removeEmptyTryStatements() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\ttry{\n\t\t} finally {\n\t\t}\n\t\ttry {\n\t\t\tint value;\n\t\t} finally {\n\t\t}\n\t}\n}\n");
        this.m_lastEditor.removeEmptyTryStatements();
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    try {", "      int value;", "    } finally {", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_encloseInBlock() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint value;\n\t}\n}\n");
        Block sourceBlock = typeDeclaration.getMethods()[0].getBody();
        Statement statement = (Statement)DomGenerics.statements((Block)sourceBlock).get(0);
        this.m_lastEditor.encloseInBlock(statement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    {", "      int value;", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_inlineBlock() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t\t{\n\t\t\tint b;\n\t\t\tint c;\n\t\t\tint d;\n\t\t}\n\t\tint e;\n\t}\n}\n");
        Block mainBlock = typeDeclaration.getMethods()[0].getBody();
        Block blockToInline = (Block)DomGenerics.statements((Block)mainBlock).get(1);
        this.m_lastEditor.inlineBlock(blockToInline);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    int a;", "    int b;", "    int c;", "    int d;", "    int e;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addStatement_1() throws Exception {
        String methodCode = "int f; void foo() {\n\tint a; // test \n}";
        String statementCode = "System.out.println(f);";
        String expectedMethodCode = "{\n\t" + statementCode + "\n\tint a; // test \n}";
        this.check_addStatement(methodCode, 0, true, statementCode, expectedMethodCode);
    }

    @Test
    public void test_addStatement_2() throws Exception {
        String methodCode = "void foo() {\n\tint a; // test \n}";
        String statementCode = "System.out.println(a);";
        String expectedMethodCode = "{\n\tint a; // test \n\t" + statementCode + "\n}";
        this.check_addStatement(methodCode, 0, false, statementCode, expectedMethodCode);
    }

    @Test
    public void test_addStatement_2a() throws Exception {
        String methodCode = "\nvoid foo() {int a;}";
        String statementCode = "System.out.println(a);";
        String expectedMethodCode = "{int a;\n" + statementCode + "}";
        this.check_addStatement(methodCode, 0, false, statementCode, expectedMethodCode);
    }

    @Test
    public void test_addStatement_2b() throws Exception {
        String methodCode = "\nvoid foo(int p) {int a;}";
        String statementCode = "System.out.println(p);";
        String expectedMethodCode = "{int a;\n" + statementCode + "}";
        this.check_addStatement(methodCode, 0, false, statementCode, expectedMethodCode);
    }

    @Test
    public void test_addStatement_2c() throws Exception {
        String methodCode = "boolean z;byte b;char c;short s;int i;long l;float f;double d;Object o;String str; \nvoid foo() {int a;}";
        String statementCode = "System.out.println(a);";
        String expectedMethodCode = "{int a;\n" + statementCode + "}";
        this.check_addStatement(methodCode, 0, false, statementCode, expectedMethodCode);
    }

    @Test
    public void test_addStatement_3() throws Exception {
        String methodCode = "\n\tvoid foo() {\n\t\tint a;\n\t}";
        String statementCode = "System.out.println();";
        String expectedMethodCode = "{\n\t\t" + statementCode + "\n\t\tint a;\n\t}";
        this.check_addStatement(methodCode, -1, true, statementCode, expectedMethodCode);
    }

    @Test
    public void test_addStatement_4() throws Exception {
        String methodCode = "\n\tvoid foo() {\n\t\tint a;\n\t}";
        String statementCode = "System.out.println(a);";
        String expectedMethodCode = "{\n\t\tint a;\n\t\t" + statementCode + "\n\t}";
        this.check_addStatement(methodCode, -1, false, statementCode, expectedMethodCode);
    }

    private void check_addStatement(String methodCode, int targetStatementIndex, boolean before, String statementCode, String expectedMethodCode) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(methodCode);
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        Statement targetStatement = targetStatementIndex != -1 ? (Statement)targetMethod.getBody().statements().get(targetStatementIndex) : null;
        StatementTarget target = new StatementTarget(targetMethod.getBody(), targetStatement, before);
        Statement newStatement = this.m_lastEditor.addStatement(statementCode, target);
        AstEditorTest.assertNotNull((Object)newStatement);
        AstEditorTest.assertEquals((Object)expectedMethodCode, (Object)this.m_lastEditor.getSource((ASTNode)targetMethod.getBody()));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_addStatement_5() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.*;\nimport javax.swing.*;\nclass Test extends JPanel {\n\tTest() {\n\t\t{\n\t\t}\n\t}\n}\n");
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        Block targetBlock = (Block)AstEditorTest.getStatement(targetMethod.getBody(), new int[1]);
        String source = "setVisible(false);";
        this.m_lastEditor.addStatement(source, new StatementTarget(targetBlock, true));
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "    {", "      " + source, "    }", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_addStatement_6() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.*;\nimport javax.swing.*;\nclass Test extends JPanel {\n\tTest() {\n\t\tSystem.out.println(1);\n\t\t// existing comment\n\t\tSystem.out.println(2);\n\t}\n}\n");
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        Statement targetStatement = (Statement)targetMethod.getBody().statements().get(1);
        this.m_lastEditor.addStatement(List.of("// first comment", "// second comment", "setVisible(false);"), new StatementTarget(targetStatement, true));
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "    System.out.println(1);", "    // first comment", "    // second comment", "    setVisible(false);", "    // existing comment", "    System.out.println(2);", "  }", "}"), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_addStatement_7() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tTest() {\n\t\tSystem.out.println(1); // end of line comment\n\t\tSystem.out.println(2);\n\t}\n}\n");
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        Statement targetStatement = (Statement)targetMethod.getBody().statements().get(0);
        this.m_lastEditor.addStatement("System.out.println(false);", new StatementTarget(targetStatement, false));
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "class Test {", "  Test() {", "    System.out.println(1); // end of line comment", "    System.out.println(false);", "    System.out.println(2);", "  }", "}"), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_addStatement_8() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test {\n\tTest() {\n\t}\n}\n");
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        Block targetBlock = targetMethod.getBody();
        this.m_lastEditor.addStatement("java.util.List myList = new java.util.ArrayList();", new StatementTarget(targetBlock, true));
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "import java.util.List;", "import java.util.ArrayList;", "// filler filler filler", "class Test {", "  Test() {", "    List myList = new ArrayList();", "  }", "}"), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_addStatement_beforeStatement_inIfStatement_thenWithElse() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tif (true)\n\t\t\tSystem.out.println(0);\n\t\telse\n\t\t\tSystem.out.println(1);\n\t}\n}\n");
        Statement targetStatement = this.getNode("System.out.println(0)", Statement.class);
        this.m_lastEditor.addStatement("int a;", new StatementTarget(targetStatement, true));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "    if (true) {", "      int a;", "      System.out.println(0);", "    }", "    else", "      System.out.println(1);", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addStatement_beforeStatement_inIfStatement_onlyThen() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tif (true)\n\t\t\tSystem.out.println();\n\t}\n}\n");
        Statement targetStatement = this.getNode("System.out.println()", Statement.class);
        this.m_lastEditor.addStatement("int a;", new StatementTarget(targetStatement, true));
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "    if (true) {", "      int a;", "      System.out.println();", "    }", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_addStatement_x_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", "package test;\nimport java.awt.*; import javax.swing.*;class Test extends JPanel {Test() {}}");
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        this.m_lastEditor.addStatement("setVisible(false);", new StatementTarget(targetMethod, true));
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertEquals((Object)"package test;\nimport java.awt.*; import javax.swing.*;class Test extends JPanel {Test() {\n\tsetVisible(false);}}", (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_addStatement_x_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", "package test;\nimport java.awt.*; import javax.swing.*;class Test extends JPanel {Test() {} int foo(){return 1;}}");
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        this.m_lastEditor.addStatement("foo();", new StatementTarget(targetMethod, true));
        AstEditorTest.assertAST(this.m_lastEditor);
        AstEditorTest.assertEquals((Object)"package test;\nimport java.awt.*; import javax.swing.*;class Test extends JPanel {Test() {\n\tfoo();} int foo(){return 1;}}", (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_addStatement_parseError() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "  }", "}"));
        MethodDeclaration targetMethod = typeDeclaration.getMethods()[0];
        try {
            this.m_lastEditor.addStatement("somethingBad();", new StatementTarget(targetMethod, true));
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            DesignerException statementDE = DesignerExceptionUtils.getDesignerException((Throwable)e);
            AstEditorTest.assertEquals((int)205, (int)statementDE.getCode());
            Object[] parameters = statementDE.getParameters();
            Assertions.assertThat((Object[])parameters).hasSize(2);
            Assertions.assertThat((String)((String)parameters[0])).contains(new CharSequence[]{"somethingBad();"});
            Assertions.assertThat((String)((String)parameters[1])).contains(new CharSequence[]{"The method somethingBad() is undefined"});
            DesignerException nodeDE = (DesignerException)statementDE.getCause();
            AstEditorTest.assertEquals((int)205, (int)nodeDE.getCode());
            Object[] parameters2 = nodeDE.getParameters();
            Assertions.assertThat((Object[])parameters2).hasSize(2);
            Assertions.assertThat((String)((String)parameters2[0])).contains(new CharSequence[]{"somethingBad();"});
            Assertions.assertThat((String)((String)parameters2[1])).contains(new CharSequence[]{"The method somethingBad() is undefined"});
        }
    }

    @Test
    public void test_removeBodyDeclaration_1() throws Exception {
        String code = "int aaa;\tint bbb; int ccc;";
        this.check_removeBodyDeclaration(code, 1, "int aaa;\tint ccc;");
    }

    @Test
    public void test_removeBodyDeclaration_2() throws Exception {
        String code = "int aaa;\n\t\tint bbb;\n\tint ccc;";
        this.check_removeBodyDeclaration(code, 1, "int aaa;\n\tint ccc;");
    }

    @Test
    public void test_removeBodyDeclaration_3() throws Exception {
        String code = "int aaa; int bbb; int ccc;";
        this.check_removeBodyDeclaration(code, 0, "int bbb; int ccc;");
    }

    @Test
    public void test_removeBodyDeclaration_4() throws Exception {
        String code = "int aaa; int bbb; int ccc;";
        this.check_removeBodyDeclaration(code, 2, "int aaa; int bbb; ");
    }

    @Test
    public void test_removeBodyDeclaration_4_2() throws Exception {
        String code = "int aaa;\nint bbb;\nint ccc;\n";
        this.check_removeBodyDeclaration(code, 2, "int aaa;\nint bbb;\n");
    }

    @Test
    public void test_removeBodyDeclaration_5() throws Exception {
        String code = "int aaa; \n\t\t\nint bbb; int ccc;";
        this.check_removeBodyDeclaration(code, 1, "int aaa; int ccc;");
    }

    @Test
    public void test_removeBodyDeclaration_6() throws Exception {
        String code = "\t\t\n\tint aaa; \n\t\t\nint bbb; int ccc;";
        this.check_removeBodyDeclaration(code, 0, "\n\t\t\nint bbb; int ccc;");
    }

    @Test
    public void test_removeBodyDeclaration_EOLC_before() throws Exception {
        String code = "int aaa; // EOL comment\nint bbb;\nint ccc;";
        this.check_removeBodyDeclaration(code, 1, "int aaa; // EOL comment\nint ccc;");
    }

    @Test
    public void test_removeBodyDeclaration_EOLC_after() throws Exception {
        String code = "int aaa;\nint bbb; // EOL comment\nint ccc;";
        this.check_removeBodyDeclaration(code, 1, "int aaa;\nint ccc;");
    }

    private void check_removeBodyDeclaration(String code, int index, String expectedSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        BodyDeclaration declaration = (BodyDeclaration)typeDeclaration.bodyDeclarations().get(index);
        this.m_lastEditor.removeBodyDeclaration(declaration);
        int start = this.m_lastEditor.getSource().indexOf("{", typeDeclaration.getStartPosition()) + "{".length();
        int end = typeDeclaration.getStartPosition() + typeDeclaration.getLength() - "}".length();
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource(start, end - start));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_removeBodyDeclaration_anonymous() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test extends javax.swing.JPanel {\n\tpublic Test() {\n\t\taddKeyListener(new java.awt.event.KeyAdapter() {\n\t\t\tpublic void keyPressed(java.awt.event.KeyEvent e) {\n\t\t\t}\n\t\t});\n\t}\n}\n");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        ExpressionStatement addStatement = (ExpressionStatement)methodDeclaration.getBody().statements().get(0);
        MethodInvocation addInvocation = (MethodInvocation)addStatement.getExpression();
        ClassInstanceCreation listenerCreation = (ClassInstanceCreation)addInvocation.arguments().get(0);
        AnonymousClassDeclaration listenerDeclaration = listenerCreation.getAnonymousClassDeclaration();
        MethodDeclaration methodToRemove = (MethodDeclaration)listenerDeclaration.bodyDeclarations().get(0);
        this.m_lastEditor.removeBodyDeclaration((BodyDeclaration)methodToRemove);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "class Test extends javax.swing.JPanel {", "  public Test() {", "    addKeyListener(new java.awt.event.KeyAdapter() {", "    });", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_removeVariableDeclaration_field() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import javax.swing.*;\nclass Test extends JPanel {\n\tprivate JButton button_1 = new JButton(), button_2, button_3 = new JButton(), button_4;\n\tTest() {\n\t}\n}\n");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        List fragments = DomGenerics.fragments((FieldDeclaration)fieldDeclaration);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(0));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  private JButton button_2, button_3 = new JButton(), button_4;", "  Test() {", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(1));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  private JButton button_2, button_4;", "  Test() {", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(1));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  private JButton button_2;", "  Test() {", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(0));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_removeVariableDeclaration_local() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import javax.swing.*;\nclass Test extends JPanel {\n\tTest() {\n\t\tJButton button_1 = new JButton(), button_2, button_3 = new JButton(), button_4;\n\t}\n}\n");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        VariableDeclarationStatement variableDeclaration = (VariableDeclarationStatement)methodDeclaration.getBody().statements().get(0);
        List fragments = DomGenerics.fragments((VariableDeclarationStatement)variableDeclaration);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(0));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "    JButton button_2, button_3 = new JButton(), button_4;", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(1));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "    JButton button_2, button_4;", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(1));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "    JButton button_2;", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.removeVariableDeclaration((VariableDeclaration)fragments.get(0));
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test extends JPanel {", "  Test() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_removeDanglingJavadoc_attachedJavaDoc() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler\n// filler filler filler filler filler\nclass Test {\n\t/** not dangling */\n\tprivate int javaDocTarget;\n}\n");
        this.m_lastEditor.removeDanglingJavadoc();
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "// filler filler filler filler filler", "// filler filler filler filler filler", "class Test {", "  /** not dangling */", "  private int javaDocTarget;", "}"), this.m_lastEditor);
    }

    @Test
    public void test_removeDanglingJavadoc_onlyWhitespaces() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler\n// filler filler filler filler filler\nclass Test {\n\t/** dangling */\n}\n");
        this.m_lastEditor.removeDanglingJavadoc();
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "// filler filler filler filler filler", "// filler filler filler filler filler", "class Test {", "}"), this.m_lastEditor);
    }

    @Test
    public void test_removeDanglingJavadoc_lineComments() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler\n// filler filler filler filler filler\nclass Test {\n\t/** dangling */\n\t// line comment A\n\t// line comment B\n}\n");
        this.m_lastEditor.removeDanglingJavadoc();
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "// filler filler filler filler filler", "// filler filler filler filler filler", "class Test {", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadoc_setNew() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Javadoc newJavadoc = this.m_lastEditor.setJavadoc((BodyDeclaration)methodDeclaration, new String[]{"first line", "second line"});
        AstEditorTest.assertNotNull((Object)newJavadoc);
        AstEditorTest.assertEditor(AstEditorTest.getSource("public class Test {", "\t/**", "\t * first line", "\t * second line", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadoc_replaceExisting() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * old comment", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Javadoc newJavadoc = this.m_lastEditor.setJavadoc((BodyDeclaration)methodDeclaration, new String[]{"first line", "second line"});
        AstEditorTest.assertNotNull((Object)newJavadoc);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * first line", "\t * second line", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadoc_removeExisting() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("// filler filler filler", "public class Test {", "\t/**", "\t * old comment", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Javadoc newJavadoc = this.m_lastEditor.setJavadoc((BodyDeclaration)methodDeclaration, null);
        AstEditorTest.assertNull((Object)newJavadoc);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("// filler filler filler", "public class Test {", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadoc_removeIgnore() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("// filler filler filler", "public class Test {", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Javadoc newJavadoc = this.m_lastEditor.setJavadoc((BodyDeclaration)methodDeclaration, null);
        AstEditorTest.assertNull((Object)newJavadoc);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("// filler filler filler", "public class Test {", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_replaceExisting() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * @tag aaa bbb ccc", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " 111 222 333");
        AstEditorTest.assert_setJavadocTagText_element(tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * @tag 111 222 333", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_addJavadoc() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("// filler filler filler", "public class Test {", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " 111 222 333");
        AstEditorTest.assert_setJavadocTagText_element(tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("// filler filler filler", "public class Test {", "\t/**", "\t * @tag 111 222 333", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_addTagElement() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * Some text.", "\t * More text.", "\t * @otherTag the text.", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " 111 222 333");
        AstEditorTest.assert_setJavadocTagText_element(tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * Some text.", "\t * More text.", "\t * @otherTag the text.", "\t * @tag 111 222 333", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_addTagElement2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * Some text.", "\t * More text.", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " 111 222 333");
        AstEditorTest.assert_setJavadocTagText_element(tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * Some text.", "\t * More text.", "\t * @tag 111 222 333", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_addTagElement_emptyJavaDoc() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " 111 222 333");
        AstEditorTest.assert_setJavadocTagText_element(tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * @tag 111 222 333", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_removeExisting() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * Some text.", "\t * @tagBefore the text", "\t * @tag aaa bbb ccc", "\t * @tagAfter the text", "\t * More text.", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", null);
        AstEditorTest.assertNull((Object)tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * Some text.", "\t * @tagBefore the text", "\t * @tagAfter the text", "\t * More text.", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_removeExisting_onlyTextLeft() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * Just some text", "\t * @tag aaa bbb ccc", "\t */", "  public void foo() {", "  }", "  // filler filler filler", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", null);
        AstEditorTest.assertNull((Object)tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * Just some text", "\t */", "  public void foo() {", "  }", "  // filler filler filler", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_removeExisting_noMoreTags() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * @tag aaa bbb ccc", "\t */", "  public void foo() {", "  }", "  // filler filler filler", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", null);
        AstEditorTest.assertNull((Object)tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "  public void foo() {", "  }", "  // filler filler filler", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_removeNoSuchTag() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * @otherTag aaa bbb ccc", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", null);
        AstEditorTest.assertNull((Object)tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * @otherTag aaa bbb ccc", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_removeNoJavadoc() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "  public void foo() {", "    // some inner comment", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", null);
        AstEditorTest.assertNull((Object)tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "  public void foo() {", "    // some inner comment", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_noExistingFragments_noNewFragments() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * @tag", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", "");
        AstEditorTest.assert_setJavadocTagText_element(tagElement, "");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * @tag", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_noExistingFragments_setNewFragments() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("public class Test {", "\t/**", "\t * @tag", "\t */", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " text");
        AstEditorTest.assert_setJavadocTagText_element(tagElement, " text");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("public class Test {", "\t/**", "\t * @tag text", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_setJavadocTagText_bug_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestD("// filler filler filler", "public class Test {", "  public void foo() {", "  }", "}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TagElement tagElement = this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " 111 222 333");
        AstEditorTest.assert_setJavadocTagText_element(tagElement);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("// filler filler filler", "public class Test {", "\t/**", "\t * @tag 111 222 333", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
        this.m_lastEditor.ensureClassImport2("java.util.ArrayList");
        this.m_lastEditor.setJavadocTagText((BodyDeclaration)methodDeclaration, "@tag", " aaa bbbb ccccc");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("import java.util.ArrayList;", "// filler filler filler", "public class Test {", "\t/**", "\t * @tag aaa bbbb ccccc", "\t */", "  public void foo() {", "  }", "}"), this.m_lastEditor);
    }

    private static void assert_setJavadocTagText_element(TagElement tagElement) {
        AstEditorTest.assert_setJavadocTagText_element(tagElement, " 111 222 333");
    }

    private static void assert_setJavadocTagText_element(TagElement tagElement, String text) {
        AstEditorTest.assertNotNull((Object)tagElement);
        AstEditorTest.assertEquals((Object)"@tag", (Object)tagElement.getTagName());
        List fragments = DomGenerics.fragments((TagElement)tagElement);
        AstEditorTest.assertEquals((int)1, (int)fragments.size());
        AstEditorTest.assertEquals((Object)text, (Object)((TextElement)fragments.get(0)).getText());
    }

    @Test
    public void test_ensureClassImport_1() throws Exception {
        String source = AstEditorTest.getSourceDQ("// filler filler filler", "package test;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "java.lang.Integer", source, "Integer");
    }

    @Test
    public void test_ensureClassImport_2() throws Exception {
        String source = AstEditorTest.getSourceDQ("package test;", "import java.util.List;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "java.util.List", source, "List");
    }

    @Test
    public void test_ensureClassImport_3() throws Exception {
        String source = AstEditorTest.getSourceDQ("package test;", "import java.util.*;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "java.util.List", source, "List");
    }

    @Test
    public void test_ensureClassImport_4() throws Exception {
        String source_1 = AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "  }", "}");
        String source_2 = AstEditorTest.getSourceDQ("package test;", "import java.util.List;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source_1, "java.util.List", source_2, "List");
    }

    @Test
    public void test_ensureClassImport_5() throws Exception {
        String source_1 = AstEditorTest.getSourceDQ("package test;", "import java.util.Set;", "public class Test {", "  public Test() {", "  }", "}");
        String source_2 = AstEditorTest.getSourceDQ("package test;", "import java.util.Set;", "import java.util.List;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source_1, "java.util.List", source_2, "List");
    }

    @Test
    public void test_ensureClassImport_6() throws Exception {
        String source = AstEditorTest.getSourceDQ("package test;", "import java.util.List;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "java.awt.List", source, "java.awt.List");
    }

    @Test
    public void test_ensureClassImport_7() throws Exception {
        String source_1 = AstEditorTest.getSourceDQ("package test;", "import java.util.*;", "public class Test {", "  public Test() {", "  }", "}");
        String source_2 = AstEditorTest.getSourceDQ("package test;", "import java.util.*;", "import java.awt.List;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source_1, "java.awt.List", source_2, "List");
    }

    @Test
    public void test_ensureClassImport_8() throws Exception {
        String source = AstEditorTest.getSourceDQ("package test;", "import java.util.*;", "public class Test {", "  private List m_list;", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "java.awt.List", source, "java.awt.List");
    }

    @Test
    public void test_ensureClassImport_9() throws Exception {
        String source = AstEditorTest.getSourceDQ("package test;", "import java.util.*;", "public class Test {", "  private class A {};", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "test.Test.A", source, "A");
    }

    @Test
    public void test_ensureClassImport_10() throws Exception {
        AstEditorTest.setFileContentSrc("test/A.java", AstEditorTest.getSourceDQ("package test;", "public class A {", "}"));
        AstEditorTest.waitForAutoBuild();
        String source = AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "  }", "}");
        this.assert_ensureClassImport(source, "test.A", source, "A");
    }

    @Test
    public void test_ensureClassImport_11() throws Exception {
        this.createASTCompilationUnit("", "Test.java", AstEditorTest.getSourceDQ("public class Test {", "  public Test() {", "  }", "}"));
        this.m_lastEditor.ensureClassImport2("java.util.List");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("import java.util.List;", "public class Test {", "  public Test() {", "  }", "}"), this.m_lastEditor);
    }

    private void assert_ensureClassImport(String initialSource, String classToImport, String expectedSource, String expectedClassName) throws Exception {
        this.createASTCompilationUnit("test", "Test.java", initialSource);
        String actualClassName = this.m_lastEditor.ensureClassImport2(classToImport);
        AstEditorTest.assertEquals((Object)expectedClassName, (Object)actualClassName);
        AstEditorTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_ASTCG_getEndOfLine_0_default() throws Exception {
        this.createTypeDeclaration_TestC("private int m_value = 12345;");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertSame((Object)AstCodeGeneration.DEFAULT_END_OF_LINE, (Object)generation.getEndOfLine());
    }

    @Test
    public void test_ASTCG_getEndOfLine_1_r() throws Exception {
        this.createTypeDeclaration_TestC("private int m_value = 12345;\r");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertEquals((Object)"\r", (Object)generation.getEndOfLine());
    }

    @Test
    public void test_ASTCG_getEndOfLine_2_n() throws Exception {
        this.createTypeDeclaration_TestC("private int m_value = 12345;\n");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertEquals((Object)"\n", (Object)generation.getEndOfLine());
    }

    @Test
    public void test_ASTCG_getEndOfLine_3_rn() throws Exception {
        this.createTypeDeclaration_TestC("private int m_value = 12345;\r\n");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertEquals((Object)"\r\n", (Object)generation.getEndOfLine());
    }

    @Test
    public void test_ASTCG_getEndOfLine_4_nr() throws Exception {
        this.createTypeDeclaration_TestC("private int m_value = 12345;\n\r");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertEquals((Object)"\n", (Object)generation.getEndOfLine());
    }

    @Test
    public void test_ASTCG_getIndentation_0() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertSame((Object)"", (Object)generation.getIndentation(0));
    }

    @Test
    public void test_ASTCG_getIndentation_1_tab() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertEquals((Object)"\t", (Object)generation.getIndentation(1));
        AstEditorTest.assertEquals((Object)"\t\t", (Object)generation.getIndentation(2));
    }

    @Test
    public void test_ASTCG_getIndentation_2_space() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.formatter.tabulation.char", "space");
        javaProject.setOption("org.eclipse.jdt.core.formatter.tabulation.size", "4");
        try {
            AstEditorTest.assertSame((Object)"", (Object)generation.getIndentation(0));
            AstEditorTest.assertEquals((Object)StringUtils.repeat((String)" ", (int)4), (Object)generation.getIndentation(1));
            javaProject.setOption("org.eclipse.jdt.core.formatter.tabulation.size", "8");
            AstEditorTest.assertEquals((Object)StringUtils.repeat((String)" ", (int)8), (Object)generation.getIndentation(1));
            javaProject.setOption("org.eclipse.jdt.core.formatter.tabulation.size", "x");
            AstEditorTest.assertEquals((Object)StringUtils.repeat((String)" ", (int)4), (Object)generation.getIndentation(1));
        }
        finally {
            javaProject.setOption("org.eclipse.jdt.core.formatter.tabulation.char", "tab");
            javaProject.setOption("org.eclipse.jdt.core.formatter.tabulation.size", "1");
        }
    }

    @Test
    public void test_ASTCG_getUseCompactAssignment() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", "insert");
        AstEditorTest.assertEquals((Object)false, (Object)generation.getUseCompactAssignment());
        javaProject.setOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", "do not insert");
        AstEditorTest.assertEquals((Object)true, (Object)generation.getUseCompactAssignment());
    }

    @Test
    public void test_ASTCG_getMethodBraceSeparator() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstCodeGeneration generation = this.m_lastEditor.getGeneration();
        AstEditorTest.assertSame((Object)" ", (Object)generation.getMethodBraceSeparator("\t\t"));
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.formatter.brace_position_for_method_declaration", "next_line");
        if (EnvironmentUtils.IS_WINDOWS) {
            AstEditorTest.assertEquals((Object)"\r\n\t", (Object)generation.getMethodBraceSeparator("\t"));
            AstEditorTest.assertEquals((Object)"\r\n\t\t", (Object)generation.getMethodBraceSeparator("\t\t"));
        } else {
            AstEditorTest.assertEquals((Object)"\n\t", (Object)generation.getMethodBraceSeparator("\t"));
            AstEditorTest.assertEquals((Object)"\n\t\t", (Object)generation.getMethodBraceSeparator("\t\t"));
        }
    }

    @Test
    public void test_classAccess_addStatement_getClass() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("  public void foo() {", "    int marker;", "  }"));
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Statement statement = (Statement)methodDeclaration.getBody().statements().get(0);
        StatementTarget target = new StatementTarget(statement, false);
        this.m_lastEditor.addStatement("Class clazz = {wbp_class};", target);
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("  public void foo() {", "    int marker;", "    Class clazz = getClass();", "  }").trim(), (Object)this.m_lastEditor.getSource((ASTNode)methodDeclaration));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_classAccess_addStatement_TypeLiteral() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("  public static void foo() {", "    int marker;", "  }"));
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Statement statement = (Statement)methodDeclaration.getBody().statements().get(0);
        StatementTarget target = new StatementTarget(statement, false);
        this.m_lastEditor.addStatement("Class clazz = {wbp_class};", target);
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("  public static void foo() {", "    int marker;", "    Class clazz = Test.class;", "  }").trim(), (Object)this.m_lastEditor.getSource((ASTNode)methodDeclaration));
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_classAccess_replaceExpression_TypeLiteral() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(AstEditorTest.getSourceDQ("  public void foo() {", "    Class clazz = null;", "  }"));
        VariableDeclarationStatement statement = (VariableDeclarationStatement)typeDeclaration.getMethods()[0].getBody().statements().get(0);
        VariableDeclaration declaration = (VariableDeclaration)statement.fragments().get(0);
        Expression newExpression = this.m_lastEditor.replaceExpression(declaration.getInitializer(), "{wbp_class}");
        AstEditorTest.assertInstanceOf(MethodInvocation.class, (Object)newExpression);
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_classAccessTop() throws Exception {
        TypeDeclaration testType = this.createTypeDeclaration_Test("public class Test {\n\tpublic class Inner {\n\t\tpublic void foo() {\n\t\t}\n\t}\n}\n");
        TypeDeclaration innerType = testType.getTypes()[0];
        MethodDeclaration fooMethod = innerType.getMethods()[0];
        StatementTarget target = new StatementTarget(fooMethod.getBody(), false);
        this.m_lastEditor.addStatement("Class clazz = {wbp_classTop};", target);
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public class Inner {", "    public void foo() {", "      Class clazz = Test.class;", "    }", "  }", "}"), this.m_lastEditor);
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_setIdentifier() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler\nclass Test {\n\tprivate int m_value = 0;\n}\n");
        SimpleName fieldName = (SimpleName)this.m_lastEditor.getEnclosingNode("m_value");
        this.m_lastEditor.setIdentifier(fieldName, "foo");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "class Test {", "  private int foo = 0;", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ASTParser_invisibleType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate static class Inner {\n\t}\n\tprivate Inner m_inner;\n}");
        AstEditorTest.waitForAutoBuild();
        int position = typeDeclaration.getFields()[0].getStartPosition();
        this.m_lastEditor.getParser().parseExpression(position, "12345");
    }

    @Test
    public void test_ASTParser_unknownFieldType() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  NoSuchType m_field;", "  public Test() {", "    // marker", "  }", "}"));
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_unknownMethodType() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  public Test() {", "    // marker", "  }", "  private NoSuchType foo() {;", "    return null;", "  }", "}"));
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_1_parseField() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int a;");
        AstParser parser = this.m_lastEditor.getParser();
        int position = typeDeclaration.getFields()[0].getStartPosition();
        BodyDeclaration newField = parser.parseBodyDeclaration(position, "private int m_value;");
        AstEditorTest.assertEquals((int)position, (int)newField.getStartPosition());
    }

    @Test
    public void test_ASTParser_2_imports() throws Exception {
        ICompilationUnit modelUnit = this.createModelCompilationUnit("test", "Test.java", "import java.util.List; public class Test {int a;}");
        AstEditor editor = new AstEditor(modelUnit);
        TypeDeclaration typeDeclaration = (TypeDeclaration)editor.getAstUnit().types().get(0);
        AstParser parser = editor.getParser();
        int position = typeDeclaration.getFields()[0].getStartPosition();
        BodyDeclaration newField = parser.parseBodyDeclaration(position, "private List m_values;");
        AstEditorTest.assertNotNull((Object)newField);
    }

    @Test
    public void test_ASTParser_3_getMethodBinding() throws Exception {
        ICompilationUnit modelUnit = this.createModelCompilationUnit("test", "Test.java", "import java.util.*; public class Test {int a;}");
        AstEditor editor = new AstEditor(modelUnit);
        TypeDeclaration typeDeclaration = (TypeDeclaration)editor.getAstUnit().types().get(0);
        AstParser parser = editor.getParser();
        int position = typeDeclaration.getFields()[0].getStartPosition();
        FieldDeclaration newField = (FieldDeclaration)parser.parseBodyDeclaration(position, "private List m_values = Collections.singletonList(null);");
        AstEditorTest.assertNotNull((Object)newField);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)newField.fragments().get(0);
        MethodInvocation invocation = (MethodInvocation)fragment.getInitializer();
        AstEditorTest.assertNull((Object)invocation.resolveMethodBinding());
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        AstEditorTest.assertNotNull((Object)methodBinding);
        AstEditorTest.assertEquals((Object)"singletonList(java.lang.Object)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)methodBinding));
    }

    @Test
    public void test_ASTParser_FieldAccess() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate int m_value;\n\tpublic Test() {\n\t}\n}");
        MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"<init>()");
        StatementTarget statementTarget = new StatementTarget(methodDeclaration, true);
        ExpressionStatement statement = (ExpressionStatement)this.m_lastEditor.addStatement("this.m_value = 0;", statementTarget);
        Assignment assignment = (Assignment)statement.getExpression();
        FieldAccess fieldAccess = (FieldAccess)assignment.getLeftHandSide();
        AstEditorTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)fieldAccess));
        AstEditorTest.assertEquals((Object)fieldAccess.getName(), (Object)AstNodeUtils.getVariableSimpleName((ASTNode)fieldAccess));
        AstEditorTest.assertEquals((Object)"m_value", (Object)AstNodeUtils.getVariableName((ASTNode)fieldAccess));
    }

    @Test
    public void test_ASTParser_SingleVariableDeclaration_IVariableBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tint field;\n}");
        int position = typeDeclaration.getFields()[0].getStartPosition();
        MethodDeclaration method = (MethodDeclaration)this.m_lastEditor.getParser().parseBodyDeclaration(position, "void foo(int a, String b) {}");
        List parameters = DomGenerics.parameters((MethodDeclaration)method);
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(0);
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)parameter);
        AstEditorTest.assertNotNull((Object)variableBinding);
        AstEditorTest.assertEquals((Object)"a", (Object)variableBinding.getName());
        parameter = (SingleVariableDeclaration)parameters.get(1);
        variableBinding = AstNodeUtils.getVariableBinding((ASTNode)parameter);
        AstEditorTest.assertNotNull((Object)variableBinding);
        AstEditorTest.assertEquals((Object)"b", (Object)variableBinding.getName());
    }

    @Test
    public void test_ASTParser_parseSimpleName() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstParser parser = this.m_lastEditor.getParser();
        SimpleName simpleName = parser.parseSimpleName(10, "abc");
        this.check_SimpleName(simpleName, "abc", 10, 3);
    }

    @Test
    public void test_ASTParser_parseQualifiedName() throws Exception {
        this.createTypeDeclaration_TestC("");
        AstParser parser = this.m_lastEditor.getParser();
        QualifiedName qualifiedName = parser.parseQualifiedName(10, "a.b.c");
        AstEditorTest.assertEquals((int)10, (int)qualifiedName.getStartPosition());
        AstEditorTest.assertEquals((int)5, (int)qualifiedName.getLength());
        this.check_SimpleName(qualifiedName.getName(), "c", 14, 1);
        qualifiedName = (QualifiedName)qualifiedName.getQualifier();
        this.check_SimpleName(qualifiedName.getName(), "b", 12, 1);
        this.check_SimpleName((SimpleName)qualifiedName.getQualifier(), "a", 10, 1);
    }

    private void check_SimpleName(SimpleName simpleName, String identifier, int position, int length) {
        AstEditorTest.assertEquals((Object)identifier, (Object)simpleName.getIdentifier());
        AstEditorTest.assertEquals((int)position, (int)simpleName.getStartPosition());
        AstEditorTest.assertEquals((int)length, (int)simpleName.getLength());
    }

    @Test
    public void test_ASTParser_parseType_1() throws Exception {
        this.check_ASTParser_parseType("String m_value;");
    }

    @Test
    public void test_ASTParser_parseType_2() throws Exception {
        this.check_ASTParser_parseType("java.util.List m_value;");
    }

    @Test
    public void test_ASTParser_parseType_3() throws Exception {
        this.check_ASTParser_parseType("int m_value;");
    }

    private void check_ASTParser_parseType(String code) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        Type sourceType = typeDeclaration.getFields()[0].getType();
        Type newType = this.m_lastEditor.getParser().parseType(10, sourceType);
        AstEditorTest.assertEquals((Object)sourceType.toString(), (Object)newType.toString());
        AstEditorTest.assertEquals((int)10, (int)newType.getStartPosition());
        AstEditorTest.assertEquals((int)sourceType.toString().length(), (int)newType.getLength());
        ITypeBinding sourceBinding = AstNodeUtils.getTypeBinding((Type)sourceType);
        ITypeBinding newBinding = AstNodeUtils.getTypeBinding((Type)newType);
        AstEditorTest.assertNotNull((Object)newBinding);
        AstEditorTest.assertEquals((Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)sourceBinding, (boolean)false), (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)newBinding, (boolean)false));
    }

    @Test
    public void test_ASTParser_parseVariable() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("String m_value;");
        ITypeBinding sourceTypeBinding = typeDeclaration.getFields()[0].getType().resolveBinding();
        SimpleName variable = this.m_lastEditor.getParser().parseVariable(10, "abc", null, sourceTypeBinding, false, 16);
        AstEditorTest.assertEquals((Object)"abc", (Object)variable.getIdentifier());
        AstEditorTest.assertEquals((int)10, (int)variable.getStartPosition());
        AstEditorTest.assertEquals((int)3, (int)variable.getLength());
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)variable);
        AstEditorTest.assertNotNull((Object)variableBinding);
        AstEditorTest.assertEquals((Object)"abc", (Object)variableBinding.getName());
        AstEditorTest.assertFalse((boolean)variableBinding.isField());
        AstEditorTest.assertEquals((int)16, (int)variableBinding.getModifiers());
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Expression)variable);
        AstEditorTest.assertNotNull((Object)typeBinding);
        AstEditorTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false));
    }

    @Test
    public void test_ASTParser_parseSimpleType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("String m_value;");
        ITypeBinding sourceTypeBinding = typeDeclaration.getFields()[0].getType().resolveBinding();
        SimpleType type = this.m_lastEditor.getParser().parseSimpleType(10, "String", sourceTypeBinding);
        AstEditorTest.assertEquals((int)10, (int)type.getStartPosition());
        AstEditorTest.assertEquals((int)6, (int)type.getLength());
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Type)type);
        AstEditorTest.assertNotNull((Object)typeBinding);
        AstEditorTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false));
    }

    @Test
    public void test_ASTParser_parseQualifiedType_onlyString() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "}"));
        int position = this.getNode("Test {").getStartPosition();
        AstParser parser = this.m_lastEditor.getParser();
        Type newType = parser.parseQualifiedType(position, "java.lang.String");
        AstEditorTest.assertEquals((int)position, (int)newType.getStartPosition());
        AstEditorTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((Type)newType, (boolean)false));
        newType = parser.parseQualifiedType(position, "java.util.List<java.lang.String>");
        AstEditorTest.assertEquals((int)position, (int)newType.getStartPosition());
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Type)newType);
        AstEditorTest.assertEquals((Object)"java.util.List", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false));
        AstEditorTest.assertEquals((Object)"java.util.List<java.lang.String>", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false, (boolean)true));
    }

    @Test
    public void test_ASTParser_parseExpression_MethodInvocation() throws Exception {
        this.check_ASTParser_parseExpression("System.out.println()");
    }

    @Test
    public void test_ASTParser_parseExpression_NumberLiteral() throws Exception {
        this.check_ASTParser_parseExpression("12345");
    }

    @Test
    public void test_ASTParser_parseExpression_NullLiteral() throws Exception {
        this.check_ASTParser_parseExpression("null");
    }

    @Test
    public void test_ASTParser_parseExpression_NoSuperDefaultConstructor() throws Exception {
        AstEditorTest.setFileContentSrc("test/ComplexPanel.java", AstEditorTest.getSourceDQ("package test;", "public class ComplexPanel {", "  public ComplexPanel(String text, int alignment) {", "  }", "}"));
        AstEditorTest.waitForAutoBuild();
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSourceDQ("package test;", "public class Test extends ComplexPanel {", "  public Test() {", "    super(null, 0);", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        int position = typeDeclaration.getStartPosition();
        Expression expression = this.m_lastEditor.getParser().parseExpression(position, "123");
        AstEditorTest.assertNotNull((Object)expression);
    }

    @Test
    public void test_ASTParser_parseExpression_referenceLocalFieldDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate static final int ID = 555;\n\tpublic Test() {\n\t}\n}");
        int position = typeDeclaration.getStartPosition();
        SimpleName simpleName = (SimpleName)this.m_lastEditor.getParser().parseExpression(position, "ID");
        AstEditorTest.assertNotNull((Object)simpleName);
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)simpleName);
        AstEditorTest.assertNotNull((Object)variableBinding);
        AstEditorTest.assertNotNull((Object)variableBinding.getDeclaringClass());
        AstEditorTest.assertEquals((Object)"test.Test", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)variableBinding.getDeclaringClass(), (boolean)false));
    }

    @Test
    public void test_ASTParser_parseExpression_referenceLocalStaticMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test {\n\tpublic Test() {\n\t}\n\tprivate static JButton createButton() {\n\t\treturn new JButton();\n\t}\n}");
        int position = typeDeclaration.getStartPosition();
        Expression expression = this.m_lastEditor.getParser().parseExpression(position, "test.Test.createButton()");
        AstEditorTest.assertNotNull((Object)expression);
    }

    @Test
    public void test_ASTParser_parseExpression_innerType() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSourceDQ("package test;", "public class Test {", "  private class Inner extends java.util.ArrayList implements java.util.List, java.io.Serializable {}", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        int position = typeDeclaration.getStartPosition();
        Expression expression = this.m_lastEditor.getParser().parseExpression(position, "new Inner()");
        AstEditorTest.assertNotNull((Object)expression);
    }

    @Test
    public void test_ASTParser_parseExpression_SuperMethodInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\npublic class Test {\n}");
        int position = typeDeclaration.getStartPosition();
        SuperMethodInvocation invocation = (SuperMethodInvocation)this.m_lastEditor.getParser().parseExpression(position, "super.toString()");
        AstEditorTest.assertNotNull((Object)invocation);
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((SuperMethodInvocation)invocation);
        AstEditorTest.assertEquals((Object)"toString()", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)methodBinding));
    }

    @Test
    public void test_ASTParser_parseExpression_anonymous() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstEditorTest.getSourceDQ("package test;", "public class Test {", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        int position = typeDeclaration.getStartPosition();
        ClassInstanceCreation creation = (ClassInstanceCreation)this.m_lastEditor.getParser().parseExpression(position, AstEditorTest.getSourceDQ("new java.awt.event.KeyAdapter() {", "  public void keyTyped(java.awt.event.KeyEvent e) {", "  }", "}"));
        AnonymousClassDeclaration anonymousClassDeclaration = creation.getAnonymousClassDeclaration();
        AstEditorTest.assertNotNull((Object)anonymousClassDeclaration);
        TypeDeclaration anonymousTypeDeclaration = AnonymousTypeDeclaration.create((AnonymousClassDeclaration)anonymousClassDeclaration);
        ITypeBinding binding = AstNodeUtils.getTypeBinding((TypeDeclaration)anonymousTypeDeclaration);
        AstEditorTest.assertEquals((Object)"java.awt.event.KeyAdapter", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding.getSuperclass(), (boolean)false));
    }

    @Test
    public void test_ASTParser_parseExpression_notInitializedFinalField() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate final int m_finalField_0;\n\tprivate final Object m_finalField_1;\n\tpublic Test() {\n\t\tm_finalField_0 = 123;\n\t\tm_finalField_1 = new Object();\n\t}\n}");
        int position = typeDeclaration.getStartPosition();
        String expressionSource = "1 + 2";
        this.check_ASTParser_parseExpression(position, expressionSource);
    }

    @Test
    public void test_ASTParser_parseExpression_publicStaticFinalField_inInnerClass() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate class Inner {\n\t\tprivate static final int CONS = 555;\n\t}\n\tpublic Test() {\n\t\t// marker\n\t}\n}");
        int position = typeDeclaration.getStartPosition();
        String expressionSource = "Inner.CONS";
        this.check_ASTParser_parseExpression(position, expressionSource);
    }

    @Test
    public void test_ASTParser_parseExpression_classSystem() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate class System {\n\t}\n\tpublic Test() {\n\t\t// marker\n\t}\n}");
        int position = typeDeclaration.getStartPosition();
        String expressionSource = "123";
        this.check_ASTParser_parseExpression(position, expressionSource);
    }

    @Test
    public void test_ASTParser_parseExpression_warning_nullReference() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tObject var = new Object();\n\t\t// marker\n\t}\n}");
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        try {
            int position = this.m_lastEditor.indexOf("// marker");
            String expressionSource = "var.hashCode()";
            this.check_ASTParser_parseExpression(position, expressionSource);
        }
        finally {
            AstEditorTest.do_projectDispose();
        }
    }

    @Test
    public void test_ASTParser_parseExpression_warning_unusedImport() throws Exception {
        this.createTypeDeclaration_Test("import java.util.List;\npublic class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n}");
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        try {
            int position = this.m_lastEditor.indexOf("// marker");
            String expressionSource = "12345";
            this.check_ASTParser_parseExpression(position, expressionSource);
        }
        finally {
            AstEditorTest.do_projectDispose();
        }
    }

    @Test
    public void test_ASTParser_parseExpression_warning_useOverride() throws Exception {
        AstEditorTest.setFileContentSrc("test/Test_0.java", AstEditorTest.getSource("package test;", "public class Test_0 {", "  public void fooBar() {", "  }", "}"));
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test extends Test_0 {", "  @Override", "  public void fooBar() {", "    // marker", "  }", "}"));
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        try {
            int position = this.m_lastEditor.indexOf("// marker");
            String expressionSource = "12345";
            this.check_ASTParser_parseExpression(position, expressionSource);
        }
        finally {
            AstEditorTest.do_projectDispose();
        }
    }

    @Test
    public void test_ASTParser_parseExpression_warning_unnecessaryCast() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tObject var;\n\t\t// marker\n\t}\n}");
        IJavaProject javaProject = this.m_lastEditor.getModelUnit().getJavaProject();
        javaProject.setOption("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        try {
            int position = this.m_lastEditor.indexOf("// marker");
            String expressionSource = "var = (java.lang.Object) null";
            this.check_ASTParser_parseExpression(position, expressionSource);
        }
        finally {
            AstEditorTest.do_projectDispose();
        }
    }

    @Test
    public void test_ASTParser_parseExpression_severalVariableDeclarationFragments_inFieldDeclaration() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tprivate int a, b;\n\tpublic Test() {\n\t\t// marker\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_generics() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tprivate static class Inner implements Comparable<Inner> {\n\t\tpublic int compareTo(Inner o) {\n\t\t\treturn 0;\n\t\t}\n\t}\n\tpublic Test() {\n\t\t// marker\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_generics2() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\t<T> void foo(T o) {\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_annotations() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\t@SuppressWarnings(\"unchecked\")\n\tvoid foo() {\n\t}\n}\n");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_innerClass_requiredConstructor() throws Exception {
        AstEditorTest.setFileContentSrc("test/MySuper.java", AstEditorTest.getSource("package test;", "public class MySuper {", "  public MySuper(int value) {", "  }", "}"));
        AstEditorTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\tpublic class MyClass extends MySuper {\n\t\tpublic MyClass() {\n\t\t\tthis(0);\n\t\t}\n\t\tpublic MyClass(int val) {\n\t\t\tsuper(val);\n\t\t}\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_innerClass_noSuperConstructor() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\tpublic class MyClass {\n\t\tpublic MyClass(byte val) {\n\t\t}\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_innerAbstractClass_abstractMethod() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\tpublic abstract class AbstractClass {\n\t\tpublic abstract void foo();\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_innerInterface_abstractMethod() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\tpublic interface MyInterface {\n\t\tvoid foo();\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_innerClass_noModifierConstructor() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\tpublic class MyClass {\n\t\tMyClass(int val) {\n\t\t}\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_innerClass_privateModifier() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tMyClass o = new MyClass();\n\t\t// marker\n\t}\n\tpublic class MyClass {\n\t\tpublic void setVisible(boolean visible) {\n\t\t}\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "o.setVisible(false)");
    }

    @Test
    public void test_ASTParser_parseExpression_innerInterface_shouldBeInterface() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic interface MyInterface {\n\t\tpublic abstract void foo();\n\t}\n\tpublic Test() {\n\t\t// marker\n\t}\n}\n");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_skipJavaDoc() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\t/**\n\t * Some text with {} and ().\n\t */\n\tpublic void foo() {\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_skipComment() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\t/**\n\t * Some JavaDoc.\n\t */\n\t/*\n\t * Some comment with {} and ().\n\t */\n\tpublic void foo() {\n\t}\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    @Test
    public void test_ASTParser_parseExpression_nativeMethod() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\t// marker\n\t}\n\tnative void someNativeMethod();\n}");
        int position = this.m_lastEditor.indexOf("// marker");
        this.check_ASTParser_parseExpression(position, "123");
    }

    private void check_ASTParser_parseExpression(String expressionSource) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("");
        int position = typeDeclaration.getStartPosition();
        this.check_ASTParser_parseExpression(position, expressionSource);
    }

    private void check_ASTParser_parseExpression(int position, String expressionSource) throws Exception {
        Expression expression = this.m_lastEditor.getParser().parseExpression(position, expressionSource);
        AstEditorTest.assertNotNull((Object)expression);
        AstEditorTest.assertEquals((int)position, (int)expression.getStartPosition());
        AstEditorTest.assertEquals((int)expressionSource.length(), (int)expression.getLength());
    }

    @Test
    public void test_replaceExpression() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tObject m_value = new Object();\n}\n");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
        Expression newExpression = this.m_lastEditor.replaceExpression(fragment.getInitializer(), "new java.util.ArrayList()");
        AstEditorTest.assertSame((Object)newExpression, (Object)fragment.getInitializer());
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "import java.util.ArrayList;", "// filler filler filler", "public class Test {", "  Object m_value = new ArrayList();", "}"), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_replaceExpression_noImports() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tObject m_value = new Object();\n}\n");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
        this.m_lastEditor.setResolveImports(false);
        Expression newExpression = this.m_lastEditor.replaceExpression(fragment.getInitializer(), "new java.util.ArrayList()");
        AstEditorTest.assertSame((Object)newExpression, (Object)fragment.getInitializer());
        AstEditorTest.assertEquals((Object)AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "public class Test {", "  Object m_value = new java.util.ArrayList();", "}"), (Object)this.m_lastEditor.getSource());
        AstEditorTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_replaceExpression_lines() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tObject m_value = new Object();\n}\n");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
        this.m_lastEditor.setResolveImports(false);
        Expression newExpression = this.m_lastEditor.replaceExpression(fragment.getInitializer(), List.of("new", "\tjava.util.ArrayList()"));
        AstEditorTest.assertSame((Object)newExpression, (Object)fragment.getInitializer());
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "public class Test {", "  Object m_value = new", "    java.util.ArrayList();", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceExpression_linesInSingle() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tObject m_value = new Object();\n}\n");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
        this.m_lastEditor.setResolveImports(false);
        Expression newExpression = this.m_lastEditor.replaceExpression(fragment.getInitializer(), "new\n\tjava.util.ArrayList()");
        AstEditorTest.assertSame((Object)newExpression, (Object)fragment.getInitializer());
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "public class Test {", "  Object m_value = new", "    java.util.ArrayList();", "}"), this.m_lastEditor);
    }

    @Test
    public void test_resolveImports() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tObject m_value = new Object();\n}\n");
        Expression expression = (Expression)this.getNode("new Object()");
        this.m_lastEditor.replaceExpression(expression, "new java.util.ArrayList((new java.lang.Integer[]{}).length)");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import java.util.ArrayList;", "// filler filler filler", "public class Test {", "  Object m_value = new ArrayList((new Integer[]{}).length);", "}"), this.m_lastEditor);
    }

    @Test
    public void test_resolveImports_typeInSameFile() throws Exception {
        AstEditorTest.setFileContentSrc("other/pkg/Test.java", AstEditorTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package other.pkg;", "public class Test {", "}"));
        this.createTypeDeclaration_Test("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test {\n\tObject value = new Object();\n}\n");
        Expression expression = (Expression)this.getNode("new Object()");
        this.m_lastEditor.replaceExpression(expression, "new other.pkg.Test()");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  Object value = new other.pkg.Test();", "}"), this.m_lastEditor);
    }

    @Test
    public void test_resolveImports_forInnerClass() throws Exception {
        AstEditorTest.setFileContentSrc("test2/Style.java", AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "public class Style {", "  public enum Orientation {HORIZONTAL, VERTICAL};", "}"));
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  Object m_value = new Object();", "}"));
        Expression expression = (Expression)this.getNode("new Object()");
        this.m_lastEditor.replaceExpression(expression, List.of("test2.Style.Orientation.HORIZONTAL"));
        AstEditorTest.assertEditor(AstEditorTest.getSource("// filler filler filler filler filler", "package test;", "import test2.Style.Orientation;", "public class Test {", "  Object m_value = Orientation.HORIZONTAL;", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceInvocationArgument() throws Exception {
        this.createTypeDeclaration("test", "Test.java", AstEditorTest.getSource("package test;", "public class Test {", "  void foo() {", "    bar(1, 2);", "  }", "  void bar(int a, int b) {", "  }", "}"));
        MethodInvocation invocation = this.getNode("bar(1, 2)", MethodInvocation.class);
        this.m_lastEditor.replaceInvocationArgument(invocation, 1, "20");
        AstEditorTest.assertEditor(AstEditorTest.getSource("package test;", "public class Test {", "  void foo() {", "    bar(1, 20);", "  }", "  void bar(int a, int b) {", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceVariableType_VariableDeclarationStatement() throws Exception {
        this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test {\n\tpublic Test() {\n\t\tJButton button = null;\n\t}\n}\n");
        VariableDeclaration variableDeclaration = this.getNode("button", VariableDeclaration.class);
        this.m_lastEditor.replaceVariableType(variableDeclaration, "javax.swing.JTextField");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "public class Test {", "  public Test() {", "    JTextField button = null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceVariableType_FieldDeclaration() throws Exception {
        this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test {\n\tprivate JButton button;\n}\n");
        VariableDeclaration variableDeclaration = this.getNode("button", VariableDeclaration.class);
        this.m_lastEditor.replaceVariableType(variableDeclaration, "javax.swing.JTextField");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "import javax.swing.*;", "public class Test {", "  private JTextField button;", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceVariableType_unknown() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler\nimport javax.swing.*;\npublic class Test {\n}");
        VariableDeclaration variableDeclaration = (VariableDeclaration)Mockito.mock(VariableDeclaration.class);
        try {
            this.m_lastEditor.replaceVariableType(variableDeclaration, "javax.swing.JTextField");
            AstEditorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getStringLiteralNumberOnLine() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tString m_string_1 = \"1\" + \"2\" +\n\t\t\"3\";\n}");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
        InfixExpression infixExpression = (InfixExpression)fragment.getInitializer();
        AstEditorTest.assertEquals((int)0, (int)this.m_lastEditor.getStringLiteralNumberOnLine((StringLiteral)infixExpression.getLeftOperand()));
        AstEditorTest.assertEquals((int)1, (int)this.m_lastEditor.getStringLiteralNumberOnLine((StringLiteral)infixExpression.getRightOperand()));
        AstEditorTest.assertEquals((int)0, (int)this.m_lastEditor.getStringLiteralNumberOnLine((StringLiteral)infixExpression.extendedOperands().get(0)));
    }

    @Test
    public void test_addEndOfLineComment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tint m_value;\n}\n");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        this.m_lastEditor.addEndOfLineComment(field.getStartPosition(), " // Hello!");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "// filler filler filler", "public class Test {", "  int m_value; // Hello!", "}"), this.m_lastEditor);
    }

    @Test
    public void test_getEndOfLineComment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test {\n\tint m_value; // 111\n\tint m_value2;\n}");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        int position = AstNodeUtils.getSourceBegin((ASTNode)field);
        AstEditorTest.assertEquals((Object)"// 111", (Object)this.m_lastEditor.getEndOfLineComment(position));
        field = typeDeclaration.getFields()[1];
        position = AstNodeUtils.getSourceBegin((ASTNode)field);
        AstEditorTest.assertEquals(null, (Object)this.m_lastEditor.getEndOfLineComment(position));
        try {
            this.m_lastEditor.getChar(-1);
            AstEditorTest.fail();
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(BadLocationException.class);
        }
    }

    @Test
    public void test_removeEndOfLineComment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tint m_value; // 111   // 222  \n\tint m_value2; // 333\n}\n");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        this.m_lastEditor.removeEndOfLineComment(field.getStartPosition(), "// 333");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  int m_value; // 111   // 222  ", "  int m_value2; // 333", "}"), this.m_lastEditor);
        this.m_lastEditor.removeEndOfLineComment(field.getStartPosition(), "// 111");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  int m_value; // 222  ", "  int m_value2; // 333", "}"), this.m_lastEditor);
        this.m_lastEditor.removeEndOfLineComment(field.getStartPosition(), "// 222");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  int m_value;", "  int m_value2; // 333", "}"), this.m_lastEditor);
    }

    @Test
    public void test_replaceNode() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value = Math.abs(-1);");
        FieldDeclaration field = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
        MethodInvocation invocation = (MethodInvocation)fragment.getInitializer();
        SimpleName newSimpleName = invocation.getAST().newSimpleName("foo");
        AstEditor.replaceNode((ASTNode)invocation.getName(), (ASTNode)newSimpleName);
        AstEditorTest.assertSame((Object)newSimpleName, (Object)invocation.getName());
        newSimpleName = invocation.getAST().newSimpleName("X");
        AstEditor.replaceNode((ASTNode)((ASTNode)invocation.arguments().get(0)), (ASTNode)newSimpleName);
        AstEditorTest.assertSame((Object)newSimpleName, invocation.arguments().get(0));
    }

    @Test
    public void test_replaceNode_QualifiedName_into_FieldAccess() throws Exception {
        AstEditorTest.setFileContentSrc("test/MyObject.java", AstEditorTest.getSourceDQ("package test;", "public class MyObject {", "  public int m_value;", "}"));
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tMyObject foo = new MyObject();\n\t\tfoo.m_value = 1;\n\t}\n}\n");
        int fooIndex = this.m_lastEditor.getSource().indexOf("foo.");
        Expression fooNode = (Expression)this.m_lastEditor.getEnclosingNode(fooIndex);
        this.m_lastEditor.replaceExpression(fooNode, "new test.MyObject()");
        AstEditorTest.assertEditor(AstEditorTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    MyObject foo = new MyObject();", "    new MyObject().m_value = 1;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_getTypeArgumentsSource() throws Exception {
        this.createTypeDeclaration_Test("import java.util.*;\npublic class Test {\n\tvoid foo() {\n\t\tnew Object();\n\t\tnew ArrayList<Integer>();\n\t\tnew HashMap<String, Double>();\n\t\tnew LinkedList<Short>() {};\n\t}\n}");
        this.check_getTypeArgumentsSource("new Object", "");
        this.check_getTypeArgumentsSource("new ArrayList", "<java.lang.Integer>");
        this.check_getTypeArgumentsSource("new HashMap", "<java.lang.String, java.lang.Double>");
        this.check_getTypeArgumentsSource("new LinkedList", "<java.lang.Short>");
    }

    private void check_getTypeArgumentsSource(String src, String expected) {
        ClassInstanceCreation creation = this.getNode(src, ClassInstanceCreation.class);
        AstEditorTest.assertEquals((Object)expected, (Object)this.m_lastEditor.getTypeArgumentsSource(creation));
    }

    @Test
    public void test_getMethodStubSource() throws Exception {
        this.createTypeDeclaration_Test("import java.util.*;\npublic class Test {\n\tvoid methodA() {\n\t}\n\tpublic String methodB(int a, String b, Double c) {\n\t\treturn \"b\";\n\t}\n\tpublic static final int methodC() {\n\t\treturn 42;\n\t}\n}");
        MethodDeclaration method = this.getNode("methodA", MethodDeclaration.class);
        AstEditorTest.assertEquals((Object)"\tvoid methodA() {\n\t}", (Object)this.m_lastEditor.getMethodStubSource(method));
        method = this.getNode("methodB", MethodDeclaration.class);
        AstEditorTest.assertEquals((Object)"\tpublic java.lang.String methodB(int a, java.lang.String b, java.lang.Double c) {\n\t\treturn (java.lang.String) null;\n\t}", (Object)this.m_lastEditor.getMethodStubSource(method));
        method = this.getNode("methodC", MethodDeclaration.class);
        AstEditorTest.assertEquals((Object)"\tpublic static final int methodC() {\n\t\treturn 0;\n\t}", (Object)this.m_lastEditor.getMethodStubSource(method));
    }
}

