/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.draw2d.TestCaseRootFigure;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FigurePaintingTest
extends Draw2dFigureTestCase {
    private TestLogger m_actualLogger;
    private TestCaseRootFigure m_root;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_actualLogger = new TestLogger();
        this.m_root = new TestCaseRootFigure(this.m_actualLogger);
    }

    private Figure addFigure() {
        Figure figure = new Figure();
        this.m_root.add((IFigure)figure);
        this.m_actualLogger.clear();
        return figure;
    }

    private Figure addFigure(int x, int y, int width, int height) {
        Figure figure = new Figure();
        figure.setBounds(new Rectangle(x, y, width, height));
        figure.setLayoutManager((LayoutManager)new XYLayout());
        this.m_root.add((IFigure)figure);
        this.m_actualLogger.clear();
        return figure;
    }

    @Test
    public void test_repaint() throws Exception {
        Figure testFigure = this.addFigure(10, 11, 50, 78);
        TestLogger expectedLogger = new TestLogger();
        testFigure.repaint();
        expectedLogger.log("repaint(10, 11, 50, 78)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setVisible(false);
        this.m_actualLogger.clear();
        testFigure.repaint();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_add() throws Exception {
        Figure testFigure = this.addFigure(10, 11, 50, 78);
        TestLogger expectedLogger = new TestLogger();
        testFigure.add((IFigure)new Figure());
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        Figure testChildFigure = new Figure();
        testChildFigure.setBounds(new Rectangle(1, 2, 3, 4));
        testFigure.add((IFigure)testChildFigure);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(1, 2, 3, 4)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.add((IFigure)new Figure(), (Object)new Rectangle(1, 2, 3, 4));
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.getLayoutManager().layout((IFigure)testFigure);
        expectedLogger.log("repaint(10, 11, 0, 0)");
        expectedLogger.log("repaint(1, 2, 3, 4)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.add((IFigure)new Figure(), (Object)new Rectangle(1, 2, 3, 4), -1);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.getLayoutManager().layout((IFigure)testFigure);
        expectedLogger.log("repaint(10, 11, 0, 0)");
        expectedLogger.log("repaint(1, 2, 3, 4)");
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_remove() throws Exception {
        Figure testFigure = this.addFigure(10, 11, 50, 78);
        TestLogger expectedLogger = new TestLogger();
        Figure testChildFigure = new Figure();
        testFigure.add((IFigure)testChildFigure, (Object)new Rectangle(21, 17, 25, 24));
        testFigure.add((IFigure)new Figure());
        testFigure.getLayoutManager().layout((IFigure)testFigure);
        this.m_actualLogger.clear();
        testFigure.remove((IFigure)testChildFigure);
        expectedLogger.log("repaint(31, 28, 25, 24)");
        expectedLogger.log("invalidate");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.removeAll();
        expectedLogger.log("repaint(10, 11, 0, 0)");
        expectedLogger.log("invalidate");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.removeAll();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_bounds() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setBounds(new Rectangle(1, 2, 3, 4));
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("repaint(1, 2, 3, 4)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBounds(new Rectangle(1, 2, 3, 4));
        this.m_actualLogger.assertEmpty();
        testFigure.setSize(3, 4);
        this.m_actualLogger.assertEmpty();
        testFigure.setSize(1, 5);
        expectedLogger.log("repaint(1, 2, 3, 4)");
        expectedLogger.log("repaint(1, 2, 1, 5)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setSize(new Dimension(11, 12));
        expectedLogger.log("repaint(1, 2, 1, 5)");
        expectedLogger.log("repaint(1, 2, 11, 12)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setSize(new Dimension(11, 12));
        this.m_actualLogger.assertEmpty();
        testFigure.setLocation(new Point(1, 2));
        this.m_actualLogger.assertEmpty();
        testFigure.setLocation(new Point(3, 7));
        expectedLogger.log("repaint(1, 2, 11, 12)");
        expectedLogger.log("repaint(3, 7, 11, 12)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setLocation(new Point());
        expectedLogger.log("repaint(3, 7, 11, 12)");
        expectedLogger.log("repaint(0, 0, 11, 12)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setLocation(new Point());
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_border() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        LineBorder border = new LineBorder();
        testFigure.setBorder((Border)border);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBorder((Border)border);
        this.m_actualLogger.assertEmpty();
        testFigure.setBorder((Border)new LineBorder(7));
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBorder(null);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBorder(null);
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_background() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setBackgroundColor(red);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBackgroundColor(red);
        this.m_actualLogger.assertEmpty();
        testFigure.setBackgroundColor(green);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBackgroundColor(null);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setBackgroundColor(null);
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_foreground() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setForegroundColor(red);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setForegroundColor(red);
        this.m_actualLogger.assertEmpty();
        testFigure.setForegroundColor(green);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setForegroundColor(null);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setForegroundColor(null);
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_font() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setFont(new Font(null, "Courier New", 12, 1));
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setFont(Display.getCurrent().getSystemFont());
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setFont(Display.getCurrent().getSystemFont());
        this.m_actualLogger.assertEmpty();
        testFigure.setFont(null);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setFont(null);
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_cursor() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setCursor(Cursors.HELP);
        expectedLogger.log("updateCursor");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setCursor(Cursors.CROSS);
        expectedLogger.log("updateCursor");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setCursor(Cursors.CROSS);
        this.m_actualLogger.assertEmpty();
        testFigure.setCursor(null);
        expectedLogger.log("updateCursor");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setCursor(null);
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_opaque() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setOpaque(true);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setOpaque(true);
        this.m_actualLogger.assertEmpty();
        testFigure.setOpaque(false);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setOpaque(false);
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_visible() throws Exception {
        Figure testFigure = this.addFigure();
        TestLogger expectedLogger = new TestLogger();
        testFigure.setVisible(false);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("invalidate");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setVisible(false);
        this.m_actualLogger.assertEmpty();
        testFigure.setVisible(true);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("invalidate");
        this.m_actualLogger.assertEquals(expectedLogger);
        testFigure.setVisible(true);
        this.m_actualLogger.assertEmpty();
    }
}

