/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class LiveComponentsManagerTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_liveImage_noSourceChange() throws Exception {
        this.parseSource("test", "Test.java", LiveComponentsManagerTest.getSourceDQ("package test;", "import org.eclipse.swt.widgets.Shell;", "public class Test extends Shell {", "  public Test() {", "  }", "}"));
        String originalSource = this.m_lastEditor.getSource();
        ControlInfo button = BTestUtils.createButton();
        Image image = button.getImage();
        LiveComponentsManagerTest.assertNotNull((Object)image);
        LiveComponentsManagerTest.assertEquals((Object)originalSource, (Object)this.m_lastEditor.getSource());
        LiveComponentsManagerTest.assertEquals((Object)originalSource, (Object)this.m_lastEditor.getModelUnit().getSource());
        LiveComponentsManagerTest.assertTrue((boolean)this.m_lastEditor.getModelUnit().isConsistent());
        Dimension preferredSize = button.getPreferredSize();
        LiveComponentsManagerTest.assertNotNull((Object)preferredSize);
    }

    @Test
    public void test_liveImage_onShell() throws Exception {
        this.parseComposite("// filler filler filler", "class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlInfo button_1 = BTestUtils.createButton();
        ControlInfo button_2 = BTestUtils.createButton();
        Image image_1 = button_1.getImage();
        LiveComponentsManagerTest.assertNotNull((Object)image_1);
        Dimension preferredSize_1 = button_1.getPreferredSize();
        LiveComponentsManagerTest.assertNotNull((Object)preferredSize_1);
        LiveComponentsManagerTest.assertEquals((Object)preferredSize_1, (Object)button_2.getPreferredSize());
    }

    @Test
    public void test_liveImage_noDispose() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo button = BTestUtils.createButton();
        Image image = button.getImage();
        LiveComponentsManagerTest.assertNotNull((Object)image);
        LiveComponentsManagerTest.assertFalse((boolean)image.isDisposed());
        rowLayout.command_CREATE(button, null);
        button = BTestUtils.createButton();
        image = button.getImage();
        LiveComponentsManagerTest.assertNotNull((Object)image);
        LiveComponentsManagerTest.assertFalse((boolean)image.isDisposed());
    }

    @Test
    public void test_liveImage_onComposite() throws Exception {
        this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        ControlInfo label = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
        LiveComponentsManagerTest.assertNotNull((Object)label.getImage());
    }

    @Test
    public void test_liveImage_withShell() throws Exception {
        this.parseComposite("class Test {", "  private static Shell shell;", "  public static void main(String[] args) {", "    shell = new Shell();", "  }", "}");
        ControlInfo text = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
        LiveComponentsManagerTest.assertNotNull((Object)text.getImage());
    }

    @Test
    public void test_liveImage_forcedSize() throws Exception {
        LiveComponentsManagerTest.setFileContentSrc("test/MyCanvas.java", this.getTestSource("public class MyCanvas extends Canvas {", "  public MyCanvas(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        LiveComponentsManagerTest.setFileContentSrc("test/MyCanvas.wbp-component.xml", LiveComponentsManagerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='liveComponent.forcedSize.width'>150</parameter>", "    <parameter name='liveComponent.forcedSize.height'>30</parameter>", "  </parameters>", "</component>"));
        LiveComponentsManagerTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlInfo myCanvas = BTestUtils.createControl("test.MyCanvas");
        LiveComponentsManagerTest.assertEquals((Object)new Dimension(150, 30), (Object)myCanvas.getPreferredSize());
    }

    @Test
    public void test_liveImage_whenException() throws Exception {
        LiveComponentsManagerTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "  public Rectangle getClientArea() {", "    throw new IllegalStateException('Problem in getClientArea()');", "  }", "}"));
        LiveComponentsManagerTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ILog log = DesignerPlugin.getDefault().getLog();
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                LiveComponentsManagerTest.assertEquals((int)4, (int)status.getSeverity());
                Throwable exception = status.getException();
                Assertions.assertThat((Throwable)exception).isExactlyInstanceOf(IllegalStateException.class);
                LiveComponentsManagerTest.assertEquals((Object)"Problem in getClientArea()", (Object)exception.getMessage());
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            ControlInfo newComponent = (ControlInfo)LiveComponentsManagerTest.createJavaInfo("test.MyComposite");
            Image image = newComponent.getImage();
            LiveComponentsManagerTest.assertNotNull((Object)image);
            LiveComponentsManagerTest.assertEquals((int)image.getBounds().width, (int)200);
            LiveComponentsManagerTest.assertEquals((int)image.getBounds().height, (int)50);
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_liveImage_copyPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    button.setBounds(10, 10, 200, 100);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        ControlInfo pasteButton = (ControlInfo)memento.create((JavaInfo)shell);
        Image image = pasteButton.getImage();
        LiveComponentsManagerTest.assertEquals((int)image.getBounds().width, (int)200);
        LiveComponentsManagerTest.assertEquals((int)image.getBounds().height, (int)100);
    }

    @Test
    public void test_liveStyle_standardControl() throws Exception {
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlInfo button = (ControlInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.Button", null);
        int actualStyle = button.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 8) == 8 ? 1 : 0) != 0, (String)("SWT.PUSH bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        button = (ControlInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.Button", "check");
        actualStyle = button.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x20) == 32 ? 1 : 0) != 0, (String)("SWT.CHECK bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        button = (ControlInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.Button", "radio");
        actualStyle = button.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x10) == 16 ? 1 : 0) != 0, (String)("SWT.RADIO bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        ControlInfo text = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
        actualStyle = text.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x800) == 2048 ? 1 : 0) != 0, (String)("SWT.BORDER bit expected, but " + Integer.toHexString(actualStyle) + " found."));
    }

    @Test
    public void test_liveStyle_customControl() throws Exception {
        LiveComponentsManagerTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, SWT.BORDER | SWT.NO_RADIO_GROUP);", "  }", "}"));
        LiveComponentsManagerTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlInfo myComposite = BTestUtils.createControl("test.MyComposite");
        int actualStyle = myComposite.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x800) == 2048 ? 1 : 0) != 0, (String)("SWT.BORDER bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x400000) == 0x400000 ? 1 : 0) != 0, (String)("SWT.NO_RADIO_GROUP bit expected, but " + Integer.toHexString(actualStyle) + " found."));
    }

    @Test
    public void test_liveStyle_forMenu() throws Exception {
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        WidgetInfo menu = (WidgetInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.Menu", "bar");
        int actualStyle = menu.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 2) == 2 ? 1 : 0) != 0, (String)("SWT.BAR bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        menu = (WidgetInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.Menu", null);
        actualStyle = menu.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 8) == 8 ? 1 : 0) != 0, (String)("SWT.POP_UP bit expected, but " + Integer.toHexString(actualStyle) + " found."));
    }

    @Test
    public void test_liveStyle_forMenuItem() throws Exception {
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        WidgetInfo menuItem = (WidgetInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem");
        int actualStyle = menuItem.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 8) == 8 ? 1 : 0) != 0, (String)("SWT.PUSH bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        LiveComponentsManagerTest.assertFalse(((actualStyle & 0x40) == 64 ? 1 : 0) != 0, (String)("Not SWT.CASCADE bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        menuItem = (WidgetInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem", "check");
        actualStyle = menuItem.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x20) == 32 ? 1 : 0) != 0, (String)("SWT.CHECK bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        menuItem = (WidgetInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem", "radio");
        actualStyle = menuItem.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x10) == 16 ? 1 : 0) != 0, (String)("SWT.RADIO bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        menuItem = (WidgetInfo)LiveComponentsManagerTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem", "cascade");
        actualStyle = menuItem.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 0x40) == 64 ? 1 : 0) != 0, (String)("SWT.CASCADE bit expected, but " + Integer.toHexString(actualStyle) + " found."));
    }

    @Test
    public void test_liveStyle_forStaticFactory() throws Exception {
        LiveComponentsManagerTest.setFileContentSrc("test/MenuStaticFactory.java", this.getTestSource("public final class MenuStaticFactory {", "  public static Button createPushButton(Composite parent) {", "    return new Button(parent, SWT.PUSH);", "  }", "}"));
        LiveComponentsManagerTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastState.getEditorLoader().loadClass("test.MenuStaticFactory"), (String)"createPushButton(org.eclipse.swt.widgets.Composite)", (boolean)true);
        ControlInfo button = (ControlInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, (Class)description.getReturnClass(), (CreationSupport)new StaticFactoryCreationSupport(description));
        int actualStyle = button.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 8) == 8 ? 1 : 0) != 0, (String)("SWT.PUSH bit expected, but " + Integer.toHexString(actualStyle) + " found."));
    }

    @Test
    public void test_liveStyle_copyPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    button.setText('my text');", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        ControlInfo pasteButton = (ControlInfo)memento.create((JavaInfo)shell);
        int actualStyle = pasteButton.getStyle();
        LiveComponentsManagerTest.assertTrue(((actualStyle & 8) == 8 ? 1 : 0) != 0, (String)("SWT.PUSH bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        rowLayout.command_CREATE(pasteButton, null);
        memento.apply();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    button.setText('my text');", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('my text');", "    }", "  }", "}");
    }

    @Test
    public void test_liveBaseline() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        ControlInfo newButton = BTestUtils.createButton();
        int liveBaseline = newButton.getBaseline();
        LiveComponentsManagerTest.assertNotEquals((int)liveBaseline, (int)-1);
        LiveComponentsManagerTest.assertTrue((liveBaseline > 0 ? 1 : 0) != 0);
        shell.getLayout().command_CREATE(newButton, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        int baseline = newButton.getBaseline();
        LiveComponentsManagerTest.assertEquals((int)baseline, (int)liveBaseline);
    }
}

