/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.wb.gef.core.tools.SelectEditPartTracker;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.gef.policy.menu.MenuSelectionEditPolicy;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuItemInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.eclipse.wb.tests.designer.swt.model.menu.MenuFeedbackTester;
import org.eclipse.wb.tests.gef.GraphicalRobot;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MenuPopupSimpleTest
extends RcpGefTest {
    private MenuFeedbackTester menuTester;
    private CompositeInfo shellInfo;
    private MenuInfo popupInfo;
    private MenuItemInfo itemInfo;
    private GraphicalEditPart shellPart;
    private GraphicalEditPart popupPart;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    {", "      MenuItem menuItem = new MenuItem(popup, SWT.NONE);", "      menuItem.setText('Item 1');", "    }", "  }", "}");
        this.popupInfo = (MenuInfo)this.shellInfo.getChildren(MenuInfo.class).get(0);
        this.itemInfo = (MenuItemInfo)this.popupInfo.getChildrenItems().get(0);
        this.shellPart = this.canvas.getEditPart(this.shellInfo);
        this.popupPart = this.canvas.getEditPart(this.popupInfo);
        MenuPopupSimpleTest.assertNotNull((Object)this.shellPart);
        MenuPopupSimpleTest.assertNotNull((Object)this.popupPart);
    }

    @Override
    protected void fetchContentFields() {
        super.fetchContentFields();
        this.menuTester = new MenuFeedbackTester(this.canvas);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.shellInfo = null;
        this.popupInfo = null;
        this.itemInfo = null;
        this.shellPart = null;
        this.popupPart = null;
        this.menuTester = null;
        MenuPopupSimpleTest.waitEventLoop(0);
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_clickOnIconToOpen() throws Exception {
        Rectangle bounds = this.popupPart.getFigure().getBounds();
        MenuPopupSimpleTest.assertEquals((int)16, (int)bounds.width);
        MenuPopupSimpleTest.assertEquals((int)16, (int)bounds.height);
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        this.canvas.click(this.popupPart);
        List children = this.popupPart.getChildren();
        MenuPopupSimpleTest.assertEquals((int)1, (int)children.size());
        EditPart dropPart = (EditPart)children.get(0);
        MenuPopupSimpleTest.assertSame(SelectEditPartTracker.class, dropPart.getDragTracker(null).getClass());
        this.canvas.click(this.shellPart, 100, 100);
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
    }

    @Test
    public void test_clickOnCanvas_selectInTree() throws Exception {
        this.assertSelectionModels(new Object[0]);
        this.assertTreeSelectionModels(new Object[0]);
        this.canvas.click(this.popupPart);
        this.assertSelectionModels(this.popupInfo);
        this.assertTreeSelectionModels(this.popupInfo);
    }

    @Test
    public void test_dropDownBounds() throws Exception {
        this.canvas.click(this.popupPart);
        GraphicalEditPart dropPart = (GraphicalEditPart)this.popupPart.getChildren().get(0);
        MenuPopupSimpleTest.assertEquals((Object)GraphicalRobot.getAbsoluteBounds(this.popupPart).getBottomLeft(), (Object)dropPart.getFigure().getLocation());
    }

    @Test
    public void test_selectPopupInTreeToOpen() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        this.tree.select(this.popupInfo);
        MenuPopupSimpleTest.assertEquals((int)2, (int)this.popupPart.getSelected());
        List children = this.popupPart.getChildren();
        MenuPopupSimpleTest.assertEquals((int)1, (int)children.size());
        MenuPopupSimpleTest.assertInstanceOf(EditPart.class, children.get(0));
        this.tree.select(new Object[0]);
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
    }

    @Test
    public void test_selectPopupInTreeToOpen_deselectOnCanvas() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        this.tree.select(this.popupInfo);
        MenuPopupSimpleTest.assertEquals((int)2, (int)this.popupPart.getSelected());
        List children = this.popupPart.getChildren();
        MenuPopupSimpleTest.assertEquals((int)1, (int)children.size());
        MenuPopupSimpleTest.assertInstanceOf(EditPart.class, children.get(0));
        this.canvas.select(new Object[0]);
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
    }

    @Test
    public void test_selectItemInTreeToOpen() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        this.canvas.assertNullEditPart(this.itemInfo);
        this.tree.select(this.itemInfo);
        EditPart dropPart = (EditPart)this.popupPart.getChildren().get(0);
        GraphicalEditPart itemPart = this.canvas.getEditPart(this.itemInfo);
        MenuPopupSimpleTest.assertNotNull((Object)itemPart);
        MenuPopupSimpleTest.assertEquals((int)2, (int)itemPart.getSelected());
        MenuPopupSimpleTest.assertSame((Object)dropPart, (Object)itemPart.getParent());
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        this.tree.select(this.popupInfo);
        MenuPopupSimpleTest.assertSame((Object)dropPart, this.popupPart.getChildren().get(0));
        MenuPopupSimpleTest.assertSame((Object)itemPart, dropPart.getChildren().get(0));
        MenuPopupSimpleTest.assertEquals((int)2, (int)this.popupPart.getSelected());
        MenuPopupSimpleTest.assertEquals((int)0, (int)itemPart.getSelected());
        this.tree.select(new Object[0]);
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        this.canvas.assertNullEditPart(this.itemInfo);
    }

    @Test
    public void test_selectThenDelete() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        this.tree.select(this.popupInfo);
        EditPart dropPart = (EditPart)this.popupPart.getChildren().get(0);
        MenuPopupSimpleTest.assertSame((Object)this.popupPart, (Object)dropPart.getParent());
        this.popupInfo.delete();
        this.canvas.assertNullEditPart(this.popupInfo);
    }

    @Test
    public void test_selectionPolicy() throws Exception {
        MenuSelectionEditPolicy selectionPolicy = (MenuSelectionEditPolicy)this.popupPart.getEditPolicy((Object)"Selection Feedback");
        List selectionHandles = (List)ReflectionUtils.invokeMethod2((Object)selectionPolicy, (String)"createSelectionHandles");
        MenuPopupSimpleTest.assertEquals((int)0, (int)selectionHandles.size());
        this.menuTester.assertMenuNoFeedbacks();
        this.tree.select(this.popupInfo);
        this.menuTester.assertFeedback_selection(this.popupPart);
        this.tree.select(new Object[0]);
        this.menuTester.assertMenuNoFeedbacks();
    }

    @Test
    public void test_dropNotMenu() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        this.loadCreationTool("org.eclipse.swt.widgets.Button");
        this.canvas.moveTo(this.popupPart);
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
    }

    @Test
    public void test_dropNewItem_1() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo(this.popupPart);
        this.menuTester.assertMenuTargetFeedback(this.popupPart);
        EditPart dropPart = (EditPart)this.popupPart.getChildren().get(0);
        GraphicalEditPart itemPart = this.canvas.getEditPart(this.itemInfo);
        MenuPopupSimpleTest.assertEquals((int)0, (int)this.popupPart.getSelected());
        MenuPopupSimpleTest.assertEquals((int)0, (int)dropPart.getSelected());
        MenuPopupSimpleTest.assertEquals((int)0, (int)itemPart.getSelected());
        this.canvas.click(this.shellPart, 100, 100);
        this.menuTester.assertMenuNoFeedbacks();
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
    }

    @Test
    public void test_dropNewItem_2() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        Object newItemInfo = this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo(this.popupPart);
        this.menuTester.assertMenuTargetFeedback(this.popupPart);
        GraphicalEditPart itemPart = this.canvas.getEditPart(this.itemInfo);
        this.canvas.moveTo((Object)itemPart, 1, 1);
        this.menuTester.assertMenuLineFeedback(itemPart, 8);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    {", "      MenuItem menuItem = new MenuItem(popup, SWT.NONE);", "      menuItem.setText('New Item');", "    }", "    {", "      MenuItem menuItem = new MenuItem(popup, SWT.NONE);", "      menuItem.setText('Item 1');", "    }", "  }", "}");
        GraphicalEditPart newItemPart = this.canvas.getEditPart(newItemInfo);
        MenuPopupSimpleTest.assertNotNull((Object)newItemPart);
        MenuPopupSimpleTest.assertEquals((int)2, (int)newItemPart.getSelected());
    }

    @Test
    public void test_dropNewItem_3() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        Object newItemInfo = this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo(this.popupPart);
        this.menuTester.assertMenuTargetFeedback(this.popupPart);
        GraphicalEditPart itemPart = this.canvas.getEditPart(this.itemInfo);
        this.canvas.moveTo((Object)itemPart, 1, -1);
        this.menuTester.assertMenuLineFeedback(itemPart, 32);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    {", "      MenuItem menuItem = new MenuItem(popup, SWT.NONE);", "      menuItem.setText('Item 1');", "    }", "    {", "      MenuItem menuItem = new MenuItem(popup, SWT.NONE);", "      menuItem.setText('New Item');", "    }", "  }", "}");
        GraphicalEditPart newItemPart = this.canvas.getEditPart(newItemInfo);
        MenuPopupSimpleTest.assertNotNull((Object)newItemPart);
        MenuPopupSimpleTest.assertEquals((int)2, (int)newItemPart.getSelected());
    }

    @Test
    public void test_dropNewItem_4() throws Exception {
        MenuPopupSimpleTest.assertTrue((boolean)this.popupPart.getChildren().isEmpty());
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo(this.popupPart);
        this.menuTester.assertMenuTargetFeedback(this.popupPart);
        GraphicalEditPart itemPart = this.canvas.getEditPart(this.itemInfo);
        this.canvas.moveTo((Object)itemPart, 1, -1);
        this.canvas.moveTo((Object)this.shellPart, 200, 100);
        MenuPopupSimpleTest.assertSame((Object)itemPart, (Object)this.canvas.getEditPart(this.itemInfo));
        this.m_viewerCanvas.getEditDomain().loadDefaultTool();
        this.canvas.assertNullEditPart(this.itemInfo);
    }
}

