/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.CardLayout;
import java.util.List;
import javax.swing.JPopupMenu;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JPopupMenuInfo;
import org.eclipse.wb.internal.swing.model.layout.CardLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class CardLayoutTest
extends AbstractLayoutTest {
    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        CardLayoutTest.setLayout(panel, CardLayout.class);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout(0, 0));", "  }", "}");
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        CardLayoutTest.assertNull((Object)layout.getCurrentComponent());
        CardLayoutTest.assertNull((Object)layout.getPrevComponent());
        CardLayoutTest.assertNull((Object)layout.getNextComponent());
    }

    @Test
    public void test_dangling() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        CardLayoutTest.createJavaInfo("java.awt.CardLayout");
        ComponentInfo button = (ComponentInfo)CardLayoutTest.createJavaInfo("javax.swing.JButton");
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
    }

    @Test
    public void test_managedComponents_excludeJPopupMenu() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button = new JButton();", "      add(button, '0');", "    }", "    {", "      JPopupMenu popup = new JPopupMenu();", "      addPopup(this, popup);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        CardLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new CardLayout())/ /add(button, '0')/ /addPopup(this, popup)/}", "  {new: java.awt.CardLayout} {empty} {/setLayout(new CardLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, '0')/}", "  {new: javax.swing.JPopupMenu} {local-unique: popup} {/new JPopupMenu()/ /addPopup(this, popup)/}");
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button");
        Assertions.assertThat((List)layout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_managedComponents_includeExposedComponents() throws Exception {
        CardLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton buttonA = new JButton();", "  private JButton buttonB = new JButton();", "  public MyPanel() {", "    setLayout(new CardLayout());", "    add(buttonA, 'A');", "    add(buttonB, 'B');", "  }", "  public JButton getButtonA() {", "    return buttonA;", "  }", "  public JButton getButtonB() {", "    return buttonB;", "  }", "}"));
        CardLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        CardLayoutTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.CardLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getButtonA()} {property} {}", "  {method: public javax.swing.JButton test.MyPanel.getButtonB()} {property} {}");
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)CardLayoutTest.getJavaInfoByName("getButtonA()");
        ComponentInfo buttonB = (ComponentInfo)CardLayoutTest.getJavaInfoByName("getButtonB()");
        Assertions.assertThat((List)layout.getComponents()).containsExactly((Object[])new ComponentInfo[]{buttonA, buttonB});
    }

    @Test
    public void test_convert() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button");
        CardLayoutInfo layout = (CardLayoutInfo)CardLayoutTest.createJavaInfo("java.awt.CardLayout");
        panel.setLayout((LayoutInfo)layout);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout(0, 0));", "    {", "      JButton button = new JButton();", "      add(button, '" + CardLayoutTest.getAssociationName(button) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    add(new JLabel(), '0');", "  }", "}");
        panel.refresh();
        final CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        CardLayoutTest.assertSame((Object)label, (Object)layout.getCurrentComponent());
        final ComponentInfo newComponent = CardLayoutTest.createJButton();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.command_CREATE(newComponent, null);
            }
        });
        CardLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        CardLayoutTest.assertSame((Object)newComponent, (Object)layout.getCurrentComponent());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    add(new JLabel(), '0');", "    {", "      JButton button = new JButton();", "      add(button, '" + CardLayoutTest.getAssociationName(newComponent) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_JPopupMenu() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    add(new JButton(), '0');", "    add(new JButton(), '1');", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        CardLayoutTest.assertEquals((int)2, (int)panel.getChildrenComponents().size());
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertSame((Object)button_1, (Object)layout.getPrevComponent());
        CardLayoutTest.assertSame((Object)button_1, (Object)layout.getNextComponent());
        final JPopupMenuInfo newPopup = (JPopupMenuInfo)CardLayoutTest.createComponent(JPopupMenu.class);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                newPopup.command_CREATE((ComponentInfo)panel);
            }
        });
        CardLayoutTest.assertEquals((int)3, (int)panel.getChildrenComponents().size());
        CardLayoutTest.assertSame((Object)newPopup, panel.getChildrenComponents().get(0));
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertSame((Object)button_1, (Object)layout.getPrevComponent());
        CardLayoutTest.assertSame((Object)button_1, (Object)layout.getNextComponent());
        CardLayoutTest.assertTrue((boolean)panel.getPresentation().getChildrenGraphical().contains(newPopup));
    }

    @Test
    public void test_MOVE_reorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2, '222');", "    }", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button_2");
        layout.command_MOVE(button_2, button_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_2 = new JButton();", "      add(button_2, '222');", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_reparent_variable() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JPanel panel = new JPanel();", "      add(panel, BorderLayout.NORTH);", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button");
        layout.command_MOVE(button, null);
        CardLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JPanel panel = new JPanel();", "      add(panel, BorderLayout.NORTH);", "    }", "    {", "      JButton button = new JButton();", "      add(button, '" + CardLayoutTest.getAssociationName(button) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_reparent_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JPanel panel;", "  private JButton button;", "  public Test() {", "    setLayout(new CardLayout());", "    add(getPanel(), '111-222-333-444');", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "      panel.add(getButton());", "    }", "    return panel;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button");
        layout.command_MOVE(button, null);
        CardLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
        this.assertEditor("public class Test extends JPanel {", "  private JPanel panel;", "  private JButton button;", "  public Test() {", "    setLayout(new CardLayout());", "    add(getPanel(), '111-222-333-444');", "    add(getButton(), '" + CardLayoutTest.getAssociationName(button) + "');", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "    }", "    return panel;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_visibility_JPanel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_0 = new JButton();", "      add(button_0, '0');", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '1');", "    }", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertVisible(button_0, true);
        CardLayoutTest.assertVisible(button_1, false);
        List children = panel.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)children).containsExactly((Object[])new ObjectInfo[]{button_0});
    }

    @Test
    public void test_visibility_JFrame() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    getContentPane().setLayout(new CardLayout());", "    {", "      JButton button_0 = new JButton();", "      getContentPane().add(button_0, '0');", "    }", "    {", "      JButton button_1 = new JButton();", "      getContentPane().add(button_1, '1');", "    }", "  }", "}");
        frame.refresh();
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        CardLayoutInfo layout = (CardLayoutInfo)contentPane.getLayout();
        List components = contentPane.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertVisible(button_0, true);
        CardLayoutTest.assertVisible(button_1, false);
    }

    @Test
    public void test_show() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button = new JButton();", "      add(button, '0');", "    }", "    {", "      JLabel label = new JLabel();", "      add(label, '1');", "    }", "    {", "      JTextField text = new JTextField();", "      add(text, '2');", "    }", "  }", "}");
        panel.refresh();
        List components = panel.getChildrenComponents();
        CardLayoutTest.assertEquals((int)3, (int)components.size());
        ComponentInfo button = (ComponentInfo)components.get(0);
        ComponentInfo label = (ComponentInfo)components.get(1);
        ComponentInfo text = (ComponentInfo)components.get(2);
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        CardLayoutTest.assertSame((Object)button, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertSame((Object)text, (Object)layout.getPrevComponent());
        CardLayoutTest.assertSame((Object)label, (Object)layout.getNextComponent());
        CardLayoutTest.assertVisible(button, true);
        CardLayoutTest.assertVisible(label, false);
        CardLayoutTest.assertVisible(text, false);
        layout.show(text);
        CardLayoutTest.assertSame((Object)text, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertSame((Object)label, (Object)layout.getPrevComponent());
        CardLayoutTest.assertSame((Object)button, (Object)layout.getNextComponent());
        CardLayoutTest.assertVisible(button, false);
        CardLayoutTest.assertVisible(label, false);
        CardLayoutTest.assertVisible(text, true);
    }

    @Test
    public void test_selecting() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_0 = new JButton();", "      add(button_0, '0');", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel, '1');", "      {", "        JButton button_1 = new JButton();", "        innerPanel.add(button_1);", "      }", "    }", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button_1 = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertVisible(button_0, true);
        CardLayoutTest.assertVisible((ComponentInfo)innerPanel, false);
        boolean refreshFlag = CardLayoutTest.notifySelecting((ObjectInfo)button_0);
        CardLayoutTest.assertFalse((boolean)refreshFlag);
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        refreshFlag = CardLayoutTest.notifySelecting((ObjectInfo)button_1);
        CardLayoutTest.assertTrue((boolean)refreshFlag);
        panel.refresh();
        CardLayoutTest.assertSame((Object)innerPanel, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertVisible(button_0, false);
        CardLayoutTest.assertVisible((ComponentInfo)innerPanel, true);
    }

    @Test
    public void test_selecting_deprecatedAdd() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_0 = new JButton();", "      add('0', button_0);", "    }", "    {", "      JButton button_1 = new JButton();", "      add('1', button_1);", "    }", "  }", "}");
        panel.refresh();
        CardLayoutInfo layout = (CardLayoutInfo)panel.getLayout();
        ComponentInfo button_0 = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button_0");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutTest.getJavaInfoByName("button_1");
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertVisible(button_0, true);
        CardLayoutTest.assertVisible(button_1, false);
        boolean refreshFlag = CardLayoutTest.notifySelecting((ObjectInfo)button_0);
        CardLayoutTest.assertFalse((boolean)refreshFlag);
        CardLayoutTest.assertSame((Object)button_0, (Object)layout.getCurrentComponent());
        refreshFlag = CardLayoutTest.notifySelecting((ObjectInfo)button_1);
        CardLayoutTest.assertTrue((boolean)refreshFlag);
        panel.refresh();
        CardLayoutTest.assertSame((Object)button_1, (Object)layout.getCurrentComponent());
        CardLayoutTest.assertVisible(button_0, false);
        CardLayoutTest.assertVisible(button_1, true);
    }

    private static void assertVisible(ComponentInfo component, boolean visible) {
        CardLayoutTest.assertEquals((Object)visible, (Object)component.getComponent().isVisible());
    }

    static String getAssociationName(ComponentInfo component) {
        InvocationAssociation association = (InvocationAssociation)component.getAssociation();
        MethodInvocation invocation = association.getInvocation();
        StringLiteral nameLiteral = (StringLiteral)invocation.arguments().get(1);
        return nameLiteral.getLiteralValue();
    }
}

