/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.util.LinkedList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.ColumnInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.Test;

public class GridBagColumnTest
extends AbstractGridBagLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setSize_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{0};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        ColumnInfo column = (ColumnInfo)layout.getColumns().get(0);
        GridBagColumnTest.assertEquals((int)0, (int)column.getSize());
        column.setSize(100);
        GridBagColumnTest.assertEquals((int)100, (int)column.getSize());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{100};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_setSize_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        ColumnInfo column = (ColumnInfo)layout.getColumns().get(0);
        GridBagColumnTest.assertEquals((int)0, (int)column.getSize());
        column.setSize(100);
        GridBagColumnTest.assertEquals((int)100, (int)column.getSize());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{100, 0};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_setWeight_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWeights = new double[]{0.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        ColumnInfo column = (ColumnInfo)layout.getColumns().get(0);
        GridBagColumnTest.assertEquals((double)0.0, (double)column.getWeight(), (double)1.0E-6);
        column.setWeight(2.0);
        GridBagColumnTest.assertEquals((double)2.0, (double)column.getWeight(), (double)1.0E-6);
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWeights = new double[]{2.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_setWeight_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        ColumnInfo column = (ColumnInfo)layout.getColumns().get(0);
        GridBagColumnTest.assertEquals((double)0.0, (double)column.getWeight(), (double)1.0E-6);
        column.setWeight(2.0);
        GridBagColumnTest.assertEquals((double)2.0, (double)column.getWeight(), (double)1.0E-6);
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWeights = new double[]{2.0, 0.0};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_getAlignment_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{0};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagColumnTest.assertSame((Object)ColumnInfo.Alignment.UNKNOWN, (Object)((ColumnInfo)layout.getColumns().get(0)).getAlignment());
    }

    @Test
    public void test_getAlignment_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.WEST;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagColumnTest.assertSame((Object)ColumnInfo.Alignment.LEFT, (Object)((ColumnInfo)layout.getColumns().get(0)).getAlignment());
    }

    @Test
    public void test_getAlignment_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.WEST;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      gbc.anchor = GridBagConstraints.EAST;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        ColumnInfo column = (ColumnInfo)layout.getColumns().get(0);
        GridBagColumnTest.assertSame((Object)ColumnInfo.Alignment.UNKNOWN, (Object)column.getAlignment());
        column.setAlignment(ColumnInfo.Alignment.RIGHT);
        GridBagColumnTest.assertSame((Object)ColumnInfo.Alignment.RIGHT, (Object)column.getAlignment());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.EAST;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      gbc.anchor = GridBagConstraints.EAST;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_insert() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.1, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)1, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().insert(1);
            }
        });
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 0, 2};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.1, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getColumnOperations().delete(0);
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getColumnOperations().delete(1);
        GridBagColumnTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_whenNotEnoughWidthElements() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        this.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)GridBagColumnTest.getJavaInfoByName("layout");
        GridBagColumnTest.assertEquals((int)3, (int)layout.getColumns().size());
        ExecutionUtils.run((ObjectInfo)layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().delete(1);
            }
        });
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1};", "    layout.columnWeights = new double[] {0.1, 0.3};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_backward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3, 4};", "    layout.rowHeights = new int[] {1, 2, 3, 4};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        LinkedList columns = layout.getColumns();
        GridBagColumnTest.assertEquals((int)3, (int)columns.size());
        ColumnInfo column_0 = (ColumnInfo)columns.get(0);
        ColumnInfo column_1 = (ColumnInfo)columns.get(1);
        ColumnInfo column_2 = (ColumnInfo)columns.get(2);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().move(2, 0);
            }
        });
        GridBagColumnTest.assertEquals((int)3, (int)columns.size());
        GridBagColumnTest.assertSame((Object)column_2, columns.get(0));
        GridBagColumnTest.assertSame((Object)column_0, columns.get(1));
        GridBagColumnTest.assertSame((Object)column_1, columns.get(2));
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {3, 1, 2, 4};", "    layout.rowHeights = new int[] {1, 2, 3, 4};", "    layout.columnWeights = new double[] {0.3, 0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 2;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_forward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3, 4};", "    layout.rowHeights = new int[] {1, 2, 3, 4};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        LinkedList columns = layout.getColumns();
        GridBagColumnTest.assertEquals((int)3, (int)columns.size());
        ColumnInfo column_0 = (ColumnInfo)columns.get(0);
        ColumnInfo column_1 = (ColumnInfo)columns.get(1);
        ColumnInfo column_2 = (ColumnInfo)columns.get(2);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().move(0, 3);
            }
        });
        GridBagColumnTest.assertEquals((int)3, (int)columns.size());
        GridBagColumnTest.assertSame((Object)column_1, columns.get(0));
        GridBagColumnTest.assertSame((Object)column_2, columns.get(1));
        GridBagColumnTest.assertSame((Object)column_0, columns.get(2));
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {2, 3, 1, 4};", "    layout.rowHeights = new int[] {1, 2, 3, 4};", "    layout.columnWeights = new double[] {0.2, 0.3, 0.1, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 2;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_inside() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_setCells(button_0, new Rectangle(0, 0, 2, 1));
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridwidth = 2;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 0);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        ComponentInfo button_2 = GridBagColumnTest.createJButton();
        layout.command_CREATE(button_2, 2, false, 1, false);
        GridBagColumnTest.assertEquals((int)3, (int)layout.getColumns().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridwidth = 2;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().move(2, 1);
            }
        });
        GridBagColumnTest.assertEquals((int)3, (int)layout.getColumns().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridwidth = 3;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 0);", "      add(button_0, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().normalizeSpanning();
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_00 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button_00, gbc);", "    }", "    {", "      JButton button_01 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_01, gbc);", "    }", "    {", "      JButton button_11 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_11, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().normalizeSpanning();
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_00 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button_00, gbc);", "    }", "    {", "      JButton button_01 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_01, gbc);", "    }", "    {", "      JButton button_11 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_11, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button_0, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().normalizeSpanning();
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_clear_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().clear(0);
            }
        });
        GridBagColumnTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_clear_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)3, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)3, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().clear(1);
            }
        });
        GridBagColumnTest.assertEquals((int)3, (int)layout.getColumns().size());
        GridBagColumnTest.assertEquals((int)3, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_span_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        LinkedList columns = layout.getColumns();
        GridBagColumnTest.assertEquals((int)2, (int)columns.size());
        GridBagColumnTest.assertEquals((int)1, (int)((ColumnInfo)columns.get(0)).getSize());
        GridBagColumnTest.assertEquals((int)2, (int)((ColumnInfo)columns.get(1)).getSize());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getColumnOperations().split(0);
            }
        });
        GridBagColumnTest.assertEquals((int)2, (int)layout.getRows().size());
        columns = layout.getColumns();
        GridBagColumnTest.assertEquals((int)3, (int)columns.size());
        GridBagColumnTest.assertEquals((int)1, (int)((ColumnInfo)columns.get(0)).getSize());
        GridBagColumnTest.assertEquals((int)1, (int)((ColumnInfo)columns.get(1)).getSize());
        GridBagColumnTest.assertEquals((int)2, (int)((ColumnInfo)columns.get(2)).getSize());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 1, 2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, 0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridwidth = 2;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
    }
}

