/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.jupiter.api.Test;

public class FormToolkitTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        InstanceFactoryInfo toolkit = this.getToolkit();
        ComponentDescription description = toolkit.getDescription();
        FormToolkitTest.assertEquals((Object)"org.eclipse.ui.forms.widgets.FormToolkit", (Object)description.getComponentClass().getName());
        FormToolkitTest.assertNotNull((Object)description.getMethod("adapt(org.eclipse.swt.widgets.Composite)"));
        FormToolkitTest.assertNotNull((Object)description.getMethod("adapt(org.eclipse.swt.widgets.Control,boolean,boolean)"));
    }

    @Test
    public void test_createFormToolkit_usingStaticFactory() throws Exception {
        this.m_waitForAutoBuild = true;
        this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = createFormToolkit();", "  public Test() {", "  }", "  /**", "  * @wbp.factory", "  */", "  private static FormToolkit createFormToolkit() {", "    return new FormToolkit(Display.getDefault());", "  }", "}");
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {static factory: test.Test createFormToolkit()} {field-initializer: m_toolkit} {/createFormToolkit()/}");
    }

    @Test
    public void test_createFormToolkit_inInitializer_instance() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  private FormToolkit m_toolkit;", "  {", "    m_toolkit = new FormToolkit(Display.getDefault());", "  }", "  public Test() {", "  }", "}");
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {new: org.eclipse.ui.forms.widgets.FormToolkit} {field-unique: m_toolkit} {/new FormToolkit(Display.getDefault())/}");
    }

    @Test
    public void test_createFormToolkit_inInitializer_static() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  private static FormToolkit m_toolkit;", "  static {", "    m_toolkit = new FormToolkit(Display.getDefault());", "  }", "  public Test() {", "  }", "}");
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {new: org.eclipse.ui.forms.widgets.FormToolkit} {field-unique: m_toolkit} {/new FormToolkit(Display.getDefault())/}");
    }

    @Test
    public void test_createText() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new RowLayout());", "    Text text = m_toolkit.createText(this, 'text', SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(0);
        FormToolkitTest.assertNotNull((Object)text.getPropertyByTitle("Style"));
    }

    @Test
    public void test_createTable_separateStatement() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "    m_toolkit.createTable(this, SWT.NONE);", "  }", "}");
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /m_toolkit.createTable(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {instance factory: {field-initializer: m_toolkit} createTable(org.eclipse.swt.widgets.Composite,int)} {empty} {/m_toolkit.createTable(this, SWT.NONE)/}", "  {instance factory container}", "    {new: org.eclipse.ui.forms.widgets.FormToolkit} {field-initializer: m_toolkit} {/new FormToolkit(Display.getDefault())/ /m_toolkit.createTable(this, SWT.NONE)/}");
        shell.refresh();
        FormToolkitTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_createLabel_separateStatement_GridLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new GridLayout());", "    m_toolkit.createLabel(this, 'Some text', SWT.NONE);", "  }", "}");
        shell.refresh();
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /m_toolkit.createLabel(this, 'Some text', SWT.NONE)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {instance factory: {field-initializer: m_toolkit} createLabel(org.eclipse.swt.widgets.Composite,java.lang.String,int)} {empty} {/m_toolkit.createLabel(this, 'Some text', SWT.NONE)/}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "  {instance factory container}", "    {new: org.eclipse.ui.forms.widgets.FormToolkit} {field-initializer: m_toolkit} {/new FormToolkit(Display.getDefault())/ /m_toolkit.createLabel(this, 'Some text', SWT.NONE)/}");
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        IObjectPresentation presentation = shell.getPresentation();
        List presentationChildren = presentation.getChildrenTree();
        Assertions.assertThat((List)presentationChildren).contains((Object[])new ObjectInfo[]{label});
    }

    @Test
    public void test_FormToolkit_asConstructorParameter() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style, FormToolkit toolkit) {", "    super(parent, style);", "    toolkit.createTable(this, SWT.NONE);", "  }", "}");
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Composite} {this} {/toolkit.createTable(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory: {toolkit} createTable(org.eclipse.swt.widgets.Composite,int)} {empty} {/toolkit.createTable(this, SWT.NONE)/}", "  {instance factory container}", "    {parameter} {toolkit} {/toolkit.createTable(this, SWT.NONE)/}");
        composite.refresh();
        FormToolkitTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_FormToolkit_asConstructorParameter2() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style, FormToolkit toolkit) {", "    super(parent, style);", "  }", "}");
        FormToolkitTest.assertHierarchy("{this: org.eclipse.swt.widgets.Composite} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {parameter} {toolkit} {}");
        composite.refresh();
        FormToolkitTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_FormToolkit_asEntryPoint_methodParameter() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test {", "  /**", "  * @wbp.parser.entryPoint", "  */", "  public void createClient(Section section, FormToolkit toolkit) {", "    Composite container = toolkit.createComposite(section);", "  }", "}");
        FormToolkitTest.assertHierarchy("{instance factory: {toolkit} createComposite(org.eclipse.swt.widgets.Composite)} {local-unique: container} {/toolkit.createComposite(section)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {parameter} {toolkit} {/toolkit.createComposite(section)/}");
        composite.refresh();
        FormToolkitTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_paintBordersFor_whenDropNewComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        ControlInfo newComposite = (ControlInfo)FormToolkitTest.createJavaInfo("org.eclipse.swt.widgets.Composite");
        shell.getLayout().command_CREATE(newComposite, null);
        this.assertEditor("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      m_toolkit.adapt(composite);", "      m_toolkit.paintBordersFor(composite);", "    }", "  }", "}");
    }

    @Test
    public void test_adapt_whenDropNonFormControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        ControlInfo newButton = BTestUtils.createButton();
        shell.getLayout().command_CREATE(newButton, null);
        this.assertEditor("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      m_toolkit.adapt(button, true, true);", "    }", "  }", "}");
    }

    @Test
    public void test_adapt_whenDropNonFormControl_ignoreFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 0, false, 1, false);
        this.assertEditor("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      m_toolkit.adapt(button, true, true);", "    }", "  }", "}");
    }
}

