/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.refactoring;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wb.internal.core.utils.refactoring.RefactoringUtils;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.utils.xml.FileDocumentEditContext;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RefactoringUtilsTest
extends AbstractJavaTest {
    private static final IProgressMonitor PM = new NullProgressMonitor();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            RefactoringUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_modifyXML_noChanges() throws Exception {
        IFile file = RefactoringUtilsTest.setFileContentSrc("test/my.xml", RefactoringUtilsTest.getSourceDQ("<!-- filler filler filler filler filler -->", "<!-- filler filler filler filler filler -->", "<root/>"));
        Change change = RefactoringUtils.modifyXML((IFile)file, (DocumentModelVisitor)new DocumentModelVisitor(), (AbstractDocumentEditContext)new FileDocumentEditContext(file));
        RefactoringUtilsTest.assertSame(null, (Object)change);
    }

    @Test
    public void test_modifyXML_doChanges() throws Exception {
        IFile file = RefactoringUtilsTest.setFileContentSrc("test/my.xml", RefactoringUtilsTest.getSourceDQ("<!-- filler filler filler filler filler -->", "<!-- filler filler filler filler filler -->", "<root/>"));
        DocumentModelVisitor visitor = new DocumentModelVisitor(){

            public void endVisit(DocumentElement element) {
                element.setAttribute("visited", "true");
            }
        };
        Change change = RefactoringUtils.modifyXML((IFile)file, (DocumentModelVisitor)visitor, (AbstractDocumentEditContext)new FileDocumentEditContext(file));
        RefactoringUtilsTest.assertEquals((Object)RefactoringUtilsTest.getSourceDQ("<!-- filler filler filler filler filler -->", "<!-- filler filler filler filler filler -->", "<root/>"), (Object)RefactoringUtilsTest.getFileContentSrc("test/my.xml"));
        change.perform(PM);
        RefactoringUtilsTest.assertEquals((Object)RefactoringUtilsTest.getSourceDQ("<!-- filler filler filler filler filler -->", "<!-- filler filler filler filler filler -->", "<root visited='true'/>"), (Object)RefactoringUtilsTest.getFileContentSrc("test/my.xml"));
    }

    @Test
    public void test_createDeleteTypeChange() throws Exception {
        IType type = this.createModelType("test", "Foo.java", RefactoringUtilsTest.getSource("// filler filler filler filler filler", "package test;", "public class Foo {", "  public Foo() {", "  }", "}"));
        RefactoringUtilsTest.assertFileExists("src/test/Foo.java");
        Change change = RefactoringUtils.createDeleteTypeChange((IType)type);
        RefactoringUtilsTest.assertNotNull((Object)change);
        change.perform(PM);
        RefactoringUtilsTest.assertFileNotExists("src/test/Foo.java");
    }

    @Test
    public void test_createRenameTypeChange() throws Exception {
        IType type = this.createModelType("test", "Foo.java", RefactoringUtilsTest.getSource("// filler filler filler filler filler", "package test;", "public class Foo {", "  public Foo() {", "  }", "}"));
        RefactoringUtilsTest.assertFileExists("src/test/Foo.java");
        Change change = RefactoringUtils.createRenameTypeChange((IType)type, (String)"Barr", (IProgressMonitor)PM);
        RefactoringUtilsTest.assertNotNull((Object)change);
        change.perform(PM);
        RefactoringUtilsTest.assertFileNotExists("src/test/Foo.java");
        RefactoringUtilsTest.assertFileExists("src/test/Barr.java");
        RefactoringUtilsTest.assertEquals((Object)RefactoringUtilsTest.getSource("// filler filler filler filler filler", "package test;", "public class Barr {", "  public Barr() {", "  }", "}"), (Object)RefactoringUtilsTest.getFileContentSrc("test/Barr.java"));
    }

    @Test
    public void test_mergeTextChanges_twoTextFileChanges() throws Exception {
        IFile file = RefactoringUtilsTest.setFileContent("Test.txt", "abc");
        TextFileChange fileChange_1 = new TextFileChange("Change 1", file);
        MultiTextEdit multiEdit = new MultiTextEdit();
        multiEdit.addChild((TextEdit)new ReplaceEdit(0, 1, "AA"));
        multiEdit.addChild((TextEdit)new ReplaceEdit(2, 1, "CC"));
        fileChange_1.setEdit((TextEdit)multiEdit);
        TextFileChange fileChange_2 = new TextFileChange("Change 2", file);
        fileChange_2.setEdit((TextEdit)new ReplaceEdit(1, 1, "B"));
        CompositeChange compositeChange = new CompositeChange("Composite change");
        compositeChange.add((Change)fileChange_1);
        compositeChange.add((Change)fileChange_2);
        RefactoringUtils.mergeTextChanges((Change)fileChange_1, (Change)fileChange_2);
        compositeChange.perform(PM);
        RefactoringUtilsTest.assertEquals((Object)"AABCC", (Object)RefactoringUtilsTest.getFileContent(file));
    }

    @Test
    public void test_mergeTextChanges_sourceIsCompositeChange() throws Exception {
        IFile file = RefactoringUtilsTest.setFileContent("Test.txt", "abc");
        TextFileChange fileChange = new TextFileChange("Change 1", file);
        MultiTextEdit multiEdit = new MultiTextEdit();
        multiEdit.addChild((TextEdit)new ReplaceEdit(0, 1, "AA"));
        multiEdit.addChild((TextEdit)new ReplaceEdit(2, 1, "CC"));
        fileChange.setEdit((TextEdit)multiEdit);
        CompositeChange change_1 = new CompositeChange("CompositeChange 1");
        change_1.add((Change)fileChange);
        TextFileChange change_2 = new TextFileChange("Change 2", file);
        change_2.setEdit((TextEdit)new ReplaceEdit(1, 1, "B"));
        CompositeChange compositeChange = new CompositeChange("Composite change");
        compositeChange.add((Change)change_1);
        compositeChange.add((Change)change_2);
        RefactoringUtils.mergeTextChanges((Change)change_1, (Change)change_2);
        compositeChange.perform(PM);
        RefactoringUtilsTest.assertEquals((Object)"AABCC", (Object)RefactoringUtilsTest.getFileContent(file));
    }

    @Test
    public void test_mergeTextChange() throws Exception {
        IFile file = RefactoringUtilsTest.setFileContent("Test.txt", "abc");
        TextFileChange existingChange = new TextFileChange("Existing change", file);
        existingChange.setEdit((TextEdit)new ReplaceEdit(0, 1, "AA"));
        CompositeChange newChangeComposite = new CompositeChange("CC with new");
        TextFileChange newChange = new TextFileChange("New change", file);
        newChange.setEdit((TextEdit)new ReplaceEdit(2, 1, "C"));
        newChangeComposite.add((Change)newChange);
        Assertions.assertThat((Object[])newChangeComposite.getChildren()).hasSize(1);
        RefactoringParticipant participant = (RefactoringParticipant)Mockito.mock(RefactoringParticipant.class);
        Mockito.when((Object)participant.getTextChange((Object)file)).thenReturn((Object)existingChange);
        RefactoringUtils.mergeTextChange((RefactoringParticipant)participant, (Change)newChangeComposite);
        ((RefactoringParticipant)Mockito.verify((Object)participant)).getTextChange((Object)file);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{participant});
        existingChange.perform(PM);
        RefactoringUtilsTest.assertEquals((Object)"AAbC", (Object)RefactoringUtilsTest.getFileContent(file));
        Assertions.assertThat((Object[])newChangeComposite.getChildren()).hasSize(0);
    }
}

