/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.check;

import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssertTest
extends Assertions {
    @Test
    public void test_isLegal() {
        Assert.isLegal((boolean)true);
        Assert.isLegal((boolean)true, (String)"message");
        try {
            Assert.isLegal((boolean)false);
            AssertTest.fail();
        }
        catch (IllegalArgumentException e) {
            AssertTest.assertEquals((Object)"", (Object)e.getMessage());
        }
        try {
            Assert.isLegal((boolean)false, (String)"message");
            AssertTest.fail();
        }
        catch (IllegalArgumentException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNull() {
        Assert.isNull(null);
        Assert.isNull(null, (String)"message");
        try {
            Assert.isNull((Object)((Object)this));
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"null argument expected", (Object)e.getMessage());
        }
        try {
            Assert.isNull((Object)((Object)this), (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNull_1() {
        Assert.isNull(null, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
        try {
            Assert.isNull((Object)((Object)this), (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNull_2() {
        Assert.isNull2(null, (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
        try {
            Assert.isNull2((Object)((Object)this), (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull_1() {
        Assert.isNotNull((Object)((Object)this));
        try {
            Assert.isNotNull(null);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"null argument", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull_2() {
        Assert.isNotNull((Object)((Object)this), (String)"message");
        try {
            Assert.isNotNull(null, (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull_3() {
        Assert.isNotNull((Object)((Object)this), (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
        try {
            Assert.isNotNull(null, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull2() throws Exception {
        Assert.isNotNull2((Object)((Object)this), (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
        try {
            Assert.isNotNull2(null, (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_fail() throws Exception {
        String message = "My fail message";
        try {
            Assert.fail((String)message);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertSame((Object)message, (Object)e.getMessage());
        }
    }

    @Test
    public void test_fail_withParameters() throws Exception {
        try {
            Assert.fail((String)"My {1} message {0}.", (Object[])new Object[]{"second", "first"});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"My first message second.", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue_1() {
        Assert.isTrue((boolean)true);
        try {
            Assert.isTrue((boolean)false);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"assertion failed", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue_2() {
        Assert.isTrue((boolean)true, (String)"message");
        try {
            Assert.isTrue((boolean)false, (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue_3() {
        Assert.isTrue((boolean)true, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
        try {
            Assert.isTrue((boolean)false, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue2() {
        Assert.isTrue2((boolean)true, (String)"errorFormat {0} {1}", (Object[])new Object[]{"ABC", 2});
        try {
            Assert.isTrue2((boolean)false, (String)"errorFormat {0} {1}", (Object[])new Object[]{"ABC", 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat ABC 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_equals_int() throws Exception {
        Assert.equals((int)0, (int)0);
        try {
            Assert.equals((int)0, (int)1);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"0 expected, but 1 found", (Object)e.getMessage());
        }
        try {
            Assert.equals((int)0, (int)1, (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_instanceOf() throws Exception {
        try {
            Assert.instanceOf(String.class, null);
            AssertTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
        Assert.instanceOf(String.class, (Object)"");
        try {
            Assert.instanceOf(String.class, (Object)Boolean.TRUE);
            AssertTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_isTrueException_success() throws Exception {
        int exceptionCode = -1;
        Assert.isTrueException((boolean)true, (int)exceptionCode, (Object[])new Object[0]);
    }

    @Test
    public void test_isTrueException_String() throws Exception {
        int exceptionCode = -1;
        String message = "message";
        try {
            Assert.isTrueException((boolean)false, (int)exceptionCode, (Object[])new Object[]{message});
            AssertTest.fail();
        }
        catch (DesignerException e) {
            AssertTest.assertEquals((int)exceptionCode, (int)e.getCode());
            String[] parameters = e.getParameters();
            AssertTest.assertEquals((int)1, (int)parameters.length);
            AssertTest.assertSame((Object)message, (Object)parameters[0]);
        }
    }

    @Test
    public void test_isTrueException_Object() throws Exception {
        int exceptionCode = -1;
        Integer parameter = 10;
        try {
            Assert.isTrueException((boolean)false, (int)exceptionCode, (Object[])new Object[]{parameter});
            AssertTest.fail();
        }
        catch (DesignerException e) {
            AssertTest.assertEquals((int)exceptionCode, (int)e.getCode());
            String[] parameters = e.getParameters();
            AssertTest.assertEquals((int)1, (int)parameters.length);
            AssertTest.assertEquals((Object)"10", (Object)parameters[0]);
        }
    }

    @Test
    public void test_isTrueException_null() throws Exception {
        int exceptionCode = -1;
        Object parameter = null;
        try {
            Assert.isTrueException((boolean)false, (int)exceptionCode, (Object[])new Object[]{parameter});
            AssertTest.fail();
        }
        catch (DesignerException e) {
            AssertTest.assertEquals((int)exceptionCode, (int)e.getCode());
            String[] parameters = e.getParameters();
            AssertTest.assertEquals((int)1, (int)parameters.length);
            AssertTest.assertEquals((Object)"null", (Object)parameters[0]);
        }
    }
}

