/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ast;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.internal.core.utils.ast.ListGatherer;
import org.eclipse.wb.internal.core.utils.ast.SetGatherer;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class GathererTest
extends AbstractJavaTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
        GathererTest.do_projectCreate();
    }

    @Test
    public void test_ListGatherer() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tString a = \"aaa\";\n\tString b = \"bbb\";\n}");
        ListGatherer<StringLiteral> gatherer = new ListGatherer<StringLiteral>(){

            public void endVisit(StringLiteral node) {
                this.addResult(node);
            }
        };
        typeDeclaration.accept((ASTVisitor)gatherer);
        GathererTest.assertTrue((boolean)gatherer.hasResults());
        List resultList = gatherer.getResultList();
        GathererTest.assertEquals((int)2, (int)resultList.size());
        GathererTest.assertEquals((Object)"aaa", (Object)((StringLiteral)resultList.get(0)).getLiteralValue());
        GathererTest.assertEquals((Object)"bbb", (Object)((StringLiteral)resultList.get(1)).getLiteralValue());
        Set resultSet = gatherer.getResultSet();
        GathererTest.assertEquals((int)2, (int)resultSet.size());
        resultSet.containsAll(resultList);
    }

    @Test
    public void test_SetGatherer() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tString a = \"aaa\";\n\tString b = \"bbb\";\n}");
        SetGatherer<StringLiteral> gatherer = new SetGatherer<StringLiteral>(){

            public void endVisit(StringLiteral node) {
                this.addResult(node);
            }
        };
        typeDeclaration.accept((ASTVisitor)gatherer);
        GathererTest.assertTrue((boolean)gatherer.hasResults());
        GathererTest.assertNull((Object)gatherer.getUniqueResult());
        Set resultSet = gatherer.getResultSet();
        GathererTest.assertEquals((int)2, (int)resultSet.size());
        GathererTest.assertTrue((boolean)GathererTest.hasStringLiteral(resultSet, "aaa"));
        GathererTest.assertTrue((boolean)GathererTest.hasStringLiteral(resultSet, "bbb"));
        List resultList = gatherer.getResultList();
        GathererTest.assertEquals((int)2, (int)resultList.size());
        resultList.containsAll(resultSet);
    }

    @Test
    public void test_unique() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tString a = \"aaa\";\n}");
        SetGatherer<StringLiteral> gatherer = new SetGatherer<StringLiteral>(){

            public void endVisit(StringLiteral node) {
                this.addResult(node);
            }
        };
        typeDeclaration.accept((ASTVisitor)gatherer);
        GathererTest.assertTrue((boolean)gatherer.hasResults());
        StringLiteral stringLiteral = (StringLiteral)gatherer.getUniqueResult();
        GathererTest.assertNotNull((Object)stringLiteral);
        GathererTest.assertEquals((Object)"aaa", (Object)stringLiteral.getLiteralValue());
    }

    @Test
    public void test_VariableDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tString a = \"aaa\";\n\tString b = \"bbb\";\n}");
        ListGatherer<VariableDeclarationFragment> gatherer = new ListGatherer<VariableDeclarationFragment>(){

            public void endVisit(VariableDeclarationFragment node) {
                this.addResult(node);
            }
        };
        typeDeclaration.accept((ASTVisitor)gatherer);
        GathererTest.assertTrue((boolean)gatherer.hasResults());
        VariableDeclaration[] declarations = (VariableDeclaration[])gatherer.toArray(VariableDeclarationFragment.class);
        GathererTest.assertEquals((int)2, (int)declarations.length);
        GathererTest.assertEquals((Object)"a", (Object)declarations[0].getName().getIdentifier());
        GathererTest.assertEquals((Object)"b", (Object)declarations[1].getName().getIdentifier());
    }

    private static boolean hasStringLiteral(Collection<StringLiteral> collection, String literalValue) {
        for (StringLiteral stringLiteral : collection) {
            if (!stringLiteral.getLiteralValue().equals(literalValue)) continue;
            return true;
        }
        return false;
    }
}

