/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.FieldReuseVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.jupiter.api.Test;

public class FieldReuseTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getReferenceExpression_local() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private JButton button;", "  Test() {", "    {", "      button = new JButton('1');", "      add(button);", "    }", "    {", "      button = new JButton('2');", "      add(button);", "    }", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(2);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldReuseTest.assertTrue((boolean)(variableSupport instanceof FieldReuseVariableSupport));
        NodeTarget target = FieldReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        FieldReuseTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
    }

    @Test
    public void test_getReferenceExpression_remote() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private JButton button;", "  Test() {", "    {", "      button = new JButton('1');", "      add(button);", "    }", "    {", "      button = new JButton('2');", "      add(button);", "    }", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(2);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldReuseTest.assertTrue((boolean)(variableSupport instanceof FieldReuseVariableSupport));
        NodeTarget target = FieldReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 1);
        FieldReuseTest.assertEquals((Object)"button_1", (Object)variableSupport.getReferenceExpression(target));
        FieldReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("class Test extends JPanel {", "  private JButton button;", "  private JButton button_1;", "  Test() {", "    {", "      button_1 = new JButton('1');", "      add(button_1);", "    }", "    {", "      button = new JButton('2');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private JButton button = new JButton('1');", "  Test() {", "    button = new JButton('2');", "    add(button);", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(1);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldReuseTest.assertTrue((boolean)(variableSupport instanceof FieldReuseVariableSupport));
        FieldReuseTest.assertEquals((Object)"field-reused: button", (Object)variableSupport.toString());
        FieldReuseTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        FieldReuseTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)variableSupport, (String)"prefixThis()", (Object[])new Object[0])));
        FieldReuseTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            FieldReuseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        FieldReuseTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            FieldReuseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private JButton button = new JButton('1');", "  Test() {", "    add(button);", "    button = new JButton('2');", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(1);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldReuseTest.assertTrue((boolean)(variableSupport instanceof FieldReuseVariableSupport));
        NodeTarget target = FieldReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 1);
        FieldReuseTest.assertEquals((Object)"button_1", (Object)variableSupport.getReferenceExpression(target));
        FieldReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        FieldReuseTest.assertAST(this.m_lastEditor);
        FieldReuseTest.assertEquals((Object)this.getTestSource("class Test extends JPanel {", "  private JButton button;", "  private JButton button_1 = new JButton('1');", "  Test() {", "    add(button_1);", "    button = new JButton('2');", "  }", "}"), (Object)this.m_lastEditor.getSource());
        button.getVariableSupport().setName("firstButton");
        FieldReuseTest.assertAST(this.m_lastEditor);
        FieldReuseTest.assertEquals((Object)this.getTestSource("class Test extends JPanel {", "  private JButton button;", "  private JButton firstButton = new JButton('1');", "  Test() {", "    add(firstButton);", "    button = new JButton('2');", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  private static JButton button = new JButton('111');", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.add(button);", "    button = new JButton('222');", "  }", "}");
        FieldReuseTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldReuseTest.assertTrue((boolean)(variableSupport instanceof FieldReuseVariableSupport));
        variableSupport.setName("firstButton");
        FieldReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        FieldReuseTest.assertAST(this.m_lastEditor);
        FieldReuseTest.assertEquals((Object)this.getTestSource("class Test {", "  private static JButton button;", "  private static JButton firstButton = new JButton('111');", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.add(firstButton);", "    button = new JButton('222');", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_setType() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton('button 1');", "    add(button);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldReuseVariableSupport variable = (FieldReuseVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  private JTextField button_1;", "  public Test() {", "    button_1 = new JButton('button 1');", "    add(button_1);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        variable = (FieldUniqueVariableSupport)button.getVariableSupport();
        FieldReuseTest.assertEquals((Object)"button_1", (Object)variable.getName());
    }
}

