/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateText;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class ObjectsLabelProviderTest
extends DesignerTestCase {
    private static final ImageDescriptor DEF_ICON = ImageDescriptor.createFromFile(Object.class, (String)"/javax/swing/plaf/basic/icons/JavaCup16.png");
    private static final ImageDescriptor DOWN_ICON = ImageDescriptor.createFromFile(Object.class, (String)"/javax/swing/plaf/metal/icons/sortDown.png");
    private static final String DEF_TEXT = "theObject";

    @Test
    public void test_default() throws Exception {
        MyObjectInfo theObject = new MyObjectInfo();
        ObjectsLabelProviderTest.assertSame((Object)DEF_ICON, (Object)ObjectInfo.getImageDescriptor((ObjectInfo)theObject));
        ObjectsLabelProviderTest.assertSame((Object)DEF_TEXT, (Object)ObjectInfo.getText((ObjectInfo)theObject));
    }

    @Test
    public void test_decorateImageText() throws Exception {
        MyObjectInfo theObject = new MyObjectInfo();
        theObject.addBroadcastListener(new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, ImageDescriptor[] icon) throws Exception {
                icon[0] = new DecorationOverlayIcon(icon[0], DOWN_ICON, 3);
            }
        });
        theObject.addBroadcastListener(new ObjectInfoPresentationDecorateText(){

            public void invoke(ObjectInfo object, String[] text) throws Exception {
                text[0] = "A: " + text[0] + " :B";
            }
        });
        ObjectsLabelProviderTest.assertNotSame((Object)DEF_ICON, (Object)ObjectInfo.getImageDescriptor((ObjectInfo)theObject));
        ObjectsLabelProviderTest.assertEquals((Object)"A: theObject :B", (Object)ObjectInfo.getText((ObjectInfo)theObject));
    }

    private static final class MyObjectInfo
    extends TestObjectInfo {
        private MyObjectInfo() {
        }

        @Override
        public IObjectPresentation getPresentation() {
            return new DefaultObjectPresentation(this){

                public ImageDescriptor getIcon() throws Exception {
                    return DEF_ICON;
                }

                public String getText() throws Exception {
                    return ObjectsLabelProviderTest.DEF_TEXT;
                }
            };
        }
    }
}

