/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.util.Lists;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringListPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.designer.tests.common.PropertyWithTitle;
import org.junit.jupiter.api.Test;

public class StringListPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_configure_valid() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        StringListPropertyEditor editor = this.createEditor(StringListPropertyEditor.class, parameters);
        this.assertEditorConfiguration(editor, parameters);
    }

    @Test
    public void test_configure_parameters() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        parameters.remove("strings");
        try {
            this.createEditor(StringListPropertyEditor.class, parameters);
            StringListPropertyEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_getValueSource() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        StringListPropertyEditor editor = this.createEditor(StringListPropertyEditor.class, parameters);
        StringListPropertyEditorTest.assertEquals((Object)"\"String_3\"", (Object)editor.getValueSource((Object)"String_3"));
    }

    @Test
    public void test_getClipboardSource() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        StringListPropertyEditor editor = this.createEditor(StringListPropertyEditor.class, parameters);
        StringListPropertyEditorTest.assert_getClipboardSource("\"String_2\"", (TextDisplayPropertyEditor)editor, new String("String_2"));
        StringListPropertyEditorTest.assert_getClipboardSource(null, (TextDisplayPropertyEditor)editor, null);
    }

    @Test
    public void test_getText() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        StringListPropertyEditor editor = this.createEditor(StringListPropertyEditor.class, parameters);
        StringListPropertyEditorTest.assert_getText("String_1", (TextDisplayPropertyEditor)editor, new String("String_1"));
        StringListPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)editor, null);
        String user_value = "user value";
        StringListPropertyEditorTest.assert_getText(user_value, (TextDisplayPropertyEditor)editor, user_value);
    }

    @Test
    public void test_ignoreCase() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        parameters.put("ignoreCase", new String("true"));
        StringListPropertyEditor editor = this.createEditor(StringListPropertyEditor.class, parameters);
        StringListPropertyEditorTest.assert_getText("String_1", (TextDisplayPropertyEditor)editor, new String("STRING_1"));
    }

    @Test
    public void test_setValue_simpleProperty() throws Exception {
        StringListPropertyEditor propertyEditor = new StringListPropertyEditor();
        propertyEditor.configure(new String[]{"A", "B", "C"});
        final AtomicReference valueSet = new AtomicReference();
        PropertyWithTitle property = new PropertyWithTitle((PropertyEditor)propertyEditor, "test"){

            @Override
            public void setValue(Object value) throws Exception {
                valueSet.set(value);
            }
        };
        StringListPropertyEditorTest.setComboPropertyValue(property, 1);
        StringListPropertyEditorTest.assertSame((Object)"B", valueSet.get());
    }

    @Test
    public void test_defaultValue() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"import javax.swing.JButton;", "class MyButton extends JButton {", "  public void setSelect(java.lang.String value) {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setSelect(java.lang.String)'>", "    <editor id='stringList'>", "      <parameter name='ignoreCase'>false</parameter>", "      <parameter-list name='strings'>default</parameter-list>", "      <parameter-list name='strings'>string</parameter-list>", "      <parameter-list name='strings'>value</parameter-list>", "    </editor>", "    <defaultValue value=\"'default'\"/>", "  </property>", "</component>"});
        StringListPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyButton button = new MyButton();", "    button.setSelect('string');", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("select");
        StringListPropertyEditorTest.assertEquals((Object)property.getValue(), (Object)"string");
        StringListPropertyEditorTest.assertEquals((Object)((GenericProperty)property).getDefaultValue(), (Object)"default");
        StringListPropertyEditorTest.setComboPropertyValue(property, 0);
        StringListPropertyEditorTest.assertEquals((Object)property.getValue(), (Object)"default");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
    }

    private Map<String, Object> getEditorParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ignoreCase", new String("false"));
        params.put("strings", Lists.newArrayList((Object[])new String[]{"String_1", "String_2", "String_3"}));
        return params;
    }

    private void assertEditorConfiguration(StringListPropertyEditor editor, Map<String, Object> parameters) throws Exception {
        StringListPropertyEditorTest.assertContainsOnly(editor, "m_strings", (List)parameters.get("strings"));
        StringListPropertyEditorTest.assertFalse((boolean)((Boolean)StringListPropertyEditorTest.getFieldValue(editor, "m_ignoreCase")));
    }
}

