/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.IntegerArrayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;

public class IntegerArrayPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getText() throws Exception {
        IntegerArrayPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)IntegerArrayPropertyEditor.INSTANCE, Property.UNKNOWN_VALUE);
        IntegerArrayPropertyEditorTest.assert_getText("1 2 3", (TextDisplayPropertyEditor)IntegerArrayPropertyEditor.INSTANCE, new int[]{1, 2, 3});
    }

    @Test
    public void test_getEditorText() throws Exception {
        IntegerArrayPropertyEditorTest.assert_getEditorText(null, (TextDisplayPropertyEditor)IntegerArrayPropertyEditor.INSTANCE, Property.UNKNOWN_VALUE);
        IntegerArrayPropertyEditorTest.assert_getEditorText("1 2 3", (TextDisplayPropertyEditor)IntegerArrayPropertyEditor.INSTANCE, new int[]{1, 2, 3});
    }

    @Test
    public void test_setEditorText_setValue() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        IntegerArrayPropertyEditorTest.setTextEditorText(property, "1 2 3");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(new int[] {1, 2, 3});", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_emptyString() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(1, 2, 3);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        IntegerArrayPropertyEditorTest.setTextEditorText(property, "");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_whitespaceString() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(1, 2, 3);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        IntegerArrayPropertyEditorTest.setTextEditorText(property, " ");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_invalidValue() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        final Property property = panel.getPropertyByTitle("foo");
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                IntegerArrayPropertyEditorTest.setTextEditorText(property, "notInteger");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("foo").bot();
                shell.button("OK").click();
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareIntegerPanel() throws Exception {
        IntegerArrayPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(int... foo) {", "  }", "}"));
        IntegerArrayPropertyEditorTest.waitForAutoBuild();
    }
}

