/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.assertj.core.api.Assertions;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.complex.InstanceObjectPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;

public class InstanceObjectPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_configure() throws Exception {
        block2: {
            this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
            Map<String, Object> parameters = this.getEditorParameters();
            this.createEditor(parameters);
            parameters.remove("source");
            this.createEditor(parameters);
            parameters.remove("class");
            parameters.put("source", "new javax.swing.AbstractButton() {}");
            try {
                this.createEditor(parameters);
                InstanceObjectPropertyEditorTest.fail();
            }
            catch (AssertionFailedException e) {
                if (e.getMessage().contains("'class'")) break block2;
                throw e;
            }
        }
    }

    @Test
    public void test_parse_noValue() throws Exception {
        this.configureContents();
        ContainerInfo container = this.parseContainer("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "  }", "}");
        Property property = container.getPropertyByTitle("property");
        InstanceObjectPropertyEditorTest.assertNotNull((Object)property);
        InstanceObjectPropertyEditorTest.assertNull((Object)InstanceObjectPropertyEditorTest.getPropertyText(property));
        InstanceObjectPropertyEditorTest.assertInstanceOf(InstanceObjectPropertyEditor.class, (Object)property.getEditor());
        InstanceObjectPropertyEditor editor = (InstanceObjectPropertyEditor)property.getEditor();
        InstanceObjectPropertyEditorTest.assertNull((Object)editor.getInstanceExpression(property));
        Assertions.assertThat((Object[])editor.getProperties(property)).isEmpty();
    }

    @Test
    public void test_parse_withValue() throws Exception {
        this.configureContents();
        ContainerInfo container = this.parseContainer("public class Test extends TestPanel {", "  public Test() {", "    setProperty(new JButton());", "  }", "}");
        Assertions.assertThat((List)container.getChildrenComponents()).hasSize(1);
        ComponentInfo childInfo = (ComponentInfo)container.getChildrenComponents().get(0);
        Property property = container.getPropertyByTitle("property");
        InstanceObjectPropertyEditorTest.assertNotNull((Object)property);
        InstanceObjectPropertyEditorTest.assertEquals((Object)InstanceObjectPropertyEditorTest.getPropertyText(property), (Object)"javax.swing.JButton");
        InstanceObjectPropertyEditorTest.assertInstanceOf(InstanceObjectPropertyEditor.class, (Object)property.getEditor());
        InstanceObjectPropertyEditor editor = (InstanceObjectPropertyEditor)property.getEditor();
        InstanceObjectPropertyEditorTest.assertNotNull((Object)editor.getInstanceExpression(property));
        Assertions.assertThat((Object[])editor.getProperties(property)).isNotEmpty();
        JavaInfo propertyInfo = editor.getInstanceInfo(property);
        InstanceObjectPropertyEditorTest.assertNotNull((Object)propertyInfo);
        InstanceObjectPropertyEditorTest.assertSame((Object)propertyInfo, (Object)childInfo);
    }

    @Test
    public void test_dialog() throws Exception {
        this.configureContents();
        ContainerInfo container = this.parseContainer("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat((List)container.getChildrenComponents()).hasSize(0);
        final Property property = container.getPropertyByTitle("property");
        InstanceObjectPropertyEditor editor = (InstanceObjectPropertyEditor)property.getEditor();
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                InstanceObjectPropertyEditorTest.openPropertyDialog(property);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                InstanceObjectPropertyEditorTest.animateOpenTypeSelection(bot, "JButton", "OK");
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "    setProperty(new JButton('New button'));", "  }", "}");
        InstanceObjectPropertyEditorTest.assertEquals((Object)"javax.swing.JButton", (Object)InstanceObjectPropertyEditorTest.getPropertyText(property));
        Assertions.assertThat((List)container.getChildrenComponents()).hasSize(1);
        InstanceObjectPropertyEditorTest.assertSame(container.getChildrenComponents().get(0), (Object)editor.getInstanceInfo(property));
    }

    @Test
    public void test_doubleClick() throws Exception {
        this.configureContents();
        ContainerInfo container = this.parseContainer("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat((List)container.getChildrenComponents()).hasSize(0);
        Property property = container.getPropertyByTitle("property");
        InstanceObjectPropertyEditor editor = (InstanceObjectPropertyEditor)property.getEditor();
        editor.doubleClick(property, null);
        this.assertEditor("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "    setProperty(", "            new AbstractButton() {", "            }", "            );", "  }", "}");
        InstanceObjectPropertyEditorTest.assertEquals((Object)"<anonymous>", (Object)InstanceObjectPropertyEditorTest.getPropertyText(property));
        Assertions.assertThat((List)container.getChildrenComponents()).isEmpty();
    }

    @Test
    public void test_restore_default() throws Exception {
        this.configureContents();
        ContainerInfo container = this.parseContainer("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "    setProperty(new JButton());", "  }", "}");
        Assertions.assertThat((List)container.getChildrenComponents()).hasSize(1);
        Property property = container.getPropertyByTitle("property");
        InstanceObjectPropertyEditor editor = (InstanceObjectPropertyEditor)property.getEditor();
        JavaInfo instanceInfo = editor.getInstanceInfo(property);
        InstanceObjectPropertyEditorTest.assertSame((Object)instanceInfo, container.getChildrenComponents().get(0));
        InstanceObjectPropertyEditor.installListenerForProperty((JavaInfo)instanceInfo);
        property.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat((List)container.getChildrenComponents()).isEmpty();
    }

    @Test
    public void test_sub_properties() throws Exception {
        this.configureContents();
        ContainerInfo container = this.parseContainer("public class Test extends TestPanel {", "  public Test() {", "    setProperty(new JButton());", "  }", "}");
        Property property = container.getPropertyByTitle("property");
        InstanceObjectPropertyEditor editor = (InstanceObjectPropertyEditor)property.getEditor();
        JavaInfo instanceInfo = editor.getInstanceInfo(property);
        Property subProperty = InstanceObjectPropertyEditorTest.getPropertyByTitle(editor.getProperties(property), "text");
        InstanceObjectPropertyEditorTest.assertSame((Object)subProperty, (Object)instanceInfo.getPropertyByTitle("text"));
        subProperty.setValue((Object)"value");
        this.assertEditor("public class Test extends TestPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText('value');", "    setProperty(button);", "  }", "}");
    }

    private Map<String, Object> getEditorParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("class", "");
        params.put("source", InstanceObjectPropertyEditorTest.getSourceDQ("new javax.swing.AbstractButton() {", "}"));
        return params;
    }

    protected InstanceObjectPropertyEditor createEditor(Map<String, Object> parameters) throws Exception {
        InstanceObjectPropertyEditor editor = new InstanceObjectPropertyEditor();
        editor.configure(this.m_lastState, parameters);
        return editor;
    }

    private void configureContents() throws Exception {
        this.setJavaContentSrc("test", "TestPanel", new String[]{"public class TestPanel extends JPanel {", "  public TestPanel(){", "  }", "  public void setProperty(AbstractButton value){", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setProperty'>", "      <parameter type='javax.swing.AbstractButton' child='true'/>", "    </method>", "  </methods>", "  <property id='setProperty(javax.swing.AbstractButton)'>", "    <editor id='instanceObject'>", "      <parameter name='class'>javax.swing.AbstractButton</parameter>", "      <parameter name='source'><![CDATA[", "        new javax.swing.AbstractButton() {", "        }", "        ]]></parameter>", "    </editor>", "  </property>", "</component>"});
        InstanceObjectPropertyEditorTest.waitForAutoBuild();
    }
}

