/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.hierarchy.ComponentClassProperty;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ComponentClassPropertyTest
extends SwingModelTest {
    @Test
    public void test_noForNullClass() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        ComponentClassPropertyTest.assertNull((Object)panel.getLayout().getPropertyByTitle("Class"));
    }

    @Test
    public void test_property() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentClassProperty property = (ComponentClassProperty)panel.getPropertyByTitle("Class");
        ComponentClassPropertyTest.assertNotNull((Object)property);
        ComponentClassPropertyTest.assertFalse((boolean)property.isModified());
        ComponentClassPropertyTest.assertTrue((boolean)property.getCategory().isSystem());
        ComponentClassPropertyTest.assertEquals((Object)"javax.swing.JPanel", (Object)property.getValue());
        property.setValue((Object)"can-not-set-value");
        ComponentClassPropertyTest.assertEquals((Object)"javax.swing.JPanel", (Object)property.getValue());
        property.setValue(null);
        ComponentClassPropertyTest.assertEquals((Object)"javax.swing.JPanel", (Object)property.getValue());
        ComponentClassPropertyTest.assertNull((Object)property.getAdapter(Object.class));
        PropertyTooltipProvider tooltipProvider = (PropertyTooltipProvider)property.getAdapter(PropertyTooltipProvider.class);
        ComponentClassPropertyTest.assertInstanceOf(PropertyTooltipTextProvider.class, (Object)tooltipProvider);
        ComponentClassPropertyTest.assertNotNull((Object)ReflectionUtils.invokeMethod((Object)tooltipProvider, (String)"getText(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property}));
        ComponentClassPropertyTest.assertEquals((Object)"javax.swing.JPanel", (Object)ComponentClassPropertyTest.getPropertyText((Property)property));
        ComponentClassPropertyTest.assertNotNull((Object)property.getEditor().getAdapter(PropertyTooltipProvider.class));
    }
}

