/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.preview.GenerationPreviewLocalUniqueBlock;
import org.eclipse.wb.internal.core.model.generation.preview.GenerationPreviewLocalUniqueFlat;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.flat.FlatStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.FieldInitializerVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class GenerationSettingsTest
extends SwingModelTest {
    private static final GenerationSettings SWING_SETTINGS = ToolkitProvider.DESCRIPTION.getGenerationSettings();

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_compatibleStatements() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenerationSettings settings = panel.getDescription().getToolkit().getGenerationSettings();
        VariableSupportDescription[] variables = settings.getVariables();
        GenerationSettingsTest.assertEquals((int)4, (int)variables.length);
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)variables[0]);
        GenerationSettingsTest.assertSame((Object)FieldUniqueVariableDescription.INSTANCE, (Object)variables[1]);
        GenerationSettingsTest.assertSame((Object)FieldInitializerVariableDescription.INSTANCE, (Object)variables[2]);
        GenerationSettingsTest.assertSame((Object)LazyVariableDescription.INSTANCE, (Object)variables[3]);
        StatementGeneratorDescription[] statements = settings.getStatements(variables[0]);
        GenerationSettingsTest.assertEquals((int)2, (int)statements.length);
        GenerationSettingsTest.assertSame((Object)FlatStatementGeneratorDescription.INSTANCE, (Object)statements[0]);
        GenerationSettingsTest.assertSame((Object)BlockStatementGeneratorDescription.INSTANCE, (Object)statements[1]);
        statements = settings.getStatements(variables[3]);
        GenerationSettingsTest.assertEquals((int)1, (int)statements.length);
        GenerationSettingsTest.assertSame((Object)LazyStatementGeneratorDescription.INSTANCE, (Object)statements[0]);
    }

    @Test
    public void test_getPreview() throws Exception {
        GenerationSettingsTest.assertInstanceOf(GenerationPreviewLocalUniqueFlat.class, (Object)SWING_SETTINGS.getPreview(LocalUniqueVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE));
        GenerationSettingsTest.assertInstanceOf(GenerationPreviewLocalUniqueBlock.class, (Object)SWING_SETTINGS.getPreview(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE));
    }

    @Test
    public void test_defaults() throws Exception {
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getDefaultVariable());
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable());
        GenerationSettingsTest.assertSame((Object)BlockStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getDefaultStatement());
        GenerationSettingsTest.assertSame((Object)BlockStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement());
        SWING_SETTINGS.setVariable(FieldUniqueVariableDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenerationSettingsTest.assertSame((Object)FieldUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
        GenerationSettingsTest.assertSame((Object)BlockStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_getVariable_useScript() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object newComponent = GenerationSettingsTest.createJavaInfo("javax.swing.JButton");
        GenerationSettingsTest.assertEquals((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable(newComponent));
        JavaInfoUtils.setParameter(newComponent, (String)"variable.validateID", (String)CodeUtils.getSource((String[])new String[]{"import org.eclipse.wb.internal.core.model.variable.description.*;", "return FieldUniqueVariableDescription.ID;"}));
        GenerationSettingsTest.assertEquals((Object)FieldUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable(newComponent));
        JavaInfoUtils.setParameter(newComponent, (String)"variable.validateID", null);
        GenerationSettingsTest.assertEquals((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable(newComponent));
    }

    @Test
    public void test_noDeduce_noComponents() throws Exception {
        SWING_SETTINGS.setVariable(FieldUniqueVariableDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenerationSettingsTest.assertSame((Object)FieldUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
    }

    @Test
    public void test_noDeduce_notEnoughComponents() throws Exception {
        SWING_SETTINGS.setVariable(FieldUniqueVariableDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('1');", "      add(button);", "    }", "    {", "      JButton button = new JButton('2');", "      add(button);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)FieldUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
    }

    @Test
    public void test_noDeduce_disabled() throws Exception {
        SWING_SETTINGS.setVariable(LazyVariableDescription.INSTANCE);
        SWING_SETTINGS.setStatement(LazyStatementGeneratorDescription.INSTANCE);
        SWING_SETTINGS.setDeduceSettings(false);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button_1 = new JButton('1');", "    add(button_1);", "    //", "    JButton button_2 = new JButton('2');", "    add(button_2);", "    //", "    JButton button_3 = new JButton('3');", "    add(button_3);", "  }", "}");
        GenerationSettingsTest.assertSame((Object)LazyVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
        GenerationSettingsTest.assertSame((Object)LazyStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_deduce_localUnique() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(FieldUniqueVariableDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('1');", "      add(button);", "    }", "    {", "      JButton button = new JButton('2');", "      add(button);", "    }", "    {", "      JButton button = new JButton('3');", "      add(button);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
    }

    @Test
    public void test_deduce_localUnique_block() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(LazyVariableDescription.INSTANCE);
        SWING_SETTINGS.setStatement(LazyStatementGeneratorDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
        GenerationSettingsTest.assertSame((Object)BlockStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_deduce_mixedBlockFlat_blockWins() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setStatement(LazyStatementGeneratorDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button_1 = new JButton();", "      JButton button_2 = new JButton();", "      add(button_1);", "      add(button_2);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)BlockStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_deduce_mixedBlockFlat_flatWins() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setStatement(LazyStatementGeneratorDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button_1 = new JButton();", "      JButton button_2 = new JButton();", "      JButton button_3 = new JButton();", "      JButton button_4 = new JButton();", "      add(button_1);", "      add(button_2);", "      add(button_3);", "      add(button_4);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)FlatStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_deduce_localUnique_flat() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(LazyVariableDescription.INSTANCE);
        SWING_SETTINGS.setStatement(LazyStatementGeneratorDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "    //", "    JButton button_3 = new JButton();", "    add(button_3);", "  }", "}");
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
        GenerationSettingsTest.assertSame((Object)FlatStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_deduce_localUnique2() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(FieldUniqueVariableDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button_1;", "  public Test() {", "    {", "      button_1 = new JButton('1');", "      add(button_1);", "    }", "    {", "      JButton button = new JButton('2');", "      add(button);", "    }", "    {", "      JButton button = new JButton('3');", "      add(button);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
    }

    @Test
    public void test_deduce_fieldWithInitializer() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(FieldUniqueVariableDescription.INSTANCE);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_1 = new JButton('1');", "  private final JButton button_2 = new JButton('2');", "  private final JButton button_3 = new JButton('3');", "  public Test() {", "    {", "      add(button_1);", "    }", "    {", "      add(button_2);", "    }", "    {", "      add(button_3);", "    }", "    {", "      JButton button = new JButton('4');", "      add(button);", "    }", "  }", "}");
        GenerationSettingsTest.assertSame((Object)FieldInitializerVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
    }

    @Test
    public void test_deduce_lazy() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(LocalUniqueVariableDescription.INSTANCE);
        SWING_SETTINGS.setStatement(FlatStatementGeneratorDescription.INSTANCE);
        String[] lines = new String[]{"public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  private JButton button_3;", "  public Test() {", "    add(getButton_1());", "    add(getButton_2());", "    add(getButton_3());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton();", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton();", "    }", "    return button_2;", "  }", "  private JButton getButton_3() {", "    if (button_3 == null) {", "      button_3 = new JButton();", "    }", "    return button_3;", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        GenerationSettingsTest.assertSame((Object)LazyVariableDescription.INSTANCE, (Object)SWING_SETTINGS.getVariable((JavaInfo)panel));
        GenerationSettingsTest.assertSame((Object)LazyStatementGeneratorDescription.INSTANCE, (Object)SWING_SETTINGS.getStatement((JavaInfo)panel));
    }

    @Test
    public void test_deduce_nullComponentClass() throws Exception {
        SWING_SETTINGS.setDeduceSettings(true);
        SWING_SETTINGS.setVariable(LocalUniqueVariableDescription.INSTANCE);
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        AbsoluteLayoutInfo componentNull = AbsoluteLayoutInfo.createExplicit((AstEditor)this.m_lastEditor);
        SWING_SETTINGS.getVariable((JavaInfo)componentNull);
    }
}

