/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.operations;

import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class DeleteTest
extends SwingModelTest {
    @Test
    public void test_exposedProperty() throws Exception {
        ContainerInfo frame = this.parseContainer("public final class Test extends JFrame {", "  public Test() {", "    getContentPane().setEnabled(false);", "    setTitle('My frame');", "    //", "    JButton button = new JButton();", "    getContentPane().add(button);", "  }", "}");
        DeleteTest.assertEquals((int)1, (int)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        DeleteTest.assertTrue((boolean)contentPane.canDelete());
        contentPane.delete();
        this.assertEditor("public final class Test extends JFrame {", "  public Test() {", "    setTitle('My frame');", "  }", "}");
        DeleteTest.assertEquals((int)1, (int)frame.getChildrenComponents().size());
        DeleteTest.assertTrue((boolean)contentPane.getChildrenComponents().isEmpty());
    }

    @Test
    public void test_withChildren() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "    JPanel innerPanel = new JPanel();", "    add(innerPanel);", "    //", "    JButton button = new JButton();", "    innerPanel.add(button);", "  }", "}");
        ComponentInfo innerPanel = (ComponentInfo)panel.getChildrenComponents().get(0);
        DeleteTest.assertTrue((boolean)innerPanel.canDelete());
        innerPanel.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        DeleteTest.assertTrue((boolean)panel.getChildrenComponents().isEmpty());
    }

    @Test
    public void test_withExposedChildren() throws Exception {
        DeleteTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button;", "  public MyPanel() {", "    m_button = new JButton();", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        DeleteTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "}", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        DeleteTest.assertEquals((int)1, (int)myPanel.getChildrenComponents().size());
        ComponentInfo exposedButton = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        DeleteTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)exposedButton.getCreationSupport());
        DeleteTest.assertTrue((boolean)myPanel.canDelete());
        myPanel.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "}", "}");
        DeleteTest.assertTrue((boolean)panel.getChildrenComponents().isEmpty());
    }
}

