/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import javax.swing.JToolBar;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarSeparatorCreationSupport;
import org.eclipse.wb.internal.swing.model.component.JToolBarSeparatorInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class InvocationVoidAssociationTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(0);
        InvocationVoidAssociation association = (InvocationVoidAssociation)separator.getAssociation();
        InvocationVoidAssociationTest.assertSame((Object)separator, (Object)association.getJavaInfo());
        InvocationVoidAssociationTest.assertEquals((Object)"bar.addSeparator()", (Object)association.getSource());
        InvocationVoidAssociationTest.assertEquals((Object)"bar.addSeparator()", (Object)this.m_lastEditor.getSource((ASTNode)association.getInvocation()));
        InvocationVoidAssociationTest.assertEquals((Object)"bar.addSeparator();", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(0);
        InvocationVoidAssociationTest.assertTrue((boolean)separator.canDelete());
        separator.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
    }

    @Test
    public void test_add() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorCreationSupport creationSupport = new JToolBarSeparatorCreationSupport((JavaInfo)bar);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JToolBar.Separator.class, (CreationSupport)creationSupport);
        bar.command_CREATE(separator, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
        InvocationVoidAssociationTest.assertEquals((Object)"void", (Object)creationSupport.toString());
        InvocationVoidAssociation association = (InvocationVoidAssociation)separator.getAssociation();
        InvocationVoidAssociationTest.assertSame((Object)separator, (Object)association.getJavaInfo());
        InvocationVoidAssociationTest.assertEquals((Object)"bar.addSeparator()", (Object)association.getSource());
    }

    @Test
    public void test_moveInner() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(1);
        bar.command_MOVE((ComponentInfo)separator, button);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "  }", "}");
        InvocationVoidAssociation association = (InvocationVoidAssociation)separator.getAssociation();
        InvocationVoidAssociationTest.assertSame((Object)separator, (Object)association.getJavaInfo());
        InvocationVoidAssociationTest.assertEquals((Object)"bar.addSeparator()", (Object)association.getSource());
    }

    @Test
    public void test_moveInner_lazy() throws Exception {
        InvocationVoidAssociationTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JButton addButton() {", "    JButton button = new JButton();", "    add(button);", "    return button;", "  }", "}"));
        InvocationVoidAssociationTest.setFileContentSrc("test/MyBar.wbp-component.xml", InvocationVoidAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationVoidAssociationTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends JPanel {", "  private MyBar bar;", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getBar());", "  }", "  private MyBar getBar() {", "    if (bar == null) {", "      bar = new MyBar();", "      getButton_1();", "      getButton_2();", "    }", "    return bar;", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = bar.addButton();", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = bar.addButton();", "    }", "    return button_2;", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        InvocationVoidAssociationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getBar())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {lazy: bar getBar()} {/new MyBar()/ /bar.addButton()/ /bar.addButton()/ /bar/ /add(getBar())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {implicit-factory} {lazy: button_1 getButton_1()} {/bar.addButton()/ /button_1/ /getButton_1()/}", "    {implicit-factory} {lazy: button_2 getButton_2()} {/bar.addButton()/ /button_2/ /getButton_2()/}");
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)bar.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)bar.getChildrenComponents().get(1);
        InvocationVoidAssociationTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)button_2.getAssociation());
        JavaInfoUtils.move((JavaInfo)button_2, null, (JavaInfo)bar, (JavaInfo)button_1);
        this.assertEditor("public class Test extends JPanel {", "  private MyBar bar;", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getBar());", "  }", "  private MyBar getBar() {", "    if (bar == null) {", "      bar = new MyBar();", "      getButton_2();", "      getButton_1();", "    }", "    return bar;", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = bar.addButton();", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = bar.addButton();", "    }", "    return button_2;", "  }", "}");
    }
}

