/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.util.MorphingSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CompoundAssociationTest
extends SwingModelTest {
    @Test
    public void test_morph() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    MyButton myButton = new MyButton(myPanel);", "    myPanel.setMyChild(myButton);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo myButton = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        Class<?> clazz = EditorState.get((AstEditor)this.m_lastEditor).getEditorLoader().loadClass("test.MyButton2");
        MorphingSupport.morph((String)"java.awt.Container", (JavaInfo)myButton, (MorphingTargetDescription)new MorphingTargetDescription(clazz, null));
        myButton = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton.getAssociation();
        CompoundAssociationTest.assertSame((Object)myButton, (Object)compoundAssociation.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton2(myPanel)", (Object)compoundAssociation.getSource());
        CompoundAssociationTest.assertEquals((Object)"MyButton2 myButton = new MyButton2(myPanel);", (Object)this.m_lastEditor.getSource((ASTNode)compoundAssociation.getStatement()));
        List associations = compoundAssociation.getAssociations();
        Assertions.assertThat((List)associations).hasSize(2);
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton2(myPanel)", (Object)association.getSource());
        CompoundAssociationTest.assertEquals((Object)"MyButton2 myButton = new MyButton2(myPanel);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        association = (InvocationChildAssociation)associations.get(1);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"myPanel.setMyChild(myButton)", (Object)association.getSource());
        CompoundAssociationTest.assertEquals((Object)"myPanel.setMyChild(myButton);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
    }

    @Test
    public void test_parse() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    MyButton myButton = new MyButton(myPanel);", "    myPanel.setMyChild(myButton);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo myButton = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton.getAssociation();
        CompoundAssociationTest.assertSame((Object)myButton, (Object)compoundAssociation.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton(myPanel)", (Object)compoundAssociation.getSource());
        CompoundAssociationTest.assertEquals((Object)"MyButton myButton = new MyButton(myPanel);", (Object)this.m_lastEditor.getSource((ASTNode)compoundAssociation.getStatement()));
        List associations = compoundAssociation.getAssociations();
        CompoundAssociationTest.assertEquals((int)2, (int)associations.size());
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton(myPanel)", (Object)association.getSource());
        CompoundAssociationTest.assertEquals((Object)"MyButton myButton = new MyButton(myPanel);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        association = (InvocationChildAssociation)associations.get(1);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"myPanel.setMyChild(myButton)", (Object)association.getSource());
        CompoundAssociationTest.assertEquals((Object)"myPanel.setMyChild(myButton);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
    }

    @Test
    public void test_create() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo myButton = CompoundAssociationTest.createComponent("test.MyButton");
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.setMyChild(%child%)", (boolean)true);
        JavaInfoUtils.add((JavaInfo)myButton, (AssociationObject)associationObject, (JavaInfo)myPanel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    {", "      MyButton myButton = new MyButton(myPanel);", "      myPanel.setMyChild(myButton);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton.getAssociation();
        List associations = compoundAssociation.getAssociations();
        Assertions.assertThat((List)associations).hasSize(2);
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton(myPanel)", (Object)association.getSource());
        CompoundAssociationTest.assertEquals((Object)"MyButton myButton = new MyButton(myPanel);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        association = (InvocationChildAssociation)associations.get(1);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"myPanel.setMyChild(myButton)", (Object)association.getSource());
        CompoundAssociationTest.assertEquals((Object)"myPanel.setMyChild(myButton);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
    }

    @Test
    public void test_canNotDelete() throws Exception {
        Association association_1 = (Association)Mockito.mock(Association.class);
        Association association_2 = (Association)Mockito.mock(Association.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{association_1, association_2});
        Mockito.when((Object)association_1.canDelete()).thenReturn((Object)true);
        CompoundAssociation compoundAssociation = new CompoundAssociation(new Association[]{association_1, association_2});
        CompoundAssociationTest.assertFalse((boolean)compoundAssociation.canDelete());
        ((Association)inOrder.verify((Object)association_1)).canDelete();
        ((Association)inOrder.verify((Object)association_2)).canDelete();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_canDelete() throws Exception {
        Association association_1 = (Association)Mockito.mock(Association.class);
        Association association_2 = (Association)Mockito.mock(Association.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{association_1, association_2});
        Mockito.when((Object)association_1.canDelete()).thenReturn((Object)true);
        Mockito.when((Object)association_2.canDelete()).thenReturn((Object)true);
        CompoundAssociation compoundAssociation = new CompoundAssociation(new Association[]{association_1, association_2});
        CompoundAssociationTest.assertTrue((boolean)compoundAssociation.canDelete());
        ((Association)inOrder.verify((Object)association_1)).canDelete();
        ((Association)inOrder.verify((Object)association_2)).canDelete();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_delete() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    MyButton myButton = new MyButton(myPanel);", "    myPanel.setMyChild(myButton);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo myButton = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        CompoundAssociationTest.assertTrue((boolean)myButton.canDelete());
        myButton.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "  }", "}");
    }

    @Test
    public void test_removeAll() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Association association_1 = (Association)Mockito.mock(Association.class);
        Association association_2 = (Association)Mockito.mock(Association.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{association_1, association_2});
        CompoundAssociation compoundAssociation = new CompoundAssociation(new Association[]{association_1, association_2});
        panel.setAssociation((Association)compoundAssociation);
        Mockito.when((Object)association_1.remove()).thenReturn((Object)true);
        Mockito.when((Object)association_2.remove()).thenReturn((Object)true);
        CompoundAssociationTest.assertTrue((boolean)compoundAssociation.remove());
        CompoundAssociationTest.assertNull((Object)panel.getAssociation());
        ((Association)inOrder.verify((Object)association_1)).remove();
        ((Association)inOrder.verify((Object)association_2)).remove();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_moveInner() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    {", "      MyButton myButton_1 = new MyButton(myPanel);", "      myPanel.setMyChild(myButton_1);", "    }", "    {", "      MyButton myButton_2 = new MyButton(myPanel);", "      myPanel.setMyChild(myButton_2);", "    }", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo myButton_1 = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        ComponentInfo myButton_2 = (ComponentInfo)myPanel.getChildrenComponents().get(1);
        ((FlowLayoutInfo)myPanel.getLayout()).move(myButton_2, myButton_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    {", "      MyButton myButton_2 = new MyButton(myPanel);", "      myPanel.setMyChild(myButton_2);", "    }", "    {", "      MyButton myButton_1 = new MyButton(myPanel);", "      myPanel.setMyChild(myButton_1);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton_2.getAssociation();
        for (Association association : compoundAssociation.getAssociations()) {
            CompoundAssociationTest.assertSame((Object)myButton_2, (Object)association.getJavaInfo());
        }
    }

    @Test
    public void test_moveReparent() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel_1 = new MyPanel();", "    add(myPanel_1);", "    {", "      MyButton myButton = new MyButton(myPanel_1);", "      myPanel_1.setMyChild(myButton);", "    }", "    //", "    MyPanel myPanel_2 = new MyPanel();", "    add(myPanel_2);", "  }", "}");
        ContainerInfo myPanel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo myPanel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        ComponentInfo myButton = (ComponentInfo)myPanel_1.getChildrenComponents().get(0);
        AssociationObject newAssociation = AssociationObjects.invocationChild((String)"%parent%.setMyChild(%child%)", (boolean)true);
        JavaInfoUtils.move((JavaInfo)myButton, (AssociationObject)newAssociation, (JavaInfo)myPanel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel_1 = new MyPanel();", "    add(myPanel_1);", "    //", "    MyPanel myPanel_2 = new MyPanel();", "    add(myPanel_2);", "    {", "      MyButton myButton = new MyButton(myPanel_2);", "      myPanel_2.setMyChild(myButton);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton.getAssociation();
        List associations = compoundAssociation.getAssociations();
        CompoundAssociationTest.assertEquals((int)2, (int)associations.size());
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton(myPanel_2)", (Object)association.getSource());
        association = (InvocationChildAssociation)associations.get(1);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"myPanel_2.setMyChild(myButton)", (Object)association.getSource());
    }

    @Test
    public void test_moveReparentFromNormalContainer() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPanel panel_1 = new JPanel();", "    add(panel_1);", "    {", "      MyButton myButton = new MyButton(panel_1);", "    }", "    //", "    MyPanel myPanel_2 = new MyPanel();", "    add(myPanel_2);", "  }", "}");
        ContainerInfo myPanel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo myPanel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        ComponentInfo myButton = (ComponentInfo)myPanel_1.getChildrenComponents().get(0);
        AssociationObject newAssociation = AssociationObjects.invocationChild((String)"%parent%.setMyChild(%child%)", (boolean)true);
        JavaInfoUtils.move((JavaInfo)myButton, (AssociationObject)newAssociation, (JavaInfo)myPanel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JPanel panel_1 = new JPanel();", "    add(panel_1);", "    //", "    MyPanel myPanel_2 = new MyPanel();", "    add(myPanel_2);", "    {", "      MyButton myButton = new MyButton(myPanel_2);", "      myPanel_2.setMyChild(myButton);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)myButton.getAssociation();
        List associations = compoundAssociation.getAssociations();
        CompoundAssociationTest.assertEquals((int)2, (int)associations.size());
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"new MyButton(myPanel_2)", (Object)association.getSource());
        association = (InvocationChildAssociation)associations.get(1);
        CompoundAssociationTest.assertSame((Object)myButton, (Object)association.getJavaInfo());
        CompoundAssociationTest.assertEquals((Object)"myPanel_2.setMyChild(myButton)", (Object)association.getSource());
    }

    private void configureProject() throws Exception {
        CompoundAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setMyChild(Component child) {", "  }", "}"));
        CompoundAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", CompoundAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- METHODS -->", "  <methods>", "    <method name='setMyChild'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        CompoundAssociationTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container parent) {", "  }", "}"));
        CompoundAssociationTest.setFileContentSrc("test/MyButton.wbp-component.xml", CompoundAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        CompoundAssociationTest.setFileContentSrc("test/MyButton2.java", this.getTestSource("public class MyButton2 extends JButton {", "  public MyButton2(Container parent) {", "  }", "}"));
        CompoundAssociationTest.setFileContentSrc("test/MyButton2.wbp-component.xml", CompoundAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton2(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        CompoundAssociationTest.waitForAutoBuild();
    }
}

