/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;

public final class ImageUtils {
    @Deprecated
    public static byte[] getBytesPNG(org.eclipse.swt.graphics.Image image) throws IOException {
        return ImageUtils.getBytesPNG(image.getImageData());
    }

    public static byte[] getBytesPNG(ImageDescriptor image) throws IOException {
        return ImageUtils.getBytesPNG(image.getImageData(100));
    }

    private static byte[] getBytesPNG(ImageData imageData) throws IOException {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)baos, 5);
        return baos.toByteArray();
    }

    public static ImageDescriptor convertToSWT(Image awtImage) {
        return ExecutionUtils.runObject(() -> {
            BufferedImage bufferedImage = ImageUtils.getBufferedImage(awtImage);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", os);
            return ImageDescriptor.createFromImageDataProvider(zoom -> zoom == 100 ? new ImageData((InputStream)new ByteArrayInputStream(os.toByteArray())) : null);
        });
    }

    private static BufferedImage getBufferedImage(Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            ImageUtils.waitForImage(image);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w == -1 && h == -1) {
                w = 32;
                h = 32;
            }
            bufferedImage = new BufferedImage(w, h, 2);
            Graphics2D g2 = bufferedImage.createGraphics();
            g2.drawImage(image, 0, 0, null);
            g2.dispose();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        Object done = new Object();
        ImageObserver imageObserver = (img, flags, x, y, width, height) -> {
            if (flags < 32) {
                return true;
            }
            Object object2 = done;
            synchronized (object2) {
                done.notify();
            }
            return false;
        };
        Object object = done;
        synchronized (object) {
            boolean completelyLoaded = g2.drawImage(image, 0, 0, imageObserver);
            if (!completelyLoaded) {
                while (true) {
                    try {
                        done.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        g2.dispose();
    }

    public static ImageDescriptor convertToSWT(Icon icon) {
        int width = Math.max(1, icon.getIconWidth());
        int height = Math.max(1, icon.getIconHeight());
        BufferedImage awtImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = awtImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return ImageUtils.convertToSWT(awtImage);
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask, data.alphaData == null ? 0 : -16777216);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[4];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    pixelArray[3] = data.alphaData != null ? data.getAlpha(x, y) : 255;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }
}

