/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.controls.Messages;

public class CSpinner
extends Composite {
    private static final Color COLOR_VALID = Display.getCurrent().getSystemColor(25);
    private static final Color COLOR_INVALID = new Color(null, 255, 230, 230);
    private int m_minimum = 0;
    private int m_maximum = 100;
    private int m_increment = 1;
    private int m_value = 0;
    private int m_multiplier = 1;
    private String m_formatPattern = "0";
    private DecimalFormat m_format = new DecimalFormat(this.m_formatPattern);
    private final Button m_button = new Button((Composite)this, 1028);
    private final Text m_text;
    private final Spinner m_spinner;
    private Composite win32Hack;
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_VERSION = System.getProperty("os.version");
    private static final String WS_TYPE = SWT.getPlatform();
    private static final boolean IS_OS_MAC_OSX = CSpinner.isOS("Mac OS X");
    private static final boolean IS_OS_MAC_OSX_COCOA = IS_OS_MAC_OSX && "cocoa".equals(WS_TYPE);
    private static final boolean IS_OS_LINUX = CSpinner.isOS("Linux") || CSpinner.isOS("LINUX");
    private static final boolean IS_OS_WINDOWS_XP = CSpinner.isWindowsVersion("5.1");
    private static final boolean IS_OS_WINDOWS_2003 = CSpinner.isWindowsVersion("5.2");
    private static final boolean IS_OS_WINDOWS_VISTA = CSpinner.isWindowsVersion("6.0");
    private static final boolean IS_OS_WINDOWS_7 = CSpinner.isWindowsVersion("6.1");

    public CSpinner(Composite parent, int style) {
        super(parent, style);
        int textStyle = 131076;
        if (IS_OS_MAC_OSX_COCOA) {
            textStyle |= 0x800;
        }
        this.m_text = new Text((Composite)this, textStyle);
        this.m_text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    e.doit = false;
                    CSpinner.this.updateValue(e.keyCode);
                }
            }

            public void keyReleased(KeyEvent e) {
                try {
                    CSpinner.this.m_value = (int)(CSpinner.this.m_format.parse(CSpinner.this.m_text.getText()).doubleValue() * (double)CSpinner.this.m_multiplier);
                    if (CSpinner.this.m_value < CSpinner.this.m_minimum || CSpinner.this.m_value > CSpinner.this.m_maximum) {
                        CSpinner.this.m_text.setBackground(COLOR_INVALID);
                        CSpinner.this.setState(MessageFormat.format(Messages.CSpinner_outOfRange, CSpinner.this.m_value, CSpinner.this.m_minimum, CSpinner.this.m_maximum));
                        CSpinner.this.notifySelectionListeners(false);
                    } else {
                        CSpinner.this.setState(null);
                        CSpinner.this.notifySelectionListeners(true);
                    }
                }
                catch (ParseException ex) {
                    CSpinner.this.setState(MessageFormat.format(Messages.CSpinner_canNotParse, CSpinner.this.m_text.getText(), CSpinner.this.m_formatPattern));
                    CSpinner.this.notifySelectionListeners(false);
                }
            }
        });
        if (!IS_OS_MAC_OSX) {
            this.win32Hack = new Composite((Composite)this, 0);
            this.win32Hack.setBackground(this.getDisplay().getSystemColor(1));
            this.win32Hack.moveAbove(null);
            this.win32Hack.moveBelow((Control)this.m_text);
        }
        this.m_spinner = new Spinner((Composite)this, 512);
        this.m_spinner.setMinimum(0);
        this.m_spinner.setMaximum(50);
        this.m_spinner.setIncrement(1);
        this.m_spinner.setPageIncrement(1);
        this.m_spinner.setSelection(25);
        this.m_spinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CSpinner.this.setFocus();
            }
        });
        this.m_spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSpinner.this.m_text.forceFocus();
                if (CSpinner.this.m_spinner.getSelection() > 25) {
                    CSpinner.this.updateValue(0x1000001);
                } else {
                    CSpinner.this.updateValue(0x1000002);
                }
                CSpinner.this.m_spinner.setSelection(25);
            }
        });
        this.setBackground(this.getDisplay().getSystemColor(1));
        if (IS_OS_WINDOWS_XP || IS_OS_WINDOWS_2003) {
            this.setLayout(new WindowsXpLayout());
        } else if (IS_OS_WINDOWS_VISTA || IS_OS_WINDOWS_7) {
            this.setLayout(new WindowsVistaLayout());
        } else if (IS_OS_LINUX) {
            this.setLayout(new LinuxLayout());
        } else if (IS_OS_MAC_OSX) {
            if (IS_OS_MAC_OSX_COCOA) {
                this.setLayout(new MacCocoaLayout());
            } else {
                this.setLayout(new MacLayout());
            }
        } else {
            this.setLayout(new WindowsXpLayout());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
        this.m_spinner.setEnabled(enabled);
    }

    public void setDigits(int digits) {
        this.m_formatPattern = "0.";
        this.m_multiplier = 1;
        int i = 0;
        while (i < digits) {
            this.m_formatPattern = String.valueOf(this.m_formatPattern) + "0";
            this.m_multiplier *= 10;
            ++i;
        }
        this.m_format = new DecimalFormat(this.m_formatPattern);
        this.updateText();
    }

    public void setRange(int minimum, int maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public int getMinimum() {
        return this.m_minimum;
    }

    public void setMinimum(int minimum) {
        this.m_minimum = minimum;
        this.setSelection(Math.max(this.m_value, this.m_minimum));
    }

    public void setMaximum(int maximum) {
        this.m_maximum = maximum;
        this.setSelection(Math.min(this.m_value, this.m_maximum));
    }

    public void setIncrement(int increment) {
        this.m_increment = increment;
    }

    public void setSelection(int newValue) {
        if ((newValue = Math.min(Math.max(this.m_minimum, newValue), this.m_maximum)) != this.m_value || this.m_text.getText().length() == 0) {
            this.m_value = newValue;
            this.updateText();
            this.setState(null);
        }
    }

    private void updateText() {
        String text = this.m_format.format((double)this.m_value / (double)this.m_multiplier);
        this.m_text.setText(text);
        this.m_text.selectAll();
    }

    public int getSelection() {
        return this.m_value;
    }

    private void updateValue(int direction) {
        int newValue = this.m_value;
        if (direction == 0x1000001) {
            newValue += this.m_increment;
        }
        if (direction == 0x1000002) {
            newValue -= this.m_increment;
        }
        this.setSelection(newValue);
        this.notifySelectionListeners(true);
    }

    private void setState(String message) {
        this.m_text.setToolTipText(message);
        if (message == null) {
            this.m_text.setBackground(COLOR_VALID);
        } else {
            this.m_text.setBackground(COLOR_INVALID);
        }
    }

    private void notifySelectionListeners(boolean valid) {
        Event event = new Event();
        event.detail = this.m_value;
        event.doit = valid;
        this.notifyListeners(13, event);
    }

    private static boolean isOS(String osName) {
        return OS_NAME != null && OS_NAME.startsWith(osName);
    }

    private static boolean isWindowsVersion(String windowsVersion) {
        return CSpinner.isOS("Windows") && OS_VERSION != null && OS_VERSION.startsWith(windowsVersion);
    }

    private class LinuxLayout
    extends Layout {
        private LinuxLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = CSpinner.this.m_text.computeSize(-1, -1);
            size.x += CSpinner.this.m_spinner.computeSize((int)-1, (int)-1).x - CSpinner.this.m_spinner.getClientArea().width;
            if (wHint != -1) {
                size.x = Math.min(size.x, wHint);
            }
            if (hHint != -1) {
                size.y = Math.min(size.y, hHint);
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle cRect = composite.getClientArea();
            if (cRect.isEmpty()) {
                return;
            }
            Point tSize = CSpinner.this.m_text.computeSize(-1, -1);
            Point sSize = CSpinner.this.m_spinner.computeSize(-1, -1, flushCache);
            sSize.y = Math.min(sSize.y, Math.min(tSize.y, cRect.height));
            sSize.x = Math.min(sSize.x, cRect.width);
            CSpinner.this.m_spinner.setSize(sSize);
            int arrowWidth = sSize.x - CSpinner.this.m_spinner.getClientArea().width;
            CSpinner.this.m_spinner.setBounds(cRect.x + cRect.width - sSize.x, cRect.y - 2, sSize.x, cRect.height + 4);
            CSpinner.this.m_text.setBounds(cRect.x, cRect.y, cRect.width - arrowWidth, tSize.y);
        }
    }

    private class MacCocoaLayout
    extends Layout {
        private MacCocoaLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point textSize = CSpinner.this.m_text.computeSize(-1, -1);
            Point spinnerSize = CSpinner.this.m_spinner.computeSize(-1, -1);
            int arrowWidth = CSpinner.this.m_button.computeSize((int)-1, (int)-1).x;
            int width = textSize.x + arrowWidth;
            int height = Math.max(spinnerSize.y, textSize.y);
            if (wHint != -1) {
                width = Math.min(width, wHint);
            }
            if (hHint != -1) {
                height = Math.min(height, hHint);
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            if (clientArea.isEmpty()) {
                return;
            }
            Point spinnerSize = CSpinner.this.m_spinner.computeSize(-1, -1, flushCache);
            int arrowWidth = CSpinner.this.m_button.computeSize((int)-1, (int)-1).x;
            CSpinner.this.m_spinner.setBounds(clientArea.x + clientArea.width - arrowWidth - 1, clientArea.y + clientArea.height - spinnerSize.y, arrowWidth + 2, spinnerSize.y);
            CSpinner.this.m_text.setBounds(clientArea.x + 2, clientArea.y + 2, clientArea.width - arrowWidth - 5, clientArea.y + clientArea.height - 4);
        }
    }

    private class MacLayout
    extends Layout {
        private MacLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = CSpinner.this.m_text.computeSize(-1, -1);
            size.x += CSpinner.this.m_spinner.computeSize((int)-1, (int)-1).x - CSpinner.this.m_spinner.getClientArea().width;
            size.y += 4;
            if (wHint != -1) {
                size.x = Math.min(size.x, wHint);
            }
            if (hHint != -1) {
                size.y = Math.min(size.y, hHint);
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle cRect = composite.getClientArea();
            if (cRect.isEmpty()) {
                return;
            }
            Point tSize = CSpinner.this.m_text.computeSize(-1, -1);
            tSize.y += 4;
            Point sSize = CSpinner.this.m_spinner.computeSize(-1, -1, flushCache);
            sSize.y = Math.min(sSize.y, Math.min(tSize.y, cRect.height));
            sSize.x = Math.min(sSize.x, cRect.width);
            int arrowWidth = CSpinner.this.m_button.computeSize((int)-1, (int)-1).x;
            CSpinner.this.m_spinner.setBounds(cRect.x + cRect.width - sSize.x, cRect.y, sSize.x, cRect.height);
            CSpinner.this.m_text.setBounds(cRect.x, cRect.y + 2, cRect.width - arrowWidth - 2, tSize.y);
        }
    }

    private class WindowsVistaLayout
    extends Layout {
        private WindowsVistaLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = CSpinner.this.m_text.computeSize(-1, -1);
            size.x += CSpinner.this.m_spinner.computeSize((int)-1, (int)-1).x - CSpinner.this.m_spinner.getClientArea().width;
            size.y += 3;
            if (wHint != -1) {
                size.x = Math.min(size.x, wHint);
            }
            if (hHint != -1) {
                size.y = Math.min(size.y, hHint);
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle cRect = composite.getClientArea();
            if (cRect.isEmpty()) {
                return;
            }
            Point tSize = CSpinner.this.m_text.computeSize(-1, -1);
            Point sSize = CSpinner.this.m_spinner.computeSize(-1, -1, flushCache);
            sSize.y = Math.min(sSize.y, Math.min(tSize.y, cRect.height));
            sSize.x = Math.min(sSize.x, cRect.width);
            int arrowWidth = CSpinner.this.m_button.computeSize((int)-1, (int)-1).x;
            CSpinner.this.m_spinner.setBounds(cRect.x + cRect.width - sSize.x + 1, cRect.y - 1, sSize.x, cRect.height + 2);
            CSpinner.this.m_text.setBounds(cRect.x, cRect.y + 1, cRect.width - arrowWidth, tSize.y);
            CSpinner.this.win32Hack.setBounds(cRect.x, cRect.y, cRect.width - arrowWidth, sSize.y);
        }
    }

    private class WindowsXpLayout
    extends Layout {
        private WindowsXpLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = CSpinner.this.m_text.computeSize(-1, -1);
            size.x += CSpinner.this.m_spinner.computeSize((int)-1, (int)-1).x - CSpinner.this.m_spinner.getClientArea().width;
            size.y += 2;
            if (wHint != -1) {
                size.x = Math.min(size.x, wHint);
            }
            if (hHint != -1) {
                size.y = Math.min(size.y, hHint);
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle cRect = composite.getClientArea();
            if (cRect.isEmpty()) {
                return;
            }
            Point tSize = CSpinner.this.m_text.computeSize(-1, -1);
            Point sSize = CSpinner.this.m_spinner.computeSize(-1, -1, flushCache);
            sSize.y = Math.min(sSize.y, Math.min(tSize.y, cRect.height));
            sSize.x = Math.min(sSize.x, cRect.width);
            int arrowWidth = CSpinner.this.m_button.computeSize((int)-1, (int)-1).x;
            CSpinner.this.m_spinner.setBounds(cRect.x + cRect.width - sSize.x + 1, cRect.y - 1, sSize.x, cRect.height + 2);
            CSpinner.this.m_text.setBounds(cRect.x, cRect.y + 1, cRect.width - arrowWidth, tSize.y);
            CSpinner.this.win32Hack.setBounds(cRect.x, cRect.y, cRect.width - arrowWidth, sSize.y);
        }
    }
}

