/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public final class MethodParameterVariableSupport
extends AbstractNamedVariableSupport {
    private final SingleVariableDeclaration m_parameter;
    private final MethodDeclaration m_method;

    public MethodParameterVariableSupport(JavaInfo javaInfo, SingleVariableDeclaration parameter) {
        super(javaInfo, (Expression)parameter.getName());
        this.m_parameter = parameter;
        this.m_method = (MethodDeclaration)this.m_parameter.getParent();
    }

    public String toString() {
        return this.m_parameter.getName().getIdentifier();
    }

    @Override
    public String getTitle() throws Exception {
        return this.m_parameter.getName().getIdentifier() + " in " + this.m_method.getName().getIdentifier() + "(...)";
    }

    @Override
    public boolean isJavaInfo(ASTNode node) {
        if (node instanceof SimpleName && AstNodeUtils.isVariable(node)) {
            return ExecutionFlowUtils.getLastAssignment(new ExecutionFlowDescription(this.m_method), node) == this.m_parameter;
        }
        return false;
    }

    @Override
    public StatementTarget getStatementTarget() throws Exception {
        List<Statement> statements = DomGenerics.statements(this.m_method.getBody());
        if (!statements.isEmpty() && statements.get(0) instanceof SuperConstructorInvocation) {
            return new StatementTarget(statements.get(0), false);
        }
        return new StatementTarget(this.m_method, true);
    }

    @Override
    public boolean isValidStatementForChild(Statement statement) {
        return AstNodeUtils.getEnclosingMethod((ASTNode)statement) == this.m_method;
    }

    @Override
    public void setName(String newName) throws Exception {
        this.modifyName(newName);
    }

    @Override
    public boolean hasExpression(NodeTarget target) {
        return this.getReferenceExpression0(target) != null;
    }

    @Override
    public String getReferenceExpression(NodeTarget target) throws Exception {
        String expression = this.getReferenceExpression0(target);
        if (expression != null) {
            return expression;
        }
        throw new IllegalArgumentException(MessageFormat.format("Can not access {0} of {1} at target {2}.", this.m_parameter, this.m_method, target));
    }

    private String getReferenceExpression0(NodeTarget target) {
        StatementTarget statementTarget = target.getStatementTarget();
        if (statementTarget != null) {
            ASTNode targetNode = statementTarget.getNode();
            if (AstNodeUtils.contains((ASTNode)this.m_method, targetNode)) {
                return this.getName();
            }
            MethodDeclaration targetMethod = AstNodeUtils.getEnclosingMethod(targetNode);
            for (SingleVariableDeclaration parameter : DomGenerics.parameters(targetMethod)) {
                SimpleName parameterName = parameter.getName();
                if (!this.m_javaInfo.isRepresentedBy((ASTNode)parameterName)) continue;
                return parameterName.getIdentifier();
            }
        }
        return null;
    }

    @Override
    public boolean canConvertLocalToField() {
        return false;
    }

    @Override
    public void convertLocalToField() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public boolean canConvertFieldToLocal() {
        return false;
    }

    @Override
    public void convertFieldToLocal() throws Exception {
        throw new IllegalStateException();
    }
}

