/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.live;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.BroadcastSupport;
import org.eclipse.wb.core.model.broadcast.DisplayEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ILiveCreationSupport;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.model.util.live.ILiveCacheEntry;
import org.eclipse.wb.internal.core.parser.JavaInfoParser;
import org.eclipse.wb.internal.core.parser.JavaInfoResolver;
import org.eclipse.wb.internal.core.utils.IDisposable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public abstract class AbstractLiveManager {
    protected final AbstractComponentInfo m_component;
    protected final AstEditor m_editor;
    protected final EditorState m_editorState;
    private TypeDeclaration m_tmpType;
    private MethodDeclaration m_method;
    private static final Map<String, ILiveCacheEntry> m_staticCache = new HashMap<String, ILiveCacheEntry>();
    private static final String EDITOR_CACHE_KEY = "LIVE_CACHE";

    public AbstractLiveManager(AbstractComponentInfo component) {
        this.m_component = component;
        this.m_editor = component.getEditor();
        this.m_editorState = EditorState.get(this.m_component.getEditor());
    }

    protected final ILiveCacheEntry createCacheEntry() {
        try {
            return this.createCacheEntryEx();
        }
        catch (Throwable e) {
            e = DesignerExceptionUtils.getDesignerCause((Throwable)e);
            DesignerPlugin.log((Throwable)e);
            return this.createComponentCacheEntryEx(e);
        }
    }

    private ILiveCacheEntry createCacheEntryEx() throws Exception {
        ILiveCacheEntry iLiveCacheEntry;
        BroadcastSupport oldBroadcast = this.m_editorState.getBroadcast();
        JavaInfoResolver oldResolver = this.m_editorState.getJavaInfoResolver();
        JavaInfo oldActiveObject = (JavaInfo)GlobalState.getActiveObject();
        ((DisplayEventListener)oldBroadcast.getListener(DisplayEventListener.class)).beforeMessagesLoop();
        ExecutionFlowDescription old_flowDescription = this.m_editorState.getFlowDescription();
        AbstractComponentInfo liveComponentInfo = null;
        try {
            this.m_editorState.setBroadcastSupport(new BroadcastSupport());
            this.m_editorState.setLiveComponent(true);
            this.m_editor.setResolveImports(false);
            liveComponentInfo = this.createLiveComponent();
            JavaInfo root = liveComponentInfo.getRootJava();
            root.endEdit();
            iLiveCacheEntry = this.createComponentCacheEntry(liveComponentInfo);
        }
        catch (Throwable throwable) {
            this.cleanupLiveComponent(liveComponentInfo);
            this.m_editorState.setLiveComponent(false);
            this.m_editorState.setBroadcastSupport(oldBroadcast);
            this.m_editorState.setJavaInfoResolver(oldResolver);
            this.m_editorState.setFlowDescription(old_flowDescription);
            GlobalStateJava.activate(oldActiveObject);
            this.m_editor.setResolveImports(true);
            if (this.m_tmpType != null) {
                this.m_editor.removeBodyDeclaration((BodyDeclaration)this.m_tmpType);
                this.m_editor.commitChanges();
            }
            ((DisplayEventListener)oldBroadcast.getListener(DisplayEventListener.class)).afterMessagesLoop();
            throw throwable;
        }
        this.cleanupLiveComponent(liveComponentInfo);
        this.m_editorState.setLiveComponent(false);
        this.m_editorState.setBroadcastSupport(oldBroadcast);
        this.m_editorState.setJavaInfoResolver(oldResolver);
        this.m_editorState.setFlowDescription(old_flowDescription);
        GlobalStateJava.activate(oldActiveObject);
        this.m_editor.setResolveImports(true);
        if (this.m_tmpType != null) {
            this.m_editor.removeBodyDeclaration((BodyDeclaration)this.m_tmpType);
            this.m_editor.commitChanges();
        }
        ((DisplayEventListener)oldBroadcast.getListener(DisplayEventListener.class)).afterMessagesLoop();
        return iLiveCacheEntry;
    }

    protected String getKey() {
        return this.m_component.getCreationSupport().toString();
    }

    protected abstract AbstractComponentInfo createLiveComponent() throws Exception;

    protected void cleanupLiveComponent(AbstractComponentInfo liveComponentInfo) throws Exception {
        if (liveComponentInfo != null) {
            liveComponentInfo.getRoot().refresh_dispose();
        }
    }

    protected abstract ILiveCacheEntry createComponentCacheEntry(AbstractComponentInfo var1);

    protected abstract ILiveCacheEntry createComponentCacheEntryEx(Throwable var1);

    protected final JavaInfo parse(String[] sourceLines) throws Exception {
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.m_editor.getAstUnit().types().get(0);
        this.m_tmpType = this.m_editor.addTypeDeclaration(List.of("private static class __Tmp {", "}"), new BodyDeclarationTarget(typeDeclaration, false));
        this.m_method = this.m_editor.addMethodDeclaration("private static void __tmp()", List.of(sourceLines), new BodyDeclarationTarget(this.m_tmpType, false));
        this.m_editorState.setFlowDescription(new ExecutionFlowDescription(this.m_method));
        JavaInfo root = JavaInfoParser.parse(this.m_editor, this.m_method);
        root.startEdit();
        root.putArbitraryValue("don't commit ASTEditor source", Boolean.TRUE);
        return root;
    }

    protected static Image createImageForException(Throwable e) {
        int width = 200;
        int height = 50;
        Image image = new Image(null, width, height);
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(new Color(255, 220, 220));
            gc.fillRectangle(0, 0, width, height);
            String text = ModelMessages.AbstractLiveManager_errorMessage;
            DrawUtils.drawTextWrap((GC)gc, (String)text, (int)0, (int)0, (int)width, (int)height);
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    protected final <T extends JavaInfo> T createClone() throws Exception {
        CreationSupport creationSupport = ((ILiveCreationSupport)((Object)this.m_component.getCreationSupport())).getLiveComponentCreation();
        JavaInfo clone = JavaInfoUtils.createJavaInfo(this.m_editor, this.m_component.getDescription(), creationSupport);
        clone.putTemplateArguments(this.m_component.getTemplateArguments());
        return (T)((Object)clone);
    }

    protected final ILiveCacheEntry getCachedEntry() {
        if (this.m_component.getDescription().isCached() && this.m_component.getCreationSupport() instanceof ConstructorCreationSupport) {
            Map<String, ILiveCacheEntry> cache = this.getStaticCache();
            return this.getCachedEntry(cache, false);
        }
        Map<String, ILiveCacheEntry> cache = this.getEditorCache();
        return this.getCachedEntry(cache, true);
    }

    private ILiveCacheEntry getCachedEntry(Map<String, ILiveCacheEntry> cache, boolean disposeWithEditor) {
        String key = this.getKey();
        ILiveCacheEntry entry = cache.get(key);
        if (entry == null) {
            entry = this.createCacheEntry();
            cache.put(key, entry);
            if (disposeWithEditor) {
                EditorState.get(this.m_editor).addDisposable((IDisposable)entry);
            }
        }
        return entry;
    }

    protected final Map<String, ILiveCacheEntry> getStaticCache() {
        return m_staticCache;
    }

    protected final Map<String, ILiveCacheEntry> getEditorCache() {
        HashMap cache = (HashMap)this.m_component.getEditor().getGlobalValue(EDITOR_CACHE_KEY);
        if (cache == null) {
            cache = new HashMap();
            this.m_component.getEditor().putGlobalValue(EDITOR_CACHE_KEY, cache);
        }
        return cache;
    }
}

