/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class TemplateUtils {
    public static final String ID_PREFIX = "__wbpId:";

    public static String getExpression(JavaInfo javaInfo) {
        return ID_PREFIX + ObjectInfoUtils.getId((ObjectInfo)javaInfo);
    }

    public static String format(String pattern, Object ... arguments) {
        Object[] updatedArguments = new Object[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            Object argument = arguments[i];
            if (argument instanceof JavaInfo) {
                argument = TemplateUtils.getExpression((JavaInfo)((Object)argument));
            }
            updatedArguments[i] = argument;
            ++i;
        }
        return MessageFormat.format(pattern, updatedArguments);
    }

    public static String resolve(StatementTarget target, String text) throws Exception {
        return TemplateUtils.resolve(new NodeTarget(target), text);
    }

    public static String resolve(BodyDeclarationTarget target, String text) throws Exception {
        return TemplateUtils.resolve(new NodeTarget(target), text);
    }

    public static String resolve(NodeTarget target, String text) throws Exception {
        int jIndex;
        while ((jIndex = ((String)text).indexOf(ID_PREFIX)) != -1) {
            int idBegin;
            int idEnd = idBegin = jIndex + ID_PREFIX.length();
            while (idEnd < ((String)text).length() && Character.isDigit(((String)text).charAt(idEnd))) {
                ++idEnd;
            }
            String id = ((String)text).substring(idBegin, idEnd);
            boolean askAccess = false;
            if (idEnd < ((String)text).length() && ((String)text).charAt(idEnd) == '.') {
                askAccess = true;
                ++idEnd;
            }
            JavaInfo javaInfo = (JavaInfo)ObjectInfoUtils.getById((String)id);
            VariableSupport variableSupport = javaInfo.getVariableSupport();
            String expr = askAccess ? variableSupport.getAccessExpression(target) : variableSupport.getReferenceExpression(target);
            text = ((String)text).substring(0, jIndex) + expr + ((String)text).substring(idEnd);
        }
        return text;
    }

    public static List<String> resolve(NodeTarget target, List<String> lines) throws Exception {
        ArrayList<String> resolvedLines = new ArrayList<String>();
        for (String line : lines) {
            line = TemplateUtils.resolve(target, line);
            resolvedLines.add(line);
        }
        return resolvedLines;
    }

    public static String resolve(StatementTarget target, String pattern, Object ... arguments) throws Exception {
        return TemplateUtils.resolve(new NodeTarget(target), pattern, arguments);
    }

    public static String resolve(BodyDeclarationTarget target, String pattern, Object ... arguments) throws Exception {
        return TemplateUtils.resolve(new NodeTarget(target), pattern, arguments);
    }

    public static String resolve(NodeTarget target, String pattern, Object ... arguments) throws Exception {
        String text = TemplateUtils.format(pattern, arguments);
        return TemplateUtils.resolve(target, text);
    }

    public static Statement addStatement(JavaInfo javaInfo, StatementTarget target, List<String> lines) throws Exception {
        List<String> resolvedLines = TemplateUtils.resolve(new NodeTarget(target), lines);
        Statement statement = javaInfo.getEditor().addStatement(resolvedLines, target);
        javaInfo.addRelatedNodes((ASTNode)statement);
        return statement;
    }

    public static String evaluate(String source, JavaInfo javaInfo) throws Exception {
        return TemplateUtils.evaluate(source, javaInfo, null);
    }

    public static String evaluate(String source, JavaInfo javaInfo, Map<String, String> templateVariables) throws Exception {
        String expression;
        if (templateVariables != null) {
            source = StringSubstitutor.replace((Object)source, templateVariables);
        }
        while ((expression = StringUtils.substringBetween((String)source, (String)"${", (String)"}")) != null) {
            try {
                String result = TemplateUtils.evaluateExpression(expression, javaInfo);
                source = StringUtils.replace((String)source, (String)("${" + expression + "}"), (String)result);
            }
            catch (Throwable e) {
                String message = String.format("Exception during evaluation |%s|.", source);
                throw new IllegalArgumentException(message, e);
            }
        }
        return source;
    }

    private static String evaluateExpression(String expression, JavaInfo javaInfo) throws Exception {
        String originalExpression = expression;
        block0: while (expression.length() != 0) {
            if (expression.startsWith(".")) {
                expression = expression.substring(1);
                continue;
            }
            if (expression.startsWith("parent")) {
                javaInfo = javaInfo.getParentJava();
                expression = expression.substring("parent".length());
                continue;
            }
            if (expression.startsWith("firstChild[")) {
                int openBracketIndex = expression.indexOf("[");
                int closeBracketIndex = expression.indexOf("]");
                String selectorClassName = expression.substring(openBracketIndex + 1, closeBracketIndex);
                expression = expression.substring(closeBracketIndex + "]".length());
                for (JavaInfo child : javaInfo.getChildrenJava()) {
                    Class<?> childComponentClass = child.getDescription().getComponentClass();
                    if (!ReflectionUtils.isSuccessorOf(childComponentClass, (String)selectorClassName)) continue;
                    javaInfo = child;
                    continue block0;
                }
                throw new IllegalArgumentException(String.format("Can not find |%s| in |%s|.", new Object[]{selectorClassName, javaInfo}));
            }
            if (expression.startsWith("expression")) {
                return TemplateUtils.getExpression(javaInfo);
            }
            throw new IllegalArgumentException(String.format("Incorrect expression |%s|.", expression));
        }
        throw new IllegalArgumentException(String.format("Expression have not evaluated |%s|.", originalExpression));
    }
}

