/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.burningwave.core.Closeable;
import org.burningwave.core.Identifiable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.NullExecutableException;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelper;

public abstract class Thread
extends java.lang.Thread {
    private static final ThrowingConsumer<Thread, ? extends Throwable> nullExecutableNotifier = thread -> StaticComponentContainer.ManagedLoggerRepository.logError(thread.getClass()::getName, "Executable is null");
    ThrowingConsumer<Thread, ? extends Throwable> originalExecutable;
    AtomicReference<ThrowingConsumer<Thread, ? extends Throwable>> executableWrapper = new AtomicReference();
    boolean looper;
    boolean looping;
    Boolean running;
    Supplier supplier;
    String defaultName;
    String typeName;

    private Thread(Supplier threadSupplier, long number) {
        super(threadSupplier.name + " - Executor " + number);
        this.supplier = threadSupplier;
        this.typeName = this.getClass().getSimpleName();
        this.defaultName = StaticComponentContainer.Strings.compile("{} - {} executor {}", this.supplier.name, this.typeName, number);
        this.setIndexedName();
        this.setDaemon(threadSupplier.daemon);
        this.setPriority(this.supplier.defaultThreadPriority);
    }

    abstract void removePermanently();

    abstract void startRunning();

    void callStart() {
        super.start();
    }

    public void setIndexedName() {
        this.setIndexedName(null);
    }

    public void setIndexedName(String prefix) {
        this.setName(Optional.ofNullable(prefix).orElse(this.defaultName));
    }

    public Thread setExecutable(ThrowingConsumer<Thread, ? extends Throwable> executable) {
        return this.setExecutable(executable, false);
    }

    public Thread setExecutable(ThrowingConsumer<Thread, ? extends Throwable> executable, boolean isLooper) {
        this.originalExecutable = executable;
        this.looper = isLooper;
        return this;
    }

    public boolean isDetached() {
        return this instanceof Detached;
    }

    public boolean isPoolable() {
        return this instanceof Poolable;
    }

    @Override
    public void start() {
        if (this.originalExecutable == null) {
            this.originalExecutable = nullExecutableNotifier;
            this.looper = false;
            this.startExecution();
            throw new NullExecutableException(StaticComponentContainer.Strings.compile("Executable of {} is null", this));
        }
        this.startExecution();
    }

    void startExecution() {
        if (!this.looper) {
            this.executableWrapper.set(this.originalExecutable);
        } else {
            this.executableWrapper.set(thread -> {
                this.looping = true;
                while (this.looping) {
                    this.originalExecutable.accept(this);
                }
            });
        }
        try {
            this.supplier.runningAndWaitingForRunThreads.put(this, this);
            this.startRunning();
        }
        catch (Throwable exc) {
            this.supplier.runningAndWaitingForRunThreads.remove(this);
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLooping() {
        this.looping = false;
        AtomicReference<ThrowingConsumer<Thread, ? extends Throwable>> atomicReference = this.executableWrapper;
        synchronized (atomicReference) {
            this.executableWrapper.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.isAlive() && this.running != false;
    }

    public boolean isLooping() {
        return this.looping;
    }

    void shutDown() {
        this.shutDown(false);
    }

    void shutDown(boolean waitForFinish) {
        this.running = false;
        this.stopLooping();
        if (waitForFinish) {
            this.supplier.joinThread(this);
        }
    }

    @Deprecated
    public void kill() {
        this.terminate(thread -> StaticComponentContainer.Driver.stop((java.lang.Thread)thread), "stop");
    }

    @Override
    public void interrupt() {
        this.terminate(thread -> super.interrupt(), "interrupt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Consumer<Thread> operation, String operationName) {
        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Called {} by {}{}\n\ton {} (executable: {}):{}", operationName, java.lang.Thread.currentThread(), StaticComponentContainer.Strings.from(StaticComponentContainer.Methods.retrieveExternalCallersInfo(), 2), this, this.executableWrapper.get(), StaticComponentContainer.Strings.from(this.getStackTrace(), 2));
        this.shutDown();
        this.removePermanently();
        java.lang.Thread currentThread = java.lang.Thread.currentThread();
        if (this != currentThread) {
            try {
                operation.accept(this);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred", exc);
            }
        }
        Object exc = this.supplier.poolableSleepingThreads;
        synchronized (exc) {
            this.supplier.poolableSleepingThreads.notifyAll();
        }
        exc = this.executableWrapper;
        synchronized (exc) {
            this.executableWrapper.notifyAll();
        }
        if (this == currentThread) {
            Thread killer = this.supplier.getOrCreateThread().setExecutable(thread -> operation.accept(this));
            killer.setPriority(currentThread.getPriority());
            killer.start();
        }
    }

    @Override
    public String toString() {
        return StaticComponentContainer.Strings.compile("{}{}", super.toString(), Optional.ofNullable(this.getState()).map(threadState -> StaticComponentContainer.Strings.compile("({})", StaticComponentContainer.Strings.capitalizeFirstCharacter(threadState.name().toLowerCase().replace("_", " ")))).orElseGet(() -> ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long waitFor(long millis) {
        long initialTime = System.currentTimeMillis();
        if (millis > 0L) {
            try {
                Object object;
                Object object2 = object = new Object();
                synchronized (object) {
                    object.wait(millis);
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                }
            }
            catch (InterruptedException exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(Thread.class::getName, exc);
            }
        }
        {
            return System.currentTimeMillis() - initialTime;
        }
    }

    public static class Supplier
    implements Identifiable {
        private static long threadNumberSupplier;
        private String name;
        private volatile int threadCount;
        private volatile int poolableThreadCount;
        private int maxPoolableThreadCount;
        private int inititialMaxThreadCount;
        private int maxThreadCount;
        private int maxDetachedThreadCountIncreasingStep;
        private long poolableThreadRequestTimeout;
        private long elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount;
        private Map<Thread, Thread> runningThreads;
        private Map<Thread, Thread> runningAndWaitingForRunThreads;
        private Poolable[] poolableSleepingThreads;
        private Object[] poolableSleepingThreadMutexes;
        private long timeOfLastIncreaseOfMaxDetachedThreadCount;
        private boolean daemon;
        private Function<Poolable, Integer> addForwardPoolableSleepingThreadFunction = this::addForwardPoolableSleepingThread;
        private Function<Poolable, Integer> addReversePoolableSleepingThreadFunction = this::addReversePoolableSleepingThread;
        private Function<Poolable, Integer> addPoolableSleepingThreadFunction = this.addForwardPoolableSleepingThreadFunction;
        private java.util.function.Supplier<Poolable> getForwardPoolableThreadFunction = this::getForwardPoolableThread;
        private java.util.function.Supplier<Poolable> getReversePoolableThreadFunction = this::getReversePoolableThread;
        private java.util.function.Supplier<Poolable> getPoolableThreadFunction = this.getForwardPoolableThreadFunction;
        private int defaultThreadPriority;

        Supplier(String name, Map<Object, Object> config) {
            int maxDetachedThreadCount;
            this.name = name;
            this.daemon = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.default-daemon-flag-value").on(config)));
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            int multiplier = 3;
            try {
                this.maxPoolableThreadCount = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-poolable-thread-count").on(config)));
            }
            catch (Throwable exc) {
                this.maxPoolableThreadCount = availableProcessors * multiplier;
            }
            if (this.maxPoolableThreadCount < 0) {
                throw new IllegalArgumentException("maxPoolableThreadCount must be greater than or equal to zero");
            }
            try {
                maxDetachedThreadCount = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-detached-thread-count").on(config)));
            }
            catch (Throwable exc) {
                maxDetachedThreadCount = availableProcessors * multiplier;
            }
            if (maxDetachedThreadCount < 0) {
                maxDetachedThreadCount = Integer.MAX_VALUE - this.maxPoolableThreadCount;
            }
            this.runningAndWaitingForRunThreads = new ConcurrentHashMap<Thread, Thread>();
            this.runningThreads = new ConcurrentHashMap<Thread, Thread>(){
                private static final long serialVersionUID = 3434004576787151770L;

                @Override
                public Thread remove(Object key) {
                    runningAndWaitingForRunThreads.remove(key);
                    return (Thread)super.remove(key);
                }
            };
            this.poolableSleepingThreads = new Poolable[this.maxPoolableThreadCount];
            this.poolableSleepingThreadMutexes = new Object[this.poolableSleepingThreads.length];
            for (int i = 0; i < this.poolableSleepingThreadMutexes.length; ++i) {
                this.poolableSleepingThreadMutexes[i] = new Object();
            }
            this.inititialMaxThreadCount = this.maxThreadCount = this.maxPoolableThreadCount + maxDetachedThreadCount;
            this.poolableThreadRequestTimeout = StaticComponentContainer.Objects.toLong(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.poolable-thread-request-timeout").on(config)));
            this.elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount = StaticComponentContainer.Objects.toLong(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-detached-thread-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value").on(config)));
            try {
                this.maxDetachedThreadCountIncreasingStep = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-detached-thread-count.increasing-step").on(config)));
            }
            catch (Throwable exc) {
                this.maxDetachedThreadCountIncreasingStep = availableProcessors;
            }
            if (this.maxDetachedThreadCountIncreasingStep < 1) {
                this.poolableThreadRequestTimeout = 0L;
                config.put("thread-supplier.poolable-thread-request-timeout", this.poolableThreadRequestTimeout);
            }
            this.timeOfLastIncreaseOfMaxDetachedThreadCount = Long.MAX_VALUE;
            try {
                this.defaultThreadPriority = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.default-thread-priority").on(config)));
            }
            catch (Throwable exc) {
                this.defaultThreadPriority = java.lang.Thread.currentThread().getPriority();
            }
        }

        public static Supplier create(String name, Map<Object, Object> config, boolean undestroyable) {
            if (undestroyable) {
                return new Supplier(name, (Map)config){
                    StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                    @Override
                    public Supplier shutDownAllThreads(boolean joinThreads) {
                        String shutDownRequestorClass = StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName();
                        if (shutDownRequestorClass.equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                            super.shutDownAllThreads(joinThreads);
                        } else {
                            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "{} is not authorized to shutdown {}", shutDownRequestorClass, this);
                        }
                        return this;
                    }
                };
            }
            return new Supplier(name, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Thread getOrCreatePoolableThread() {
            Thread thread;
            while ((thread = (Thread)this.getPoolableThreadFunction.get()) == null) {
                Poolable[] poolableArray = this.poolableSleepingThreads;
                // MONITORENTER : this.poolableSleepingThreads
                thread = this.getPoolableThreadFunction.get();
                if (thread != null) {
                    // MONITOREXIT : poolableArray
                    return thread;
                }
                if (this.poolableThreadCount < this.maxPoolableThreadCount) {
                    // MONITOREXIT : poolableArray
                    return this.createPoolableThread();
                }
                try {
                    this.poolableSleepingThreads.wait();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(Thread.class::getName, exc);
                }
            }
            return thread;
        }

        public Thread getOrCreateThread(String name) {
            Thread thread = this.getOrCreateThread();
            thread.setName(name);
            return thread;
        }

        public final Thread getOrCreateThread() {
            return this.getOrCreateThread(1);
        }

        public final Thread getOrCreateThread(int tentativeCount) {
            return this.getOrCreateThread(tentativeCount, tentativeCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Thread getOrCreateThread(int initialValue, int tentativeCount) {
            Poolable[] poolableArray;
            Thread thread = this.getPoolableThreadFunction.get();
            if (thread != null) {
                return thread;
            }
            if (tentativeCount > 0 && this.poolableThreadCount >= this.maxPoolableThreadCount && this.threadCount >= this.maxThreadCount) {
                poolableArray = this.poolableSleepingThreads;
                synchronized (this.poolableSleepingThreads) {
                    try {
                        thread = this.getPoolableThreadFunction.get();
                        if (thread != null) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return thread;
                        }
                        if (this.poolableThreadCount >= this.maxPoolableThreadCount && this.threadCount >= this.maxThreadCount) {
                            long startWaitTime = System.currentTimeMillis();
                            this.poolableSleepingThreads.wait(this.poolableThreadRequestTimeout);
                            if (this.maxDetachedThreadCountIncreasingStep < 1) {
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                return this.getOrCreateThread(initialValue, tentativeCount);
                            }
                            long endWaitTime = System.currentTimeMillis();
                            long waitElapsedTime = endWaitTime - startWaitTime;
                            if (waitElapsedTime < this.poolableThreadRequestTimeout) {
                                if (this.inititialMaxThreadCount < this.maxThreadCount && System.currentTimeMillis() - this.timeOfLastIncreaseOfMaxDetachedThreadCount > this.elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount) {
                                    this.maxThreadCount -= this.maxDetachedThreadCountIncreasingStep / 2;
                                    StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "{}: decreasing maxThreadCount to {}", java.lang.Thread.currentThread(), this.maxThreadCount);
                                    this.timeOfLastIncreaseOfMaxDetachedThreadCount = Long.MAX_VALUE;
                                }
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                return this.getOrCreateThread(initialValue, tentativeCount);
                            }
                            this.timeOfLastIncreaseOfMaxDetachedThreadCount = System.currentTimeMillis();
                            this.maxThreadCount += this.maxDetachedThreadCountIncreasingStep;
                            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "{} waited for {}ms: maxThreadCount will be temporarily increased to {} to avoid performance degradation", java.lang.Thread.currentThread(), waitElapsedTime, this.maxThreadCount);
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return this.getOrCreateThread(initialValue, --tentativeCount);
                        }
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                    }
                }
            }
            if (this.poolableThreadCount >= this.maxPoolableThreadCount) {
                if (this.threadCount < this.maxThreadCount) {
                    return this.createDetachedThread();
                }
                return this.getOrCreateThread(initialValue, initialValue);
            }
            {
                poolableArray = this.poolableSleepingThreads;
                synchronized (this.poolableSleepingThreads) {
                    if (this.poolableThreadCount >= this.maxPoolableThreadCount) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return this.getOrCreateThread(initialValue, tentativeCount);
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.createPoolableThread();
                }
            }
        }

        Thread createPoolableThread() {
            ++this.poolableThreadCount;
            ++this.threadCount;
            return new Poolable(this, ++threadNumberSupplier);
        }

        public Thread createDetachedThread() {
            ++this.threadCount;
            return new Detached(this, ++threadNumberSupplier);
        }

        private Integer addForwardPoolableSleepingThread(Poolable thread) {
            this.addPoolableSleepingThreadFunction = this.addReversePoolableSleepingThreadFunction;
            for (int index = 0; index < this.poolableSleepingThreads.length; ++index) {
                if (this.poolableSleepingThreads[index] != null || !this.addPoolableSleepingThread(thread, index)) continue;
                return index;
            }
            return null;
        }

        private Integer addReversePoolableSleepingThread(Poolable thread) {
            this.addPoolableSleepingThreadFunction = this.addForwardPoolableSleepingThreadFunction;
            for (int index = this.poolableSleepingThreads.length - 1; index >= 0; --index) {
                if (this.poolableSleepingThreads[index] != null || !this.addPoolableSleepingThread(thread, index)) continue;
                return index;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addPoolableSleepingThread(Poolable thread, int index) {
            Object object = this.poolableSleepingThreadMutexes[index];
            synchronized (object) {
                if (this.poolableSleepingThreads[index] == null) {
                    this.poolableSleepingThreads[index] = thread;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Poolable getForwardPoolableThread() {
            this.getPoolableThreadFunction = this.getReversePoolableThreadFunction;
            for (int index = 0; index < this.poolableSleepingThreads.length; ++index) {
                if (this.poolableSleepingThreads[index] == null) continue;
                Object object = this.poolableSleepingThreadMutexes[index];
                synchronized (object) {
                    if (this.poolableSleepingThreads[index] != null) {
                        Poolable thread = this.poolableSleepingThreads[index];
                        this.poolableSleepingThreads[index] = null;
                        return thread;
                    }
                    continue;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Poolable getReversePoolableThread() {
            this.getPoolableThreadFunction = this.getForwardPoolableThreadFunction;
            for (int index = this.poolableSleepingThreads.length - 1; index >= 0; --index) {
                if (this.poolableSleepingThreads[index] == null) continue;
                Object object = this.poolableSleepingThreadMutexes[index];
                synchronized (object) {
                    if (this.poolableSleepingThreads[index] != null) {
                        Poolable thread = this.poolableSleepingThreads[index];
                        this.poolableSleepingThreads[index] = null;
                        return thread;
                    }
                    continue;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removePoolableSleepingThread(Poolable thread) {
            for (int index = 0; index < this.poolableSleepingThreads.length; ++index) {
                if (this.poolableSleepingThreads[index] != thread) continue;
                Object object = this.poolableSleepingThreadMutexes[index];
                synchronized (object) {
                    if (this.poolableSleepingThreads[index] == thread) {
                        this.poolableSleepingThreads[index] = null;
                        return true;
                    }
                    continue;
                }
            }
            return false;
        }

        public Supplier shutDownAllPoolableSleepingThreads() {
            return this.shutDownAllPoolableSleepingThreads(false);
        }

        public Supplier shutDownAllPoolableSleepingThreads(boolean joinThreads) {
            boolean areThereRunningThreads = false;
            for (Poolable thread : this.poolableSleepingThreads) {
                if (thread == null || !thread.isRunning()) continue;
                areThereRunningThreads = true;
                thread.shutDown(joinThreads);
            }
            if (areThereRunningThreads) {
                this.shutDownAllPoolableSleepingThreads(joinThreads);
            }
            return this;
        }

        public Supplier shutDownAllThreads() {
            return this.shutDownAllThreads(false);
        }

        public Supplier shutDownAllThreads(boolean joinThreads) {
            Iterator<Thread> itr = this.runningAndWaitingForRunThreads.keySet().iterator();
            while (itr.hasNext()) {
                itr.next().shutDown(joinThreads);
            }
            this.shutDownAllPoolableSleepingThreads(joinThreads);
            return this;
        }

        public Supplier joinAllRunningThreads() {
            Iterator<Thread> itr = this.runningAndWaitingForRunThreads.keySet().iterator();
            while (itr.hasNext()) {
                this.joinThread(itr.next());
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Thread joinThread(Thread thread) {
            if (java.lang.Thread.currentThread() == thread) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Join ignored: the current thread could not wait itself");
                return thread;
            }
            while (thread.executableWrapper.get() != null) {
                AtomicReference<ThrowingConsumer<Thread, ? extends Throwable>> atomicReference = thread.executableWrapper;
                synchronized (atomicReference) {
                    if (thread.executableWrapper.get() != null) {
                        try {
                            thread.executableWrapper.wait();
                        }
                        catch (InterruptedException exc) {
                            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                        }
                    }
                }
            }
            return thread;
        }

        public int getPoolableThreadCount() {
            return this.poolableThreadCount;
        }

        public int getDetachedThreadCount() {
            return this.threadCount - this.poolableThreadCount;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public int getPoolableSleepingThreadCount() {
            int count = 0;
            for (Poolable thread : this.poolableSleepingThreads) {
                if (thread == null) continue;
                ++count;
            }
            return count;
        }

        public int getRunningThreadCount() {
            return this.runningThreads.size();
        }

        public int getInititialMaxThreadCount() {
            return this.inititialMaxThreadCount;
        }

        public int getMaxDetachedThreadCountIncreasingStep() {
            return this.maxDetachedThreadCountIncreasingStep;
        }

        public int getCountOfThreadsThatCanBeSupplied() {
            if (this.maxDetachedThreadCountIncreasingStep > 0) {
                return Integer.MAX_VALUE - this.runningThreads.size();
            }
            return this.maxThreadCount - this.runningThreads.size();
        }

        public void printStatus() {
            int threadCount = this.threadCount;
            int runningThreadCount = this.runningThreads.size();
            int poolableThreadCount = this.poolableThreadCount;
            int poolableSleepingThreadCount = this.getPoolableSleepingThreadCount();
            int detachedThreadCount = threadCount - poolableThreadCount;
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "\n\tThread count: {}\tRunning threads: {}\n\tPoolable threads: {}\n\tPoolable running threads: {}\n\tPoolable sleeping threads: {}\n\tDetached threads: {}\n", threadCount, runningThreadCount, poolableThreadCount, poolableThreadCount - poolableSleepingThreadCount, poolableSleepingThreadCount, detachedThreadCount);
        }

        public static abstract class Configuration {
            public static final Map<String, Object> DEFAULT_VALUES;

            static {
                HashMap<String, Object> defaultValues = new HashMap<String, Object>();
                defaultValues.put("thread-supplier.max-poolable-thread-count", "autodetect");
                defaultValues.put("thread-supplier.max-detached-thread-count", "${thread-supplier.max-poolable-thread-count}");
                defaultValues.put("thread-supplier.poolable-thread-request-timeout", 6000);
                defaultValues.put("thread-supplier.default-daemon-flag-value", true);
                defaultValues.put("thread-supplier.max-detached-thread-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value", 30000);
                defaultValues.put("thread-supplier.max-detached-thread-count.increasing-step", "autodetect");
                defaultValues.put("thread-supplier.default-thread-priority", 5);
                DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
            }

            public static abstract class Key {
                public static final String MAX_POOLABLE_THREAD_COUNT = "thread-supplier.max-poolable-thread-count";
                public static final String MAX_DETACHED_THREAD_COUNT = "thread-supplier.max-detached-thread-count";
                public static final String DEFAULT_DAEMON_FLAG_VALUE = "thread-supplier.default-daemon-flag-value";
                public static final String POOLABLE_THREAD_REQUEST_TIMEOUT = "thread-supplier.poolable-thread-request-timeout";
                public static final String MAX_DETACHED_THREAD_COUNT_ELAPSED_TIME_THRESHOLD_FROM_LAST_INCREASE_FOR_GRADUAL_DECREASING_TO_INITIAL_VALUE = "thread-supplier.max-detached-thread-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value";
                public static final String MAX_DETACHED_THREAD_COUNT_INCREASING_STEP = "thread-supplier.max-detached-thread-count.increasing-step";
                public static final String DEFAULT_THREAD_PRIORITY = "thread-supplier.default-thread-priority";
            }
        }
    }

    private static class Detached
    extends Thread {
        private Detached(Supplier supplier, long number) {
            super(supplier, number);
        }

        @Override
        void startRunning() {
            this.callStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            this.supplier.runningThreads.put(this, this);
            try {
                ((ThrowingConsumer)this.executableWrapper.get()).accept(this);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
            }
            this.executableWrapper.set(null);
            this.originalExecutable = null;
            this.removePermanently();
            Object object = this.supplier.poolableSleepingThreads;
            synchronized (object) {
                this.supplier.poolableSleepingThreads.notifyAll();
            }
            object = this.executableWrapper;
            synchronized (object) {
                this.executableWrapper.notifyAll();
            }
            this.running = false;
        }

        @Override
        void removePermanently() {
            if (this.supplier.runningThreads.remove(this) != null) {
                --this.supplier.threadCount;
            }
        }
    }

    private static class Poolable
    extends Thread {
        private Poolable(Supplier supplier, long number) {
            super(supplier, number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void startRunning() {
            if (this.running != null) {
                AtomicReference atomicReference = this.executableWrapper;
                synchronized (atomicReference) {
                    this.executableWrapper.notifyAll();
                }
            } else {
                this.callStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.running != null) {
                throw new IllegalStateException(StaticComponentContainer.Strings.compile("{} could not be restarted", this));
            }
            this.running = true;
            while (this.running.booleanValue()) {
                this.supplier.runningThreads.put(this, this);
                try {
                    this.runExecutable();
                    this.supplier.runningThreads.remove(this);
                    object = this.executableWrapper;
                    synchronized (object) {
                        this.executableWrapper.set(null);
                        this.executableWrapper.notifyAll();
                    }
                    this.originalExecutable = null;
                    this.setIndexedName();
                    if (!this.running.booleanValue()) continue;
                    object = this.executableWrapper;
                    synchronized (object) {
                        if (this.supplier.addPoolableSleepingThreadFunction.apply(this) == null) {
                            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not add thread '{}' to poolable sleeping container: it will be shutted down", this);
                            this.shutDown();
                            continue;
                        }
                        Poolable[] poolableArray = this.supplier.poolableSleepingThreads;
                        synchronized (poolableArray) {
                            this.supplier.poolableSleepingThreads.notifyAll();
                        }
                        this.setPriority(this.supplier.defaultThreadPriority);
                        this.executableWrapper.wait();
                    }
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                    this.shutDown();
                }
            }
            this.removePermanently();
            object = this.supplier.poolableSleepingThreads;
            synchronized (object) {
                this.supplier.poolableSleepingThreads.notifyAll();
            }
            object = this.executableWrapper;
            synchronized (object) {
                this.executableWrapper.notifyAll();
            }
        }

        private void runExecutable() {
            ThrowingConsumer executable = (ThrowingConsumer)this.executableWrapper.get();
            try {
                executable.accept(this);
            }
            catch (Throwable exc) {
                if (executable != null) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                }
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "The thread runned a null executable");
                if (this.executableWrapper.get() == null) {
                    int waitTime = 10;
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Executable is still null: thread will wait {} milliseconds until next retry", waitTime);
                    Poolable.waitFor(waitTime);
                }
                this.runExecutable();
            }
        }

        @Override
        void removePermanently() {
            if (this.supplier.runningThreads.remove(this, this)) {
                --this.supplier.threadCount;
                --this.supplier.poolableThreadCount;
            }
            if (this.supplier.removePoolableSleepingThread(this)) {
                --this.supplier.threadCount;
                --this.supplier.poolableThreadCount;
            }
        }
    }

    public static class Holder
    implements Closeable {
        private Supplier threadSupplier;
        private Map<String, Thread> threads;

        private Holder() {
            this(StaticComponentContainer.ThreadSupplier);
        }

        private Holder(Supplier threadSupplier) {
            this.threadSupplier = threadSupplier;
            this.threads = new ConcurrentHashMap<String, Thread>();
        }

        public static Holder create(Supplier supplier, boolean undestroyable) {
            if (undestroyable) {
                return new Holder(supplier){
                    StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                    @Override
                    public void close() {
                        String shutDownRequestorClass = StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName();
                        if (shutDownRequestorClass.equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                            super.close();
                        } else {
                            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "{} is not authorized to shutdown {}", shutDownRequestorClass, this);
                        }
                    }
                };
            }
            return new Holder(supplier);
        }

        public String startLooping(boolean isDaemon, int priority, Consumer<Thread> executable) {
            return this.start(null, true, isDaemon, priority, executable).getName();
        }

        public String start(boolean isDaemon, int priority, Consumer<Thread> executable) {
            return this.start(null, false, isDaemon, priority, executable).getName();
        }

        public void startLooping(String threadName, boolean isDaemon, int priority, Consumer<Thread> executable) {
            this.start(threadName, true, isDaemon, priority, executable);
        }

        public void start(String threadName, boolean isDaemon, int priority, Consumer<Thread> executable) {
            this.start(threadName, false, isDaemon, priority, executable);
        }

        private Thread start(String threadName, boolean isLooper, boolean isDaemon, int priority, Consumer<Thread> executable) {
            return StaticComponentContainer.Synchronizer.execute(threadName, () -> {
                Thread thr = this.threads.get(threadName);
                if (thr != null) {
                    this.stop(threadName);
                }
                thr = this.threadSupplier.createDetachedThread().setExecutable(thread -> {
                    try {
                        executable.accept((Thread)thread);
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                    }
                }, isLooper);
                if (threadName != null) {
                    thr.setName(threadName);
                }
                thr.setPriority(priority);
                thr.setDaemon(isDaemon);
                this.threads.put(threadName, thr);
                thr.start();
                return thr;
            });
        }

        public void stop(String threadName) {
            this.stop(threadName, false);
        }

        public void stop(String threadName, boolean waitThreadToFinish) {
            StaticComponentContainer.Synchronizer.execute(threadName, () -> {
                Thread thr = this.threads.get(threadName);
                if (thr == null) {
                    return;
                }
                this.threads.remove(threadName);
                thr.shutDown(waitThreadToFinish);
                thr = null;
            });
        }

        public void join(String threadName) {
            Thread thr = this.threads.get(threadName);
            if (thr != null) {
                try {
                    thr.join();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                }
            }
        }

        public boolean isAlive(String threadName) {
            Thread thr = this.threads.get(threadName);
            if (thr != null) {
                return thr.running;
            }
            return false;
        }

        @Override
        public void close() {
            this.threads.forEach((threadName, thread) -> {
                thread.shutDown();
                this.threads.remove(threadName);
            });
            this.threads = null;
            this.threadSupplier = null;
        }
    }
}

