/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.preferences;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.wst.validation.internal.core.Message;

public final class ValidationMessageFactory {
    public static Message createFromDiagnostic(Diagnostic diagnostic, int offset, int length, IFile file, ValidationPreferences prefs) {
        ELValidationPreferences elPrefs = prefs.getElPrefs();
        int severity = elPrefs.getDiagnosticSeverity(diagnostic.getCode());
        MyLocalizedMessage message = new MyLocalizedMessage(ValidationMessageFactory.convertSeverity(severity), diagnostic.getMessage(), (IResource)file, diagnostic.getCode());
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    private static int convertSeverity(int severity) {
        switch (severity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 0;
    }

    private ValidationMessageFactory() {
    }

    static class MyLocalizedMessage
    extends Message {
        private final String _message;
        private final int _errorCode;

        public MyLocalizedMessage(int severity, String messageText, IResource targetObject, int errorCode) {
            this(severity, messageText, (Object)targetObject, errorCode);
        }

        private MyLocalizedMessage(int severity, String messageText, Object targetObject, int errorCode) {
            super(JSFCorePlugin.getDefault().getBundle().getSymbolicName(), severity, messageText);
            this._message = messageText;
            this.setTargetObject(targetObject);
            this._errorCode = errorCode;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public int getErrorCode() {
            return this._errorCode;
        }

        public boolean appliesTo(int offset) {
            return offset >= this.getOffset() && offset < this.getOffset() + this.getLength();
        }
    }
}

