/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.runtime;

import org.eclipse.wst.jsdt.internal.core.runtime.RuntimeMessages;

public class JSRunnerConfiguration {
    private String fFileToLaunch;
    private String[] fJavaScriptRuntimeArgs;
    private String[] fProgramArgs;
    private String[] fEnvironment;
    private String fWorkingDirectory;
    private static final String[] fgEmpty = new String[0];

    public JSRunnerConfiguration(String fileToLaunch) {
        if (fileToLaunch == null) {
            throw new IllegalArgumentException(RuntimeMessages.JSRunnerConfiguration_NullFile_Error);
        }
        this.fFileToLaunch = fileToLaunch;
    }

    public void setJSRuntimeArguments(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(RuntimeMessages.JSRunnerConfiguration_NullRuntimeArgs_Error);
        }
        this.fJavaScriptRuntimeArgs = args;
    }

    public void setProgramArguments(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(RuntimeMessages.JSRunnerConfiguration_NullProgramArgs_Error);
        }
        this.fProgramArgs = args;
    }

    public void setEnvironment(String[] environment) {
        this.fEnvironment = environment;
    }

    public String getFileToLaunch() {
        return this.fFileToLaunch;
    }

    public String[] getJSRuntimeArguments() {
        if (this.fJavaScriptRuntimeArgs == null) {
            return fgEmpty;
        }
        return this.fJavaScriptRuntimeArgs;
    }

    public String[] getProgramArguments() {
        if (this.fProgramArgs == null) {
            return fgEmpty;
        }
        return this.fProgramArgs;
    }

    public String[] getEnvironment() {
        return this.fEnvironment;
    }

    public void setWorkingDirectory(String path) {
        this.fWorkingDirectory = path;
    }

    public String getWorkingDirectory() {
        return this.fWorkingDirectory;
    }
}

