/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ExpandEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;

public class ExpandCompartmentShapeFeature
extends AbstractCustomFeature {
    public ExpandCompartmentShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        PictogramElement el = context.getPictogramElements()[0];
        Object ob = this.getFeatureProvider().getBusinessObjectForPictogramElement(el);
        int pictogramHeight = 13;
        int newHeight = 5;
        final ContainerShape containerShape = (ContainerShape)el;
        if (ob == null) {
            newHeight = GraphicsUpdater.increaseCompartmentHeigth(containerShape, newHeight);
        }
        final int pictHeight = pictogramHeight + newHeight;
        final GraphicsAlgorithm algo = el.getGraphicsAlgorithm();
        final ContainerShape entityShape = containerShape.getContainer();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)algo);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                algo.setHeight(pictHeight);
                int height = GraphicsUpdater.getPrimaryShape(entityShape).getGraphicsAlgorithm().getHeight() + GraphicsUpdater.getRelationShape(entityShape).getGraphicsAlgorithm().getHeight() + GraphicsUpdater.getBasicShape(entityShape).getGraphicsAlgorithm().getHeight() + 30;
                if (height > entityShape.getGraphicsAlgorithm().getHeight()) {
                    CustomContext cont = new CustomContext(new PictogramElement[]{entityShape});
                    ExpandEntityFeature expandEntity = new ExpandEntityFeature(ExpandCompartmentShapeFeature.this.getFeatureProvider());
                    expandEntity.execute((ICustomContext)cont);
                }
                GraphicsUpdater.updateEntityShape(entityShape);
                GraphicsUpdater.setCollapsed(containerShape, false);
                JPAEditorUtil.rearrangeAllConnections(entityShape, ExpandCompartmentShapeFeature.this.getFeatureProvider(), false);
            }
        });
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement[] pes;
        boolean ret = false;
        if (context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length > 0) {
            boolean expandPossible = false;
            int i = 0;
            while (i < pes.length) {
                PictogramElement pe = pes[i];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo != null) {
                    expandPossible = false;
                    return false;
                }
                if (!expandPossible && GraphicsUpdater.isCollapsed((ContainerShape)pe)) {
                    expandPossible = true;
                }
                ++i;
            }
            if (expandPossible) {
                return true;
            }
        }
        return ret;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

