/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.resources.IFileUtils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FileUtils
implements IFileUtils {
    private static IFileUtils utils = null;
    private static int index = 0;

    public static IFileUtils getInstance() {
        if (utils == null) {
            utils = new FileUtils();
        }
        return utils;
    }

    @Override
    public final List<IEditorPart> getEditorsByFileLocation(String fileLocation) throws FileNotFoundException {
        List<ICompilationUnit> units = this.getCompilationUnits(fileLocation);
        HashSet<IEditorPart> editors = new HashSet<IEditorPart>();
        for (ICompilationUnit cu : units) {
            IEditorDescriptor editorDescr = this.getEditorDescriptor(cu.getElementName());
            editors.addAll(this.getEditorsByCompilationUnit(editorDescr, this.getActiveWorkbenchPage(), cu));
        }
        return Arrays.asList(editors.toArray(new IEditorPart[editors.size()]));
    }

    @Override
    public final List<ICompilationUnit> getCompilationUnits(String fileLocation) throws FileNotFoundException {
        if (fileLocation == null) {
            throw new NullPointerException("fileLocation");
        }
        IFile[] filesFound = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(fileLocation).toURI());
        if (filesFound == null || filesFound.length == 0) {
            throw new FileNotFoundException("File: " + fileLocation + " does not exist");
        }
        ArrayList<ICompilationUnit> units = new ArrayList<ICompilationUnit>();
        IFile[] iFileArray = filesFound;
        int n = filesFound.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            IJavaElement javaElement = JavaCore.create((IFile)file);
            if (!(javaElement instanceof ICompilationUnit)) {
                throw new IllegalStateException("File: " + fileLocation + " is not a compilation unit");
            }
            units.add((ICompilationUnit)javaElement);
            ++n2;
        }
        return units;
    }

    @Override
    public IProject getProjectUnit(String fileLocation) throws FileNotFoundException {
        if (fileLocation == null) {
            throw new NullPointerException("fileLocation");
        }
        IFile file = this.getFileForLocation((IPath)new Path(fileLocation));
        if (file == null) {
            throw new FileNotFoundException("File: " + fileLocation + " does not exist");
        }
        return file.getProject();
    }

    @Override
    public final boolean isFileDisplayedInDirtyEditor(String fileLocation) throws FileNotFoundException {
        return this.isFileDisplayedInDirtyEditor(this.getEditorsByFileLocation(fileLocation));
    }

    @Override
    public boolean isCompilationUnitDisplayedInDirtyEditor(ICompilationUnit unit) {
        return this.isFileDisplayedInDirtyEditor(this.getEditorsByCompilationUnit(unit));
    }

    @Override
    public final void saveEditor(String fileLocation) throws FileNotFoundException {
        this.saveEditor(fileLocation, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void saveEditor(String fileLocation, IProgressMonitor monitor) throws FileNotFoundException {
        List<IEditorPart> editors = this.getEditorsByFileLocation(fileLocation);
        if (editors.size() == 0) {
            throw new IllegalStateException("The file is not displayed by an editor");
        }
        this.saveEditors(editors, monitor);
    }

    @Override
    public void saveEditor(ICompilationUnit cu, IProgressMonitor monitor) {
        List<IEditorPart> editors = this.getEditorsByCompilationUnit(cu);
        if (editors.size() == 0) {
            throw new IllegalStateException("The file is not displayed by an editor");
        }
        this.saveEditors(editors, monitor);
    }

    @Override
    public void saveEditor(ICompilationUnit cu) {
        List<IEditorPart> editors = this.getEditorsByCompilationUnit(cu);
        if (editors.size() == 0) {
            throw new IllegalStateException("The file is not displayed by an editor");
        }
        this.saveEditors(editors, (IProgressMonitor)new NullProgressMonitor());
    }

    private void saveEditors(List<IEditorPart> editors, IProgressMonitor monitor) {
        for (IEditorPart e : editors) {
            if (!e.isDirty()) continue;
            e.doSave(monitor);
        }
    }

    @Override
    public Collection<IEditorPart> getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private IEditorDescriptor getEditorDescriptor(String fileName) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        return editorRegistry.getDefaultEditor(fileName);
    }

    @Override
    public final URL fileOrURLToURL(URL base, String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        String localPath = path;
        URL localBase = base;
        if (localBase == null) {
            localBase = new URL("file:");
        }
        localPath = localPath.replace('\\', '/');
        try {
            String protocol = localBase.getProtocol();
            if (!("http".equals(protocol) || "https".equals(protocol) || localPath.charAt(1) != ':' && localPath.charAt(0) != '/' && localPath.charAt(0) != '\\')) {
                localPath = new File(localPath).toURI().toURL().toExternalForm();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (localPath.startsWith("file:") && localPath.length() > 5 && localPath.charAt(5) != '/') {
            localPath = "file:/".concat(localPath.substring(5));
        } else if (localPath.startsWith("file://") && !localPath.startsWith("file:////") && !localPath.startsWith("file://localhost/")) {
            localPath = "file:////".concat(localPath.substring("file://".length()));
        }
        URL url = new URL(localBase, localPath);
        return url;
    }

    @Override
    public File createTempDirectory() {
        String tempDir = System.getProperty("java.io.tmpdir");
        File temp1 = new File(tempDir, String.valueOf(Integer.toString(this.hashCode())) + "_" + ++index);
        temp1.mkdir();
        return temp1;
    }

    @Override
    public void deleteDirectory(File directory) {
        if (directory == null) {
            return;
        }
        if (!directory.exists()) {
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        directory.delete();
    }

    @Override
    public IFile[] getFilesByExtension(IProject project, String extension) throws CoreException {
        ContractChecker.nullCheckParam(extension, "extension");
        ArrayList<IFile> foundFiles = new ArrayList<IFile>();
        this.getFilesByExtension(foundFiles, project.members(), extension);
        return foundFiles.toArray(new IFile[foundFiles.size()]);
    }

    private void getFilesByExtension(ArrayList<IFile> foundFiles, IResource[] currentResources, String extension) throws CoreException {
        int ii = 0;
        while (ii < currentResources.length) {
            if (currentResources[ii].getType() == 2) {
                this.getFilesByExtension(foundFiles, ((IFolder)currentResources[ii]).members(), extension);
            } else if (currentResources[ii].getType() == 1 && extension.equals(currentResources[ii].getFileExtension())) {
                foundFiles.add((IFile)currentResources[ii]);
            }
            ++ii;
        }
    }

    @Override
    public IFile getFileForLocation(IPath location) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    @Override
    public List<IEditorPart> getEditorsByCompilationUnit(ICompilationUnit cu) {
        ContractChecker.nullCheckParam(cu, "cu");
        IEditorDescriptor editorDescr = this.getEditorDescriptor(cu.getElementName());
        IWorkbenchPage wbPage = this.getActiveWorkbenchPage();
        if (wbPage == null) {
            return new ArrayList<IEditorPart>(0);
        }
        return this.getEditorsByCompilationUnit(editorDescr, wbPage, cu);
    }

    private List<IEditorPart> getEditorsByCompilationUnit(IEditorDescriptor editorDescriptor, IWorkbenchPage page, ICompilationUnit cu) {
        ArrayList<IEditorPart> editorPartReturned = new ArrayList<IEditorPart>();
        if (editorDescriptor != null && page != null) {
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReferece = iEditorReferenceArray[n2];
                IEditorPart editorPart = editorReferece.getEditor(true);
                if (this.isEditorApplicableForCu(editorPart, cu)) {
                    editorPartReturned.add(editorPart);
                }
                ++n2;
            }
        }
        return editorPartReturned;
    }

    private boolean isEditorApplicableForCu(IEditorPart editor, ICompilationUnit cu) {
        if (editor == null) {
            return false;
        }
        if (!(editor.getEditorInput() instanceof IFileEditorInput) || !(cu.getResource() instanceof IFile)) {
            return false;
        }
        IFile cuFile = (IFile)cu.getResource();
        IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
        return cuFile.equals((Object)editorInput.getFile());
    }

    public final boolean isFileDisplayedInDirtyEditor(List<IEditorPart> displayingEditors) {
        ContractChecker.nullCheckParam(displayingEditors, "displayingEditors");
        for (IEditorPart editor : displayingEditors) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFileContent(File sourceFile) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (FileReader fr = new FileReader(sourceFile);){
            char[] buff = new char[1024];
            int cnt = 0;
            while ((cnt = fr.read(buff)) > -1) {
                builder.append(buff, 0, cnt);
            }
        }
        return builder.toString();
    }

    @Override
    public void setCompilationUnitContent(ICompilationUnit unit, String content, boolean force, IProgressMonitor monitor) throws JavaModelException {
        ContractChecker.nullCheckParam(unit, "unit");
        ContractChecker.nullCheckParam(content, "content");
        unit.becomeWorkingCopy(monitor);
        try {
            unit.getBuffer().setContents(content);
            unit.commitWorkingCopy(force, monitor);
        }
        finally {
            unit.discardWorkingCopy();
        }
    }

    @Override
    public void setCompilationUnitContentAndSaveDirtyEditors(ICompilationUnit unit, String content, boolean force, IProgressMonitor monitor) throws JavaModelException {
        this.setCompilationUnitContent(unit, content, force, monitor);
        if (this.isCompilationUnitDisplayedInDirtyEditor(unit)) {
            this.saveEditor(unit);
        }
    }
}

