/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.WorkingCopy;

public class DestroyWorkingCopyOperation
extends CModelOperation {
    public DestroyWorkingCopyOperation(ICElement workingCopy) {
        super(new ICElement[]{workingCopy});
    }

    @Override
    protected void executeOperation() throws CModelException {
        WorkingCopy workingCopy = this.getWorkingCopy();
        workingCopy.close();
        ITranslationUnit originalElement = workingCopy.getOriginalElement();
        if (!workingCopy.getParent().exists()) {
            originalElement.close();
        }
        IWorkingCopy wc = CModelManager.getDefault().removeSharedWorkingCopy(workingCopy.bufferFactory, originalElement);
        CElementDelta delta = new CElementDelta(this.getCModel());
        delta.removed(workingCopy);
        this.addDelta(delta);
        this.removeReconcileDelta(workingCopy);
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

