/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.TmfUiTracer;
import org.eclipse.tracecompass.internal.tmf.ui.perspectives.TmfPerspectiveManager;
import org.eclipse.tracecompass.internal.tmf.ui.views.TmfAlignmentSynchronizer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventAdapterFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.tmf.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.tracecompass.tmf.core";
    private static Activator plugin;
    private TmfEventAdapterFactory fTmfEventAdapterFactory;
    private IPreferenceStore fCorePreferenceStore;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        TmfUiRefreshHandler.getInstance();
        TmfUiTracer.init();
        TmfTraceElement.init();
        TmfExperimentElement.init();
        TmfProjectRegistry.init();
        TmfPerspectiveManager.init();
        this.fTmfEventAdapterFactory = new TmfEventAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.fTmfEventAdapterFactory, ITmfEvent.class);
    }

    public void stop(BundleContext context) throws Exception {
        TmfUiTracer.stop();
        TmfUiRefreshHandler.getInstance().dispose();
        TmfAlignmentSynchronizer.getInstance().dispose();
        TmfProjectRegistry.dispose();
        TmfPerspectiveManager.dispose();
        plugin = null;
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.fTmfEventAdapterFactory);
        super.stop(context);
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.fCorePreferenceStore == null) {
            this.fCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_CORE_ID);
        }
        return this.fCorePreferenceStore;
    }

    public Image getImageFromPath(String path) {
        return this.getImageDescripterFromPath(path).createImage();
    }

    public ImageDescriptor getImageDescripterFromPath(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImageFromImageRegistry(String path) {
        Image icon = this.getImageRegistry().get(path);
        if (icon == null) {
            icon = this.getImageDescripterFromPath(path).createImage();
            plugin.getImageRegistry().put(path, icon);
        }
        return icon;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("icons/obj16/zoom_mask.bmp", this.getImageFromPath("icons/obj16/zoom_mask.bmp"));
        reg.put("icons/obj16/zoomin_obj.bmp", this.getImageFromPath("icons/obj16/zoomin_obj.bmp"));
        reg.put("icons/obj16/zoomout_obj.bmp", this.getImageFromPath("icons/obj16/zoomout_obj.bmp"));
        reg.put("icons/eview16/sequencediagram_view.gif", this.getImageFromPath("icons/eview16/sequencediagram_view.gif"));
        reg.put("icons/obj16/arrow_colapse.bmp", this.getImageFromPath("icons/obj16/arrow_colapse.bmp"));
        reg.put("icons/obj16/arrow_up.bmp", this.getImageFromPath("icons/obj16/arrow_up.bmp"));
        reg.put("icons/wizban/conflict_stat.gif", this.getImageFromPath("icons/wizban/conflict_stat.gif"));
    }

    public void logInfo(String message) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public void logInfo(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, message, exception));
    }

    public void logWarning(String message) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public void logWarning(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, exception));
    }

    public void logError(String message) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public void logError(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }
}

