/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.core.text;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.internal.core.text.FileNamePatternSearchScope;
import org.eclipse.search.internal.core.text.FilesOfScopeCalculator;

public abstract class TextSearchScope {
    public static TextSearchScope newSearchScope(IResource[] rootResources, Pattern fileNamePattern, boolean visitDerivedResources) {
        FileNamePatternSearchScope scope = FileNamePatternSearchScope.newSearchScope("", rootResources, visitDerivedResources);
        scope.setFileNamePattern(fileNamePattern);
        return scope;
    }

    public IResource[] getRoots() {
        return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
    }

    public abstract boolean contains(IResourceProxy var1);

    public IFile[] evaluateFilesInScope(MultiStatus status) {
        return new FilesOfScopeCalculator(this, status).process();
    }
}

