/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.consumer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartSeries;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.IDataConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.ISeriesConsumer;

public class XYSeriesConsumer
implements ISeriesConsumer {
    private final IDataConsumer fXConsumer;
    private final IDataConsumer fYConsumer;
    private final ChartSeries fChartSeries;
    private final List<Object> fConsumedElements = new ArrayList<Object>();

    public XYSeriesConsumer(ChartSeries series, IDataConsumer xConsumer, IDataConsumer yConsumer) {
        this.fChartSeries = series;
        this.fXConsumer = xConsumer;
        this.fYConsumer = yConsumer;
    }

    public void accept(Object obj) {
        if (!this.fXConsumer.test(obj) || !this.fYConsumer.test(obj)) {
            return;
        }
        this.fXConsumer.accept(obj);
        this.fYConsumer.accept(obj);
        this.fConsumedElements.add(obj);
    }

    public ChartSeries getSeries() {
        return this.fChartSeries;
    }

    public Collection<Object> getConsumedElements() {
        return ImmutableList.copyOf(this.fConsumedElements);
    }

    public IDataConsumer getXConsumer() {
        return this.fXConsumer;
    }

    public IDataConsumer getYConsumer() {
        return this.fYConsumer;
    }
}

