/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;

public class GenericEditorWithContentTypeIcon
implements IEditorDescriptor {
    private final IEditorDescriptor editorDescriptor;
    private final String fileName;

    public GenericEditorWithContentTypeIcon(String fileName, IEditorDescriptor editorDescriptor) {
        Assert.isNotNull((Object)editorDescriptor);
        this.fileName = fileName;
        this.editorDescriptor = editorDescriptor;
    }

    public String getId() {
        return this.editorDescriptor.getId();
    }

    public ImageDescriptor getImageDescriptor() {
        try {
            ImageDescriptor image = GenericEditorPlugin.getDefault().getContentTypeImagesRegistry().getImageDescriptor(Platform.getContentTypeManager().findContentTypesFor(this.fileName));
            if (image != null) {
                return image;
            }
        }
        catch (Exception e) {
            GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", e.getMessage(), (Throwable)e));
        }
        return this.editorDescriptor.getImageDescriptor();
    }

    public String getLabel() {
        return this.editorDescriptor.getLabel();
    }

    public boolean isInternal() {
        return this.editorDescriptor.isInternal();
    }

    public boolean isOpenInPlace() {
        return this.editorDescriptor.isOpenInPlace();
    }

    public boolean isOpenExternal() {
        return this.editorDescriptor.isOpenExternal();
    }

    public IEditorMatchingStrategy getEditorMatchingStrategy() {
        return this.editorDescriptor.getEditorMatchingStrategy();
    }
}

